/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServletImplInvocationHandler
implements InvocationHandler {
    private static Logger logger = LogDomains.getLogger(ServletImplInvocationHandler.class, (String)"javax.enterprise.system.container.web");
    private Object servletImplDelegate;
    private Class servletImplClass;

    public ServletImplInvocationHandler(Object delegate) {
        this.servletImplDelegate = delegate;
        this.servletImplClass = delegate.getClass();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> methodClass = method.getDeclaringClass();
        if (methodClass == Object.class) {
            return this.invokeJavaObjectMethod(this, method, args);
        }
        Object returnValue = null;
        try {
            Method implMethod = this.servletImplClass.getMethod(method.getName(), method.getParameterTypes());
            returnValue = implMethod.invoke(this.servletImplDelegate, args);
        }
        catch (InvocationTargetException ite) {
            logger.log(Level.FINE, "", ite);
            throw ite.getCause();
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "Error invoking servlet impl", t);
            throw t;
        }
        return returnValue;
    }

    private Object invokeJavaObjectMethod(InvocationHandler handler, Method method, Object[] args) throws Throwable {
        Object returnValue = null;
        switch (method.getName().charAt(0)) {
            case 'e': {
                Object other = Proxy.isProxyClass(args[0].getClass()) ? Proxy.getInvocationHandler(args[0]) : args[0];
                returnValue = new Boolean(handler.equals(other));
                break;
            }
            case 'h': {
                returnValue = new Integer(handler.hashCode());
                break;
            }
            case 't': {
                returnValue = handler.toString();
                break;
            }
            default: {
                throw new Throwable("Object method " + method.getName() + "not found");
            }
        }
        return returnValue;
    }
}

