/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.handler.MessageContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.api.EJBInvocation;
import org.glassfish.webservices.WebServiceContractImpl;
import org.w3c.dom.Element;

public final class WebServiceContextImpl
implements WSWebServiceContext {
    public static final ThreadLocal msgContext = new ThreadLocal();
    public static final ThreadLocal principal = new ThreadLocal();
    private WSWebServiceContext jaxwsContextDelegate;
    private final String JAXWS_SERVLET = "org.glassfish.webservices.JAXWSServlet";
    private String servletName;

    public void setContextDelegate(WSWebServiceContext wsc) {
        this.jaxwsContextDelegate = wsc;
    }

    public MessageContext getMessageContext() {
        return this.jaxwsContextDelegate.getMessageContext();
    }

    public void setMessageContext(MessageContext ctxt) {
        msgContext.set(ctxt);
    }

    public void setUserPrincipal(Principal p) {
        principal.set(p);
    }

    public Principal getUserPrincipal() {
        Principal p = (Principal)principal.get();
        if (p != null) {
            return p;
        }
        return this.jaxwsContextDelegate.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
        InvocationManager mgr = wscImpl.getInvocationManager();
        if (ComponentInvocation.ComponentInvocationType.EJB_INVOCATION.equals((Object)mgr.getCurrentInvocation().getInvocationType())) {
            EJBInvocation inv = (EJBInvocation)mgr.getCurrentInvocation();
            boolean res = inv.isCallerInRole(role);
            return res;
        }
        return this.jaxwsContextDelegate.isUserInRole(role);
    }

    public EndpointReference getEndpointReference(Class clazz, Element ... params) {
        return this.jaxwsContextDelegate.getEndpointReference(clazz, params);
    }

    public EndpointReference getEndpointReference(Element ... params) {
        return this.jaxwsContextDelegate.getEndpointReference(params);
    }

    public Packet getRequestPacket() {
        return this.jaxwsContextDelegate.getRequestPacket();
    }

    void setServletName(Set webComponentDescriptors) {
        Iterator it = webComponentDescriptors.iterator();
        String endpointName = null;
        while (it.hasNext()) {
            WebComponentDescriptor desc = (WebComponentDescriptor)it.next();
            String name = desc.getCanonicalName();
            if ("org.glassfish.webservices.JAXWSServlet".equals(desc.getWebComponentImplementation())) {
                endpointName = name;
            }
            if (!desc.getSecurityRoleReferences().hasMoreElements()) continue;
            this.servletName = name;
            break;
        }
        if (this.servletName == null) {
            this.servletName = endpointName;
        }
    }
}

