/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.impl.core.ComputedParamsHandlerManager;
import org.glassfish.flashlight.provider.FlashlightProbe;

public class ReflectiveClientInvoker
implements ProbeClientInvoker {
    private int id;
    private Object target;
    private Method method;
    private String[] paramNames;
    boolean hasComputedParams;
    int[] probeIndices;
    boolean useProbeArgs;

    public ReflectiveClientInvoker(int id, Object target, Method method, String[] clientParamNames, FlashlightProbe probe) {
        int index;
        this.id = id;
        this.target = target;
        this.method = method;
        this.paramNames = clientParamNames;
        int size = clientParamNames.length;
        this.probeIndices = new int[size];
        String[] probeParamNames = probe.getProbeParamNames();
        HashMap<String, Integer> probeParamIndexMap = new HashMap<String, Integer>();
        for (index = 0; index < probeParamNames.length; ++index) {
            probeParamIndexMap.put(probeParamNames[index], index);
        }
        for (index = 0; index < size; ++index) {
            int actualIndex;
            if (clientParamNames[index].startsWith("$")) {
                this.hasComputedParams = true;
                this.probeIndices[index] = -1;
                continue;
            }
            this.probeIndices[index] = actualIndex = ((Integer)probeParamIndexMap.get(clientParamNames[index])).intValue();
        }
        if (!this.hasComputedParams) {
            this.useProbeArgs = true;
            for (index = 0; index < size; ++index) {
                int probeParamIndex = (Integer)probeParamIndexMap.get(this.paramNames[index]);
                if (index == probeParamIndex) continue;
                this.useProbeArgs = false;
                break;
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void invoke(Object[] args) {
        try {
            if (!this.useProbeArgs) {
                if (this.hasComputedParams) {
                    ComputedParamsHandlerManager cphm = ComputedParamsHandlerManager.getInstance();
                    int size = this.paramNames.length;
                    Object[] tempArgs = args;
                    args = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        args[i] = this.probeIndices[i] == -1 ? cphm.computeValue(this.paramNames[i]) : tempArgs[this.probeIndices[i]];
                    }
                } else {
                    int size = this.paramNames.length;
                    Object[] tempArgs = args;
                    args = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        args[i] = tempArgs[this.probeIndices[i]];
                    }
                }
            }
            this.method.invoke(this.target, args);
        }
        catch (Exception ex) {
            System.out.println("Error while invoking client: " + this.hasComputedParams + " ==> " + ex);
        }
    }
}

