/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.provider;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.glassfish.flashlight.impl.core.ProbeFactory;
import org.glassfish.flashlight.impl.core.ProbeProviderRegistry;
import org.glassfish.flashlight.impl.core.ProviderImplGenerator;
import org.glassfish.flashlight.impl.provider.ProbeProviderXMLParser;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.probe.provider.annotations.Probe;
import org.glassfish.probe.provider.annotations.ProbeParam;
import org.glassfish.probe.provider.annotations.ProbeProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class FlashlightProbeProviderFactory
implements ProbeProviderFactory {
    @Inject
    ProbeProviderEventManager ppem;
    private ConcurrentHashMap<String, Object> providerInfo = new ConcurrentHashMap();
    private boolean debug = false;
    private final HashMap<String, String> primTypes = new HashMap(){
        {
            this.put("int", "java.lang.Integer");
            this.put("byte", "java.lang.Byte");
            this.put("char", "java.lang.Character");
            this.put("short", "java.lang.Short");
            this.put("long", "java.lang.Long");
            this.put("float", "java.lang.Float");
            this.put("double", "java.lang.Double");
            this.put("boolean", "java.lang.Boolean");
            this.put("void", "java.lang.Void");
        }
    };

    @Override
    public <T> T getProbeProvider(Class<T> providerClazz) throws InstantiationException, IllegalAccessException {
        org.glassfish.external.probe.provider.annotations.ProbeProvider provAnn = providerClazz.getAnnotation(org.glassfish.external.probe.provider.annotations.ProbeProvider.class);
        if (provAnn != null) {
            return this.getProbeProvider(provAnn.moduleProviderName(), provAnn.moduleName(), provAnn.probeProviderName(), providerClazz);
        }
        ProbeProvider provAnnOLD = providerClazz.getAnnotation(ProbeProvider.class);
        return this.getProbeProvider(provAnnOLD.moduleProviderName(), provAnnOLD.moduleName(), provAnnOLD.probeProviderName(), providerClazz);
    }

    @Override
    public <T> T getProbeProvider(String moduleProviderName, String moduleName, String probeProviderName, Class<T> providerClazz) throws InstantiationException, IllegalAccessException {
        try {
            FlashlightProbeProvider provider = new FlashlightProbeProvider(moduleProviderName, moduleName, probeProviderName, providerClazz);
            for (Method m : providerClazz.getDeclaredMethods()) {
                Annotation[][] anns2;
                Probe pnameAnnOLD;
                int sz = m.getParameterTypes().length;
                String probeName = null;
                org.glassfish.external.probe.provider.annotations.Probe pnameAnn = m.getAnnotation(org.glassfish.external.probe.provider.annotations.Probe.class);
                probeName = pnameAnn != null ? (pnameAnn != null ? pnameAnn.name() : m.getName()) : ((pnameAnnOLD = m.getAnnotation(Probe.class)) != null ? pnameAnnOLD.name() : m.getName());
                String[] probeParamNames = new String[sz];
                int index = 0;
                Annotation[][] arr$ = anns2 = m.getParameterAnnotations();
                int len$ = arr$.length;
                block7: for (int i$ = 0; i$ < len$; ++i$) {
                    Annotation[] ann1;
                    for (Annotation ann : ann1 = arr$[i$]) {
                        org.glassfish.external.probe.provider.annotations.ProbeParam pParam;
                        if (ann instanceof org.glassfish.external.probe.provider.annotations.ProbeParam) {
                            pParam = (org.glassfish.external.probe.provider.annotations.ProbeParam)ann;
                            probeParamNames[index++] = pParam.value();
                            continue block7;
                        }
                        if (!(ann instanceof ProbeParam)) continue;
                        pParam = (ProbeParam)ann;
                        probeParamNames[index++] = pParam.value();
                        continue block7;
                    }
                }
                FlashlightProbe probe = ProbeFactory.createProbe(providerClazz, moduleProviderName, moduleName, probeProviderName, probeName, probeParamNames, m.getParameterTypes());
                probe.setProviderJavaMethodName(m.getName());
                provider.addProbe(probe);
            }
            Class<Object> tClazz = providerClazz;
            int mod = providerClazz.getModifiers();
            if (Modifier.isAbstract(mod)) {
                String generatedClassName = provider.getModuleProviderName() + "_Flashlight_" + provider.getModuleName() + "_" + "Probe_" + (provider.getProbeProviderName() == null ? providerClazz.getName() : provider.getProbeProviderName());
                generatedClassName = providerClazz.getName() + "_" + generatedClassName;
                try {
                    tClazz = providerClazz.getClassLoader().loadClass(generatedClassName);
                    return (T)tClazz.newInstance();
                }
                catch (ClassNotFoundException cnfEx) {
                    ProviderImplGenerator gen = new ProviderImplGenerator();
                    generatedClassName = gen.defineClass(provider, providerClazz);
                    try {
                        tClazz = providerClazz.getClassLoader().loadClass(generatedClassName);
                    }
                    catch (ClassNotFoundException cnfEx2) {
                        throw new RuntimeException(cnfEx2);
                    }
                }
            }
            ProbeProviderRegistry.getInstance().registerProbeProvider(provider, tClazz);
            T inst = tClazz.newInstance();
            if (this.ppem != null) {
                // empty if block
            }
            return inst;
        }
        catch (Exception e) {
            e.printStackTrace();
            return (T)Proxy.newProxyInstance(providerClazz.getClassLoader(), new Class[]{providerClazz}, new InvocationHandler(){

                public Object invoke(Object proxy, Method m, Object[] args) {
                    return null;
                }
            });
        }
    }

    @Override
    public void processXMLProbeProviders(ClassLoader cl, String xml) {
        this.mprint("processProbeProviderXML for " + xml);
        try {
            InputStream is = cl.getResourceAsStream(xml);
            ProbeProviderXMLParser providerXMLParser = new ProbeProviderXMLParser(is);
            List<ProbeProviderXMLParser.Provider> providers = providerXMLParser.getProviders();
            for (ProbeProviderXMLParser.Provider provider : providers) {
                this.mprint(provider.toString());
                this.registerProvider(cl, provider);
            }
        }
        catch (Exception e) {
            Logger.getLogger(FlashlightProbeProviderFactory.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void registerProvider(ClassLoader cl, ProbeProviderXMLParser.Provider provider) {
        String moduleProviderName = provider.getModuleProviderName();
        String moduleName = provider.getModuleName();
        String probeProviderName = provider.getProbeProviderName();
        String providerClass = provider.getProbeProviderClass();
        List<ProbeProviderXMLParser.Probe> probes = provider.getProbes();
        Class<?> providerClazz = null;
        try {
            providerClazz = cl.loadClass(providerClass);
            this.mprint("providerClazz = " + providerClazz);
        }
        catch (Exception e) {
            this.mprint(" Could not load the class ( " + providerClazz + " ) for the provider " + providerClass);
            e.printStackTrace();
        }
        this.mprint("moduleProviderName = " + moduleProviderName);
        this.mprint("moduleName = " + moduleName);
        this.mprint("probeProviderName = " + probeProviderName);
        this.mprint("probeProviderClass = " + providerClass);
        FlashlightProbeProvider flProvider = new FlashlightProbeProvider(moduleProviderName, moduleName, probeProviderName, providerClazz);
        for (ProbeProviderXMLParser.Probe probe : probes) {
            String probeName = probe.getProbeName();
            String probeMethod = probe.getProbeMethod();
            boolean errorParsingProbe = false;
            String[] probeParams = new String[probe.getProbeParams().size()];
            Class[] paramTypes = new Class[probe.getProbeParams().size()];
            int i = 0;
            for (ProbeProviderXMLParser.ProbeParam param : probe.getProbeParams()) {
                probeParams[i] = param.getName();
                this.mprint("          probeParam[" + i + "] = " + probeParams[i]);
                paramTypes[i] = this.getParamType(cl, param.getType());
                if (paramTypes[i] == null) {
                    errorParsingProbe = true;
                    Logger.getLogger(FlashlightProbeProviderFactory.class.getName()).log(Level.SEVERE, "Cannot resolve the paramTypes, unable to create this probe - " + probeName);
                    break;
                }
                ++i;
            }
            if (errorParsingProbe) {
                errorParsingProbe = false;
                continue;
            }
            FlashlightProbe flProbe = ProbeFactory.createProbe(providerClazz, moduleProviderName, moduleName, probeProviderName, probeName, probeParams, paramTypes);
            flProbe.setProviderJavaMethodName(probeMethod);
            this.mprint(" Constructed probe === " + flProbe.toString());
            flProvider.addProbe(flProbe);
        }
        if (flProvider.getProbes().size() == 0) {
            return;
        }
        ProbeProviderRegistry.getInstance().registerProbeProvider(flProvider, providerClazz);
        this.mprint(" Provider registered successfully - " + probeProviderName);
    }

    private Class<?> getParamType(ClassLoader cl, String paramTypeStr) {
        Class<?> paramType = null;
        try {
            String primType = this.primTypes.get(paramTypeStr);
            if (primType != null) {
                this.mprint("          paramType = " + primType);
                return cl.loadClass(primType);
            }
            paramType = cl.loadClass(paramTypeStr);
        }
        catch (ClassNotFoundException ex) {
            try {
                paramType = cl.loadClass("java.lang." + paramTypeStr);
            }
            catch (Exception e) {
                Logger.getLogger(FlashlightProbeProviderFactory.class.getName()).log(Level.SEVERE, "Cannot resolve the paramTypes of the probe, tried " + paramTypeStr + " and now the following - Try giving a fully qualified name for the type", e);
            }
        }
        this.mprint("          paramType = " + paramType);
        return paramType;
    }

    private void mprint(String str) {
        if (this.debug) {
            System.out.println("APK: " + str);
        }
    }
}

