/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ProbeRegistry {
    private static ProbeRegistry _me = new ProbeRegistry();
    private static ConcurrentHashMap<Integer, FlashlightProbe> probeMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, FlashlightProbe> probeDesc2ProbeMap = new ConcurrentHashMap();

    public static ProbeRegistry getInstance() {
        return _me;
    }

    public static ProbeRegistry createInstance() {
        if (_me == null) {
            _me = new ProbeRegistry();
        }
        return _me;
    }

    public void registerProbe(FlashlightProbe probe) {
        probeMap.put(probe.getId(), probe);
        probeDesc2ProbeMap.put(probe.getProbeDesc(), probe);
    }

    public void unregisterProbe(FlashlightProbe probe) {
        probeMap.remove(probe.getId());
    }

    public void unregisterProbe(int id) {
        probeMap.remove(id);
    }

    public FlashlightProbe getProbe(int id) {
        return probeMap.get(id);
    }

    public FlashlightProbe getProbe(String probeStr) {
        return probeDesc2ProbeMap.get(probeStr);
    }

    public static FlashlightProbe getProbeById(int id) {
        return _me.getProbe(id);
    }

    public Collection<FlashlightProbe> getAllProbes() {
        return probeMap.values();
    }

    public static void invokeProbe(int id, Object[] args) {
        FlashlightProbe probe = probeMap.get(id);
        if (probe != null) {
            probe.fireProbe(args);
        }
    }
}

