/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.deployment.node.SaxParserHandlerBundled;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.ACCLogger;
import org.glassfish.appclient.client.acc.AgentArguments;
import org.glassfish.appclient.client.acc.AppClientContainer;
import org.glassfish.appclient.client.acc.AppclientCommandArguments;
import org.glassfish.appclient.client.acc.CommandLaunchInfo;
import org.glassfish.appclient.client.acc.TargetServerHelper;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.appclient.client.acc.config.ClientContainer;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.LogService;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientFacade {
    private static final String SUN_ACC_CONTENT_PROPERTY_NAME = "sun-acc.xml.content";
    private static final Class<?> stringsAnchor = ACCClassLoader.class;
    private static LocalStringManager localStrings = new LocalStringManagerImpl(stringsAnchor);
    private static CommandLaunchInfo launchInfo = null;
    private static AppclientCommandArguments appClientCommandArgs = null;
    private static URI installRootURI = null;
    private static AppClientContainer acc = null;
    private static boolean isJWS = false;

    public static void main(String[] args) {
        try {
            if (acc == null) {
                AppClientFacade.prepareACC(null, null);
            }
            acc.launch(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UserError ue) {
            ue.displayAndExit();
        }
    }

    public static AppClientContainer acc() {
        return acc;
    }

    public static void launch(String[] args) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException, SAXParseException, InjectionException {
        acc.launch(args);
    }

    public static void prepareACC(String agentArgsText, Instrumentation inst) throws UserError, MalformedURLException, URISyntaxException, JAXBException, FileNotFoundException, ParserConfigurationException, SAXException, IOException, Exception {
        JavaVersion javaVersion = new JavaVersion();
        if (javaVersion.asInt() < 16) {
            throw new UserError(localStrings.getLocalString(stringsAnchor, "main.badVersion", "Current Java version {0} is too low; {1} or later required", new Object[]{javaVersion.versionString, "1.6"}));
        }
        AgentArguments agentArgs = AgentArguments.newInstance(agentArgsText);
        ArrayList<String> effectiveCommandLineArgs = new ArrayList<String>();
        effectiveCommandLineArgs.addAll(agentArgs.unnamedValues());
        AppclientCommandArguments appClientCommandArgs = AppclientCommandArguments.newInstance(effectiveCommandLineArgs);
        if (appClientCommandArgs.isUsage() || appClientCommandArgs.isHelp()) {
            AppClientFacade.usage(0);
        }
        launchInfo = CommandLaunchInfo.newInstance(agentArgsText);
        ACCClassLoader loader = AppClientFacade.initClassLoader(System.getenv("APPCPATH"), inst == null);
        Thread.currentThread().setContextClassLoader(loader);
        isJWS = Boolean.getBoolean("appclient.is.jws");
        AppClientFacade.initInstallRootProperty();
        if (launchInfo.getClientLaunchType() == CommandLaunchInfo.ClientLaunchType.UNKNOWN) {
            throw new IllegalArgumentException();
        }
        appClientCommandArgs = launchInfo.getAppclientCommandArguments();
        ClientContainer clientContainer = AppClientFacade.readConfig(appClientCommandArgs.getConfigFilePath(), loader);
        TargetServer[] targetServers = TargetServerHelper.targetServers(clientContainer, appClientCommandArgs.getTargetServer());
        AppClientContainer.Builder builder = AppClientFacade.createBuilder(targetServers, clientContainer.getLogService(), appClientCommandArgs);
        AppClientContainer newACC = AppClientFacade.createContainer(builder, launchInfo);
        newACC.prepare(inst);
        acc = newACC;
    }

    private static void initInstallRootProperty() throws URISyntaxException {
        URI jarURI = ACCClassLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        if (jarURI.getScheme().startsWith("http")) {
            return;
        }
        File jarFile = new File(jarURI);
        File dirFile = jarFile.getParentFile().getParentFile();
        installRootURI = dirFile.toURI();
        System.setProperty("com.sun.aas.installRoot", dirFile.getAbsolutePath());
    }

    private static AppClientContainer prepareACC() {
        return null;
    }

    private static void usage(int exitStatus) {
        System.err.println(AppClientFacade.getUsage());
        System.exit(exitStatus);
    }

    private static String getUsage() {
        return localStrings.getLocalString(stringsAnchor, "main.usage", "appclient [ <classfile> | -client <appjar> ] [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [-user <username>] [-password <password>|-passwordfile <password-file>] [-targetserver host[:port][,host[:port]...] [app-args]") + System.getProperty("line.separator") + localStrings.getLocalString(stringsAnchor, "main.usage.1", "  or  :\n\tappclient [ <valid JVM options and valid ACC options> ] [ <appClass-name> | -jar <appjar> ] [app args]");
    }

    private static List<String> skipJVMArgs(List<String> options) {
        ArrayList<String> result = new ArrayList<String>();
        int slot = 0;
        boolean isClassSelected = false;
        while (slot < options.size()) {
            String option = options.get(slot);
            if (isClassSelected) {
                result.add(option);
                continue;
            }
            if (option.equals("-jar") || option.equals("-client")) {
                isClassSelected = true;
                if (slot >= options.size()) {
                    throw new IllegalArgumentException(option);
                }
                ++slot;
                continue;
            }
            if (option.charAt(0) != '-') {
                isClassSelected = true;
                continue;
            }
            if (!option.equals("-classpath") && !option.equals("-cp")) continue;
            if (slot >= options.size()) {
                throw new IllegalArgumentException(option);
            }
            ++slot;
        }
        return result;
    }

    private static ACCClassLoader initClassLoader(String appcPath, boolean loaderShouldTransform) throws MalformedURLException {
        ACCClassLoader newLoader = ACCClassLoader.newInstance(Thread.currentThread().getContextClassLoader(), loaderShouldTransform);
        if (appcPath != null) {
            for (String elt : appcPath.split(File.pathSeparator)) {
                File f = new File(elt);
                newLoader.appendURL(f.toURI().toURL());
            }
        }
        return newLoader;
    }

    private static AppClientContainer.Builder createBuilder(TargetServer[] targetServers, LogService logService, AppclientCommandArguments appClientCommandArgs) throws IOException {
        AppClientContainer.Builder builder = AppClientContainer.newBuilder(targetServers);
        AppClientFacade.updateClientCredentials(builder, appClientCommandArgs);
        builder.logger(new ACCLogger(logService));
        return builder;
    }

    private static void updateClientCredentials(AppClientContainer.Builder builder, AppclientCommandArguments appClientCommandArgs) {
        char[] commandLinePW;
        ClientCredential cc = builder.getClientCredential();
        String user = cc != null ? cc.getUserName() : null;
        char[] pw = cc != null && cc.getPassword() != null ? cc.getPassword().get() : null;
        String commandLineUser = appClientCommandArgs.getUser();
        if (commandLineUser != null) {
            user = commandLineUser;
        }
        if ((commandLinePW = appClientCommandArgs.getPassword()) != null) {
            pw = commandLinePW;
        }
        builder.clientCredentials(user, pw);
    }

    private static AppClientContainer createContainer(AppClientContainer.Builder builder, CommandLaunchInfo launchInfo) throws Exception, UserError {
        CommandLaunchInfo.ClientLaunchType launchType = launchInfo.getClientLaunchType();
        AppClientContainer container = null;
        switch (launchType) {
            case JAR: 
            case DIR: {
                container = AppClientFacade.createContainerForAppClientArchiveOrDir(builder, launchInfo.getClientName(), launchInfo.getAppclientCommandArguments().getMainclass(), launchInfo.getAppclientCommandArguments().getName());
                break;
            }
            case URL: {
                container = AppClientFacade.createContainerForJWSLaunch(builder, launchInfo.getClientName(), launchInfo.getAppclientCommandArguments().getMainclass(), launchInfo.getAppclientCommandArguments().getName());
                break;
            }
            case CLASS: {
                container = AppClientFacade.createContainerForClassName(builder, launchInfo.getClientName());
                break;
            }
            case CLASSFILE: {
                container = AppClientFacade.createContainerForClassFile(builder, launchInfo.getClientName());
            }
        }
        if (container == null) {
            throw new IllegalArgumentException("cannot choose app client launch type");
        }
        return container;
    }

    private static AppClientContainer createContainerForAppClientArchiveOrDir(AppClientContainer.Builder builder, String appClientPath, String mainClassName, String clientName) throws Exception, UserError {
        URI uri = Util.getURI(new File(appClientPath));
        return builder.newContainer(uri, null, mainClassName, clientName);
    }

    private static AppClientContainer createContainerForJWSLaunch(AppClientContainer.Builder builder, String appClientPath, String mainClassName, String clientName) throws Exception, UserError {
        URI uri = URI.create(appClientPath);
        return builder.newContainer(uri, null, mainClassName, clientName);
    }

    private static AppClientContainer createContainerForClassName(AppClientContainer.Builder builder, String className) throws Exception, UserError {
        ClassLoader loader = AppClientFacade.prepareLoaderToFindClassFile(Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> mainClass = Class.forName(className, true, loader);
        AppClientContainer result = builder.newContainer(mainClass);
        return result;
    }

    private static ClassLoader prepareLoaderToFindClassFile(ClassLoader currentLoader) throws MalformedURLException {
        File currentDirPath = new File(System.getProperty("user.dir"));
        URLClassLoader newLoader = new URLClassLoader(new URL[]{currentDirPath.toURI().toURL()}, currentLoader);
        return newLoader;
    }

    private static AppClientContainer createContainerForClassFile(AppClientContainer.Builder builder, String classFilePath) throws MalformedURLException, ClassNotFoundException, FileNotFoundException, IOException, Exception, UserError {
        Util.verifyFilePath(classFilePath);
        String className = classFilePath.substring(0, classFilePath.lastIndexOf(".class")).replace(File.separatorChar, '.');
        return AppClientFacade.createContainerForClassName(builder, className);
    }

    private static ClientContainer readConfig(String configPath, ClassLoader loader) throws UserError, JAXBException, FileNotFoundException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        Reader configReader;
        ClientContainer result = null;
        String configInProperty = System.getProperty(SUN_ACC_CONTENT_PROPERTY_NAME);
        if (configInProperty != null) {
            File securityConfigTempFile = Util.writeTextToTempFile(configInProperty, "wss-client-config", ".xml", false);
            Properties p = new Properties();
            p.setProperty("security.config.path", securityConfigTempFile.getAbsolutePath());
            configInProperty = Util.replaceTokens(configInProperty, p);
            configReader = new StringReader(configInProperty);
        } else {
            File configFile = AppClientFacade.checkXMLFile(configPath);
            AppClientFacade.checkXMLFile(launchInfo.getAppclientCommandArguments().getConfigFilePath());
            configReader = new FileReader(configFile);
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(true);
        spf.setNamespaceAware(true);
        SAXParser parser = spf.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setEntityResolver((EntityResolver)new SaxParserHandlerBundled());
        InputSource inputSource = AppClientFacade.replaceTokensForParsing(configReader);
        SAXSource saxSource = new SAXSource(reader, inputSource);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ClientContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        result = (ClientContainer)u.unmarshal((Source)saxSource);
        return result;
    }

    private static InputSource replaceTokensForParsing(Reader reader) throws FileNotFoundException, IOException, URISyntaxException {
        int charsRead;
        char[] buffer = new char[1024];
        CharArrayWriter writer = new CharArrayWriter();
        while ((charsRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, charsRead);
        }
        writer.close();
        reader.close();
        HashMap<String, String> mapping = new HashMap<String, String>();
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            mapping.put(propName, props.getProperty(propName));
        }
        TokenResolver resolver = new TokenResolver(mapping);
        String configWithTokensReplaced = resolver.resolve(writer.toString());
        InputSource inputSource = new InputSource(new StringReader(configWithTokensReplaced));
        return inputSource;
    }

    private static File checkXMLFile(String xmlFullName) throws UserError {
        try {
            File f = new File(xmlFullName);
            if (f != null && f.exists() && f.isFile() && f.canRead()) {
                return f;
            }
            AppClientFacade.xmlMessage(xmlFullName);
            return null;
        }
        catch (Exception ex) {
            AppClientFacade.xmlMessage(xmlFullName);
            return null;
        }
    }

    private static void xmlMessage(String xmlFullName) throws UserError {
        UserError ue = new UserError(localStrings.getLocalString(stringsAnchor, "main.cannot_read_clientContainer_xml", "Client Container xml: {0} not found or unable to read.\nYou may want to use the -xml option to locate your configuration xml.", (Object[])new String[]{xmlFullName}));
        ue.setUsage(AppClientFacade.getUsage());
        throw ue;
    }

    private static class JavaVersion {
        private String versionString = System.getProperty("java.version");
        private int versionAsInt = this.initVersionAsInt();

        private JavaVersion() {
        }

        private int initVersionAsInt() {
            int firstDot = this.versionString.indexOf(".");
            String tensString = this.versionString.substring(0, firstDot);
            int nextDot = this.versionString.indexOf(".", firstDot + 1);
            if (nextDot < 0) {
                nextDot = this.versionString.length();
            }
            String onesString = this.versionString.substring(firstDot + 1, nextDot);
            int version = -1;
            int tens = new Integer(tensString);
            int ones = new Integer(onesString);
            version = tens * 10 + ones;
            return version;
        }

        private int asInt() {
            return this.versionAsInt;
        }

        public String toString() {
            return this.versionString;
        }
    }
}

