/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataClass
extends MetadataAnnotatedElement {
    protected String superclass;
    protected List<String> interfaces;
    protected int modifiers;
    protected boolean isPrimitive;
    protected boolean isJDK;
    protected Map<String, MetadataField> fields = new HashMap<String, MetadataField>();
    protected Map<String, MetadataMethod> methods = new HashMap<String, MetadataMethod>();

    public MetadataClass(MetadataFactory factory, String name) {
        super(factory, factory.logger);
        this.setName(name);
    }

    public MetadataClass(MetadataFactory factory, Class cls) {
        this(factory, cls.getName());
        this.isPrimitive = cls.isPrimitive();
    }

    public Map<String, MetadataField> getFields() {
        return this.fields;
    }

    public MetadataField getField(String name) {
        MetadataField field = this.fields.get(name);
        if (field == null && this.getSuperclassName() != null) {
            return this.getSuperclass().getField(name);
        }
        return field;
    }

    public void setFields(Map<String, MetadataField> fields) {
        this.fields = fields;
    }

    public Map<String, MetadataMethod> getMethods() {
        return this.methods;
    }

    protected MetadataMethod getMethod(String name) {
        return this.methods.get(name);
    }

    public MetadataMethod getMethod(String name, Class[] arguments) {
        ArrayList<String> argumentNames = new ArrayList<String>(arguments.length);
        for (int index = 0; index < arguments.length; ++index) {
            argumentNames.add(arguments[index].getName());
        }
        return this.getMethod(name, argumentNames);
    }

    public MetadataMethod getMethod(String name, String[] arguments) {
        return this.getMethod(name, Arrays.asList(arguments));
    }

    public MetadataMethod getMethod(String name, List<String> arguments) {
        MetadataMethod method;
        for (method = this.methods.get(name); method != null && !((Object)method.getParameters()).equals(arguments); method = method.getNext()) {
        }
        if (method == null && this.getSuperclassName() != null) {
            return this.getSuperclass().getMethod(name, arguments);
        }
        return method;
    }

    public MetadataMethod getMethodForPropertyName(String propertyName) {
        String leadingChar = String.valueOf(propertyName.charAt(0)).toUpperCase();
        String restOfName = propertyName.substring(1);
        MetadataMethod method = this.getMethod("get".concat(leadingChar).concat(restOfName), new String[0]);
        if (method == null) {
            method = this.getMethod("is".concat(leadingChar).concat(restOfName), new String[0]);
        }
        if (method != null) {
            method.setSetMethod(method.getSetMethod(this));
        }
        return method;
    }

    public void setMethods(Map<String, MetadataMethod> methods) {
        this.methods = methods;
    }

    public MetadataClass getSuperclass() {
        return this.getMetadataFactory().getClassMetadata(this.superclass);
    }

    public String getSuperclassName() {
        return this.superclass;
    }

    public void setSuperclassName(String superclass) {
        this.superclass = superclass;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public boolean extendsClass(Class javaClass) {
        return this.extendsClass(javaClass.getName());
    }

    public boolean extendsClass(String className) {
        if (this.getName() == null) {
            return className == null;
        }
        if (this.getName().equals(className)) {
            return true;
        }
        if (this.getSuperclassName() == null) {
            return false;
        }
        if (this.getSuperclassName().equals(className)) {
            return true;
        }
        return this.getSuperclass().extendsClass(className);
    }

    public boolean isArray() {
        return this.getName() != null && this.getName().charAt(0) == '[';
    }

    public boolean isSerializable() {
        if (this.isArray()) {
            return true;
        }
        return this.extendsInterface(Serializable.class);
    }

    public boolean extendsInterface(Class javaClass) {
        return this.extendsInterface(javaClass.getName());
    }

    public boolean extendsInterface(String className) {
        if (this.getName() == null) {
            return false;
        }
        if (this.getName().equals(className)) {
            return true;
        }
        if (this.getInterfaces() == null) {
            return false;
        }
        if (this.getInterfaces().contains(className)) {
            return true;
        }
        for (String interfaceName : this.getInterfaces()) {
            if (!this.getMetadataFactory().getClassMetadata(interfaceName).extendsInterface(className)) continue;
            return true;
        }
        if (this.getSuperclassName() == null) {
            return false;
        }
        return this.getSuperclass().extendsInterface(className);
    }

    public boolean isVoid() {
        return this.getName().equals(Void.TYPE.getName());
    }

    public boolean isObject() {
        return this.getName().equals(Object.class.getName());
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isEnum() {
        return this.extendsClass(Enum.class);
    }

    public boolean isMap() {
        return this.extendsInterface(Map.class);
    }

    public boolean isCollection() {
        return this.extendsInterface(Collection.class);
    }

    public boolean isJDK() {
        return this.isJDK;
    }

    public boolean isInterface() {
        return (0x200 & this.modifiers) != 0;
    }

    public boolean isList() {
        return this.extendsInterface(List.class);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Class) {
            if (this.getName() == null) {
                return ((Class)object).getName() == null;
            }
            return this.getName().equals(((Class)object).getName());
        }
        return super.equals(object);
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setIsJDK(boolean isJDK) {
        this.isJDK = isJDK;
    }
}

