/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.logger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.tomcat.util.modeler.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerBase
implements Lifecycle,
Logger,
MBeanRegistration {
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(LoggerBase.class.getName());
    protected Container container = null;
    protected int debug = 0;
    protected static final String info = "org.apache.catalina.logger.LoggerBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected int verbosity = 1;
    protected String domain;
    protected String host;
    protected String path;
    protected ObjectName oname;
    protected ObjectName controller;
    protected MBeanServer mserver;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getVerbosity() {
        return this.verbosity;
    }

    @Override
    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public void setVerbosityLevel(String verbosity) {
        if ("FATAL".equalsIgnoreCase(verbosity)) {
            this.verbosity = Integer.MIN_VALUE;
        } else if ("ERROR".equalsIgnoreCase(verbosity)) {
            this.verbosity = 1;
        } else if ("WARNING".equalsIgnoreCase(verbosity)) {
            this.verbosity = 2;
        } else if ("INFORMATION".equalsIgnoreCase(verbosity)) {
            this.verbosity = 3;
        } else if ("DEBUG".equalsIgnoreCase(verbosity)) {
            this.verbosity = 4;
        }
    }

    public void setLevel(String logLevel) {
        if ("SEVERE".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.SEVERE);
        } else if ("WARNING".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.WARNING);
        } else if ("INFO".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.INFO);
        } else if ("CONFIG".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.CONFIG);
        } else if ("FINE".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.FINE);
        } else if ("FINER".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.FINER);
        } else if ("FINEST".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.FINEST);
        } else {
            log.setLevel(Level.INFO);
        }
    }

    public void addHandler(Handler handler) {
        log.setUseParentHandlers(false);
        handler.setLevel(log.getLevel());
        log.addHandler(handler);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void log(String msg) {
        log.fine(msg);
    }

    @Override
    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    @Override
    public void log(String msg, Throwable throwable) {
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buf);
        writer.println(msg);
        throwable.printStackTrace(writer);
        Throwable rootCause = null;
        if (throwable instanceof LifecycleException) {
            rootCause = ((LifecycleException)throwable).getThrowable();
        } else if (throwable instanceof ServletException) {
            rootCause = ((ServletException)throwable).getRootCause();
        }
        if (rootCause != null) {
            writer.println("----- Root Cause -----");
            rootCause.printStackTrace(writer);
        }
        this.log(buf.toString());
    }

    @Override
    public void log(String message, int verbosity) {
        if (this.verbosity >= verbosity) {
            this.log(message);
        }
    }

    @Override
    public void log(String message, Throwable throwable, int verbosity) {
        if (this.verbosity >= verbosity) {
            this.log(message, throwable);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        if (name == null) {
            return null;
        }
        this.domain = name.getDomain();
        this.host = name.getKeyProperty("host");
        this.path = name.getKeyProperty("path");
        if (log.isLoggable(Level.FINE)) {
            log.fine("preRegister with " + name);
        }
        if (this.container == null) {
            try {
                ObjectName cname = null;
                cname = this.host == null ? new ObjectName(this.domain + ":type=Engine") : (this.path == null ? new ObjectName(this.domain + ":type=Host,host=" + this.host) : new ObjectName(this.domain + ":j2eeType=WebModule,name=//" + this.host + "/" + this.path));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Register with " + cname);
                }
                this.mserver.invoke(cname, "setLogger", new Object[]{this}, new String[]{"org.apache.catalina.Logger"});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void init() {
    }

    public void destroy() {
    }

    public ObjectName createObjectName() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("createObjectName with " + this.container);
        }
        try {
            StandardEngine engine = null;
            String suffix = "";
            if (this.container instanceof StandardEngine) {
                engine = (StandardEngine)this.container;
            } else if (this.container instanceof StandardHost) {
                engine = (StandardEngine)this.container.getParent();
                suffix = ",host=" + this.container.getName();
            } else if (this.container instanceof StandardContext) {
                String path = ((StandardContext)this.container).getPath();
                if (path.equals("")) {
                    path = "/";
                }
                engine = (StandardEngine)this.container.getParent().getParent();
                suffix = ",path=" + path + ",host=" + this.container.getParent().getName();
            } else {
                log.severe("Unknown container " + this.container);
            }
            if (engine != null) {
                this.oname = new ObjectName(engine.getDomain() + ":type=Logger" + suffix);
            } else {
                log.severe("Null engine !! " + this.container);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this.oname;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.getObjectName() == null) {
            ObjectName oname = this.createObjectName();
            try {
                Registry.getRegistry(null, null).registerComponent((Object)this, oname, null);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Registering logger " + oname);
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Can't register logger " + oname, ex);
            }
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (this.getObjectName() != null) {
            ObjectName oname = this.createObjectName();
            try {
                Registry.getRegistry(null, null).unregisterComponent(oname);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Unregistering logger " + oname);
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Can't unregister logger " + oname, ex);
            }
        }
    }
}

