/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.logging.LogDomains;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class IIOPSSLUtilImpl
implements IIOPSSLUtil {
    @Inject
    private SSLUtils sslUtils;
    @Inject
    private Habitat habitat;
    private static final Logger _logger = LogDomains.getLogger(IIOPSSLUtilImpl.class, (String)"javax.enterprise.system.core.security");
    private Object appClientSSL;

    public Object getAppClientSSL() {
        return this.appClientSSL;
    }

    public void setAppClientSSL(Object ssl) {
        this.appClientSSL = ssl;
    }

    public KeyManager[] getKeyManagers(String alias) {
        KeyManager[] mgrs = null;
        try {
            if (alias != null && !this.sslUtils.isTokenKeyAlias(alias)) {
                throw new IllegalStateException(this.getFormatMessage("iiop.cannot_find_keyalias", new Object[]{alias}));
            }
            mgrs = this.sslUtils.getKeyManagers();
            if (alias != null && mgrs != null && mgrs.length > 0) {
                KeyManager[] newMgrs = new KeyManager[mgrs.length];
                for (int i = 0; i < mgrs.length; ++i) {
                    if (_logger.isLoggable(Level.FINE)) {
                        StringBuffer msg = new StringBuffer("Setting J2EEKeyManager for ");
                        msg.append(" alias : " + alias);
                        _logger.log(Level.FINE, msg.toString());
                    }
                    newMgrs[i] = new J2EEKeyManager(this.habitat, (X509KeyManager)mgrs[i], alias);
                }
                mgrs = newMgrs;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mgrs;
    }

    public TrustManager[] getTrustManagers() {
        try {
            return this.sslUtils.getTrustManagers();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFormatMessage(String key, Object[] params) {
        return MessageFormat.format(_logger.getResourceBundle().getString(key), params);
    }

    public SecureRandom getInitializedSecureRandom() {
        return SecurityServicesUtil.secureRandom;
    }
}

