/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.security;

import com.sun.xml.rpc.client.StreamingSenderState;
import com.sun.xml.rpc.server.StreamingHandlerState;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.config.ApplicationSecurityConfiguration;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.config.SecurityConfigurationXmlReader;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class SecurityPluginUtil {
    String port = null;
    private CallbackHandler _callbackHandler = null;
    private SecurityEnvironment _securityEnvironment = null;
    private ApplicationSecurityConfiguration _sConfig = null;
    private static final String CONTEXT_OPERATION = "context.operation.name";
    private static final String ENCRYPTED_BODY_QNAME = "{http://www.w3.org/2001/04/xmlenc#}EncryptedData";

    public SecurityPluginUtil(String config, String port, boolean isStub) throws Exception {
        if (config != null) {
            int versionStart = config.indexOf(91);
            if (versionStart != -1) {
                int versionEnd = config.indexOf(93);
                config = config.substring(versionEnd + 1);
            }
            this.port = port;
            this._sConfig = SecurityConfigurationXmlReader.createApplicationSecurityConfiguration(new ByteArrayInputStream(config.getBytes()));
            this._callbackHandler = (CallbackHandler)Class.forName(this._sConfig.getSecurityEnvironmentHandler(), true, Thread.currentThread().getContextClassLoader()).newInstance();
            this._securityEnvironment = new DefaultSecurityEnvironmentImpl(this._callbackHandler);
        }
    }

    private void copyToMessageContext(javax.xml.rpc.handler.soap.SOAPMessageContext messageContext, ProcessingContext context) throws Exception {
        messageContext.setMessage(context.getSOAPMessage());
        Iterator i = context.getExtraneousProperties().keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object value = context.getExtraneousProperties().get(name);
            messageContext.setProperty(name, value);
        }
    }

    private void copyToProcessingContext(ProcessingContext context, javax.xml.rpc.handler.soap.SOAPMessageContext messageContext) throws Exception {
        context.setSOAPMessage(messageContext.getMessage());
        Iterator i = messageContext.getPropertyNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object value = messageContext.getProperty(name);
            context.setExtraneousProperty(name, value);
        }
    }

    private StaticApplicationContext getPolicyContext() {
        ApplicationSecurityConfiguration config = (ApplicationSecurityConfiguration)this._sConfig.getAllTopLevelApplicationSecurityConfigurations().iterator().next();
        StaticApplicationContext iContext = (StaticApplicationContext)config.getAllContexts().next();
        StaticApplicationContext sContext = new StaticApplicationContext(iContext);
        sContext.setPortIdentifier(this.port);
        return sContext;
    }

    public void _preHandlingHook(StreamingSenderState state) throws Exception {
        try {
            SOAPMessageContext messageContext = state.getMessageContext();
            SOAPMessage message = state.getResponse().getMessage();
            String operation = (String)messageContext.getProperty(CONTEXT_OPERATION);
            StaticApplicationContext sContext = this.getPolicyContext();
            sContext.setOperationIdentifier(operation);
            SecurityPolicy policy = this._sConfig.getSecurityConfiguration(sContext);
            ProcessingContext context = new ProcessingContext();
            this.copyToProcessingContext(context, messageContext);
            context.setPolicyContext(sContext);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).receiverSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(this._securityEnvironment);
            context.isInboundMessage(true);
            if (this._sConfig.retainSecurityHeader()) {
                context.retainSecurityHeader(true);
            }
            if (this._sConfig.resetMustUnderstand()) {
                context.resetMustUnderstand(true);
            }
            SecurityRecipient.validateMessage(context);
            this.copyToMessageContext(messageContext, context);
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException);
        }
        catch (XWSSecurityException xwse) {
            QName qname = null;
            qname = xwse.getCause() instanceof PolicyViolationException ? MessageConstants.WSSE_RECEIVER_POLICY_VIOLATION : MessageConstants.WSSE_FAILED_AUTHENTICATION;
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(qname, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe);
        }
    }

    public boolean _preRequestSendingHook(StreamingSenderState state) throws Exception {
        try {
            SOAPMessageContext messageContext = state.getMessageContext();
            SOAPMessage message = state.getRequest().getMessage();
            String operation = this.getOperationName(message);
            messageContext.setProperty(CONTEXT_OPERATION, operation);
            StaticApplicationContext sContext = this.getPolicyContext();
            sContext.setOperationIdentifier(operation);
            SecurityPolicy policy = this._sConfig.getSecurityConfiguration(sContext);
            ProcessingContext context = new ProcessingContext();
            this.copyToProcessingContext(context, messageContext);
            context.setPolicyContext(sContext);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).senderSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(this._securityEnvironment);
            context.isInboundMessage(false);
            SecurityAnnotator.secureMessage(context);
            this.copyToMessageContext(messageContext, context);
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException);
        }
        catch (XWSSecurityException xwse) {
            throw new JAXRPCException((Throwable)xwse);
        }
        return true;
    }

    public boolean preHandlingHook(StreamingHandlerState state) throws Exception {
        try {
            SOAPMessageContext messageContext = state.getMessageContext();
            SOAPMessage message = state.getRequest().getMessage();
            StaticApplicationContext sContext = new StaticApplicationContext(this.getPolicyContext());
            ProcessingContext context = new ProcessingContext();
            this.copyToProcessingContext(context, messageContext);
            String operation = this.getOperationName(message);
            if (operation.equals(ENCRYPTED_BODY_QNAME) && this._sConfig.hasOperationPolicies()) {
                ApplicationSecurityConfiguration config = (ApplicationSecurityConfiguration)this._sConfig.getSecurityPolicies(sContext).next();
                if (config != null) {
                    context.setPolicyContext(sContext);
                    context.setSecurityPolicy(config);
                } else {
                    ApplicationSecurityConfiguration config0 = (ApplicationSecurityConfiguration)this._sConfig.getAllTopLevelApplicationSecurityConfigurations().iterator().next();
                    context.setPolicyContext(sContext);
                    context.setSecurityPolicy(config0);
                }
            } else {
                sContext.setOperationIdentifier(operation);
                messageContext.setProperty(CONTEXT_OPERATION, operation);
                SecurityPolicy policy = this._sConfig.getSecurityConfiguration(sContext);
                context.setPolicyContext(sContext);
                if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                    context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).receiverSettings());
                } else {
                    context.setSecurityPolicy(policy);
                }
            }
            context.setSecurityEnvironment(this._securityEnvironment);
            context.isInboundMessage(true);
            if (this._sConfig.retainSecurityHeader()) {
                context.retainSecurityHeader(true);
            }
            SecurityRecipient.validateMessage(context);
            messageContext.setProperty(CONTEXT_OPERATION, this.getOperationName(message));
            this.copyToMessageContext(messageContext, context);
        }
        catch (WssSoapFaultException soapFaultException) {
            state.getResponse().setFailure(true);
            throw this.getSOAPFaultException(soapFaultException);
        }
        catch (XWSSecurityException xwse) {
            QName qname = null;
            qname = xwse.getCause() instanceof PolicyViolationException ? MessageConstants.WSSE_RECEIVER_POLICY_VIOLATION : MessageConstants.WSSE_FAILED_AUTHENTICATION;
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(qname, xwse.getMessage(), xwse);
            state.getResponse().setFailure(true);
            throw this.getSOAPFaultException(wsfe);
        }
        return true;
    }

    public void postResponseWritingHook(StreamingHandlerState state) throws Exception {
        try {
            SOAPMessageContext messageContext = state.getMessageContext();
            SOAPMessage message = state.getResponse().getMessage();
            ProcessingContext context = new ProcessingContext();
            this.copyToProcessingContext(context, messageContext);
            if (state.getResponse().isFailure()) {
                DumpFilter.process(context);
                return;
            }
            String operation = (String)messageContext.getProperty(CONTEXT_OPERATION);
            StaticApplicationContext sContext = new StaticApplicationContext(this.getPolicyContext());
            sContext.setOperationIdentifier(operation);
            SecurityPolicy policy = this._sConfig.getSecurityConfiguration(sContext);
            context.setPolicyContext(sContext);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).senderSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(this._securityEnvironment);
            context.isInboundMessage(false);
            SecurityAnnotator.secureMessage(context);
            this.copyToMessageContext(messageContext, context);
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException);
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe);
        }
    }

    public void prepareMessageForMUCheck(SOAPMessage message) throws Exception {
        this.setMUValue(message, "0");
    }

    public void restoreMessageAfterMUCheck(SOAPMessage message) throws Exception {
        this.setMUValue(message, "1");
    }

    private void setMUValue(SOAPMessage message, String value) throws Exception {
        SOAPPart sp = message.getSOAPPart();
        SOAPEnvelope se = sp.getEnvelope();
        SOAPHeader sh = se.getHeader();
        if (sh != null) {
            Attr attr;
            Node currentChild;
            SOAPElement secHeader = null;
            for (currentChild = sh.getFirstChild(); currentChild != null && currentChild.getNodeType() != 1; currentChild = currentChild.getNextSibling()) {
            }
            if (currentChild != null && "Security".equals(currentChild.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentChild.getNamespaceURI())) {
                secHeader = (SOAPElement)currentChild;
            }
            if (secHeader != null && (attr = secHeader.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand")) != null) {
                secHeader.setAttributeNS(attr.getNamespaceURI(), attr.getName(), value);
            }
        }
    }

    public SOAPFaultException getSOAPFaultException(WssSoapFaultException sfe) {
        return new SOAPFaultException(sfe.getFaultCode(), sfe.getFaultString(), sfe.getFaultActor(), sfe.getDetail());
    }

    private String getOperationName(SOAPMessage message) throws Exception {
        Node node = null;
        Object key = null;
        SOAPBody body = null;
        if (message == null) {
            throw new XWSSecurityException("SOAPMessage in message context is null");
        }
        body = message.getSOAPBody();
        if (body == null) {
            throw new XWSSecurityException("No body element identifying an operation is found");
        }
        StringBuffer tmp = new StringBuffer("");
        String operation = "";
        for (node = body.getFirstChild(); node != null; node = node.getNextSibling()) {
            tmp.append("{" + node.getNamespaceURI() + "}" + node.getLocalName() + ":");
        }
        operation = tmp.toString();
        return operation.substring(0, operation.length() - 1);
    }
}

