/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.AssertionValidationProcessor;
import com.sun.xml.ws.policy.EffectiveAlternativeSelector;
import com.sun.xml.ws.policy.EffectivePolicyModifier;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.ws.WebServiceException;

public class WsitPolicyUtil {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(WsitPolicyUtil.class);

    public static void validateServerPolicyMap(PolicyMap policyMap) {
        try {
            AssertionValidationProcessor validationProcessor = AssertionValidationProcessor.getInstance();
            for (Policy policy : policyMap) {
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion assertion : assertionSet) {
                        PolicyAssertionValidator.Fitness validationResult = validationProcessor.validateServerSide(assertion);
                        if (validationResult == PolicyAssertionValidator.Fitness.SUPPORTED) continue;
                        throw new PolicyException(LocalizationMessages.WSP_5017_SERVER_SIDE_ASSERTION_VALIDATION_FAILED(assertion.getName(), (Object)validationResult));
                    }
                }
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static PolicyMap doAlternativeSelection(PolicyMap policyMap) {
        EffectivePolicyModifier modifier = EffectivePolicyModifier.createEffectivePolicyModifier();
        modifier.connect(policyMap);
        try {
            EffectiveAlternativeSelector.doSelection(modifier);
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
        finally {
            modifier.disconnect();
        }
        return policyMap;
    }

    public static PolicyMap mergePolicyMap(PolicyMap policyMap, PolicyMap clientPolicyMap) throws PolicyException {
        PolicyMapExtender mapExtender = PolicyMapExtender.createPolicyMapExtender();
        String clientWsitConfigId = "client";
        if (policyMap != null) {
            mapExtender.connect(policyMap);
            try {
                Policy policy;
                for (PolicyMapKey key : clientPolicyMap.getAllServiceScopeKeys()) {
                    policy = clientPolicyMap.getServiceEffectivePolicy(key);
                    mapExtender.putServiceSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllEndpointScopeKeys()) {
                    policy = clientPolicyMap.getEndpointEffectivePolicy(key);
                    mapExtender.putEndpointSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllOperationScopeKeys()) {
                    policy = clientPolicyMap.getOperationEffectivePolicy(key);
                    mapExtender.putOperationSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllInputMessageScopeKeys()) {
                    policy = clientPolicyMap.getInputMessageEffectivePolicy(key);
                    mapExtender.putInputMessageSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllOutputMessageScopeKeys()) {
                    policy = clientPolicyMap.getOutputMessageEffectivePolicy(key);
                    mapExtender.putOutputMessageSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllFaultMessageScopeKeys()) {
                    policy = clientPolicyMap.getFaultMessageEffectivePolicy(key);
                    mapExtender.putFaultMessageSubject(key, new PolicySubject((Object)"client", policy));
                }
                LOGGER.fine(LocalizationMessages.WSP_5015_CLIENT_CFG_POLICIES_TRANSFERED_INTO_FINAL_POLICY_MAP(policyMap));
            }
            catch (FactoryConfigurationError ex) {
                throw (PolicyException)LOGGER.logSevereException(new PolicyException(ex));
            }
            return policyMap;
        }
        return clientPolicyMap;
    }
}

