/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.util;

import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManagerImpl
extends SessionManager {
    private Hashtable<String, Session> sessionMap = new Hashtable();
    private Hashtable<String, IssuedTokenContext> issuedTokenContextMap = new Hashtable();
    private Hashtable<String, SecurityContextTokenInfo> securityContextTokenInfoMap = new Hashtable();

    @Override
    public Session getSession(String key) {
        return this.sessionMap.get(key);
    }

    @Override
    public Set<String> getKeys() {
        return this.sessionMap.keySet();
    }

    @Override
    protected Collection<Session> getSessions() {
        return this.sessionMap.values();
    }

    @Override
    public void terminateSession(String key) {
        this.sessionMap.remove(key);
    }

    @Override
    public Session createSession(String key, Class clasz) {
        Session sess;
        try {
            sess = new Session(this, key, clasz.newInstance());
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException ee) {
            return null;
        }
        this.sessionMap.put(key, sess);
        return sess;
    }

    @Override
    public Session createSession(String key, Object obj) {
        Session sess = new Session(this, key, obj);
        this.sessionMap.put(key, sess);
        return sess;
    }

    @Override
    public Session createSession(String key) {
        return this.createSession(key, new Hashtable());
    }

    @Override
    public void saveSession(String key) {
    }

    @Override
    public IssuedTokenContext getSecurityContext(String key, boolean checkExpiry) {
        IssuedTokenContext ctx = this.issuedTokenContextMap.get(key);
        if (ctx == null) {
            Session session = this.getSession(key);
            if (session != null) {
                SecurityContextTokenInfo sctInfo = session.getSecurityInfo();
                ctx = sctInfo.getIssuedTokenContext();
                this.addSecurityContext(key, ctx);
            } else {
                throw new WebServiceException("Could not locate SecureConversation session for Id:" + key);
            }
        }
        if (ctx != null && checkExpiry) {
            GregorianCalendar c = new GregorianCalendar();
            long offset = c.get(15);
            if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
                offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
            }
            long beforeTime = c.getTimeInMillis();
            long currentTime = beforeTime - offset;
            c.setTimeInMillis(currentTime);
            Date currentTimeInDateFormat = c.getTime();
            if (!currentTimeInDateFormat.after(ctx.getCreationTime()) || !currentTimeInDateFormat.before(ctx.getExpirationTime())) {
                throw new WebServiceException("SecureConversation session for session Id:" + key + "has expired.");
            }
        }
        if (((SecurityContextToken)ctx.getSecurityToken()).getInstance() != null) {
            String sctInfoKey = ((SecurityContextToken)ctx.getSecurityToken()).getIdentifier().toString() + "_" + ((SecurityContextToken)ctx.getSecurityToken()).getInstance();
            ctx.setSecurityContextTokenInfo(this.securityContextTokenInfoMap.get(sctInfoKey));
        }
        return ctx;
    }

    @Override
    public void addSecurityContext(String key, IssuedTokenContext itctx) {
        this.issuedTokenContextMap.put(key, itctx);
        if (((SecurityContextToken)itctx.getSecurityToken()).getInstance() != null) {
            String sctInfoKey = ((SecurityContextToken)itctx.getSecurityToken()).getIdentifier().toString() + "_" + ((SecurityContextToken)itctx.getSecurityToken()).getInstance();
            this.securityContextTokenInfoMap.put(sctInfoKey, itctx.getSecurityContextTokenInfo());
            itctx.setSecurityContextTokenInfo(null);
        }
    }
}

