/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.soap;

import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP11Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP12Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPBinding;
import org.jvnet.wom.impl.extension.Messages;
import org.jvnet.wom.impl.extension.wsdl11.AbstractWSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPBindingImpl;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPBindingExtensionHandler
extends AbstractWSDLExtensionHandler {
    private final ContentHandler contentHandler = new SOAPBindingCH();
    private SOAPBindingImpl binding;
    private final QName[] names = new QName[]{SOAP11Constants.SOAPBinding_NAME, SOAP12Constants.SOAPBinding_NAME};

    public SOAPBindingExtensionHandler(ErrorHandler errorHandler, EntityResolver entityResolver) {
        super(errorHandler, entityResolver);
    }

    @Override
    protected QName[] getExtensionNames() {
        return this.names;
    }

    @Override
    public Collection<WSDLExtension> getExtensions() {
        return Collections.singleton(this.binding);
    }

    @Override
    public ContentHandler getContentHandlerFor(String nsUri, String localName) {
        if (this.canHandle(nsUri, localName)) {
            return this.contentHandler;
        }
        return null;
    }

    private class SOAPBindingCH
    extends AbstractWSDLExtensionHandler.WSDLExtensibilityContentHandler {
        private SOAPBindingCH() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (SOAPBindingExtensionHandler.this.canHandle(uri, localName)) {
                String transport = atts.getValue("transport");
                if (transport == null) {
                    SOAPBindingExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("missing.attr", "transport", "soap:binding"), this.locator));
                }
                if ((transport = XmlUtil.fixNull(transport)).equals("")) {
                    SOAPBindingExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("invalid.attr", "transport", transport, "http://schemas.xmlsoap.org/soap/http for SOAP over HTTP."), this.locator));
                }
                String styleattr = XmlUtil.fixNull(atts.getValue("style"));
                SOAPBinding.Style style = null;
                if (styleattr.equals("rpc")) {
                    style = SOAPBinding.Style.Rpc;
                } else if (styleattr.equals("document")) {
                    style = SOAPBinding.Style.Document;
                } else if (styleattr.length() > 0) {
                    SOAPBindingExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("invalid.attr", "style", styleattr, "document or rpc"), this.locator));
                }
                SOAPBindingExtensionHandler.this.binding = new SOAPBindingImpl(new QName(uri, localName));
                SOAPBindingExtensionHandler.this.binding.setTransport(transport);
                SOAPBindingExtensionHandler.this.binding.setStyle(style);
            }
        }
    }
}

