/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm.statistics;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.management.MemoryUsage;
import java.util.logging.Logger;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.MethodInvoker;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.j2ee.statistics.Statistic;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class JVMStatsImpl
implements MonitorContract {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    Logger logger;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JVMStatsImpl.class);
    private final String name = "jvm";

    public String getName() {
        return "jvm";
    }

    public ActionReport process(ActionReport report, String filter) {
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry is null"));
            return report;
        }
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry server node is null"));
            return report;
        }
        return this.v2JVM(report, serverNode);
    }

    private ActionReport heapMemory(ActionReport report, TreeNode serverNode) {
        long init = 0L;
        long used = 0L;
        long committed = 0L;
        long max = 0L;
        MethodInvoker tn = (MethodInvoker)serverNode.getNode("jvm").getNode("committedHeapSize");
        this.logger.finest("JVMStatsImpl: tn name = " + tn.getName());
        this.logger.finest("JVMStatsImpl: tn class name = " + tn.getClass().getName());
        this.logger.finest("JVMStatsImpl: tn value = " + tn.getValue());
        this.logger.finest("JVMStatsImpl: tn value class name = " + tn.getValue().getClass().getName());
        this.logger.finest("JVMStatsImpl: tn instance = " + tn.getInstance());
        this.logger.finest("JVMStatsImpl: tn instance class name = " + tn.getInstance().getClass().getName());
        MemoryUsage mu = (MemoryUsage)tn.getInstance();
        String displayFormat = "%1$-10s %2$-10s %3$-10s %4$-10s";
        report.setMessage(String.format(displayFormat, mu.getInit(), mu.getUsed(), mu.getCommitted(), mu.getMax()));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private ActionReport nonHeapMemory(ActionReport report, TreeNode serverNode) {
        long init = 0L;
        long used = 0L;
        long committed = 0L;
        long max = 0L;
        MethodInvoker tn = (MethodInvoker)serverNode.getNode("jvm").getNode("non-heap-memory");
        MemoryUsage mu = (MemoryUsage)tn.getInstance();
        String displayFormat = "%1$-10s %2$-10s %3$-10s %4$-10s";
        report.setMessage(String.format(displayFormat, mu.getInit(), mu.getUsed(), mu.getCommitted(), mu.getMax()));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private ActionReport v2JVM(ActionReport report, TreeNode serverNode) {
        TreeNode tn = null;
        long uptime = 0L;
        tn = serverNode.getNodes("server.jvm.runtime.uptime").get(0);
        if (tn != null && tn.getValue() != null) {
            uptime = (Long)tn.getValue();
        }
        long min = 0L;
        tn = serverNode.getNodes("server.jvm.memory.initNonHeapSize").get(0);
        if (tn != null && tn.getValue() != null) {
            min = (Long)tn.getValue();
        }
        if ((tn = serverNode.getNodes("server.jvm.memory.initHeapSize").get(0)) != null && tn.getValue() != null) {
            min += ((Long)tn.getValue()).longValue();
        }
        long max = 0L;
        tn = serverNode.getNodes("server.jvm.memory.maxHeapSize").get(0);
        if (tn != null && tn.getValue() != null) {
            max = (Long)tn.getValue();
        }
        if ((tn = serverNode.getNodes("server.jvm.memory.maxNonHeapSize").get(0)) != null && tn.getValue() != null) {
            max += ((Long)tn.getValue()).longValue();
        }
        long low = 0L;
        long high = 0L;
        long count = 0L;
        tn = serverNode.getNodes("server.jvm.memory.committedHeapSize").get(0);
        if (tn != null && tn.getValue() != null) {
            count = (Long)tn.getValue();
        }
        if ((tn = serverNode.getNodes("server.jvm.memory.committedNonHeapSize").get(0)) != null && tn.getValue() != null) {
            count += ((Long)tn.getValue()).longValue();
        }
        String displayFormat = "%1$-25s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s";
        report.setMessage(String.format(displayFormat, uptime, min, max, low, high, count));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    public Statistic[] getStatistics() {
        return null;
    }

    public String[] getStatisticNames() {
        return null;
    }

    public Statistic getStatistic(String statisticName) {
        return null;
    }
}

