/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm.telemetry;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;

public class JVMStatsTelemetry {
    private TreeNode jvmNode;
    private Logger logger;
    private boolean isEnabled = true;

    public JVMStatsTelemetry(TreeNode server, Logger logger) {
        try {
            this.logger = logger;
            this.jvmNode = TreeNodeFactory.createTreeNode("jvm", null, "jvm");
            server.addChild(this.jvmNode);
            this.jvmNode.addChild(this.createClassLoadingSystemNode());
            this.jvmNode.addChild(this.createCompilationSystemNode());
            this.jvmNode.addChild(this.createGarbageCollectorsNode());
            this.jvmNode.addChild(this.createMemoryNode());
            this.jvmNode.addChild(this.createOperatingSystemNode());
            this.jvmNode.addChild(this.createRuntimeNode());
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(JVMStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(JVMStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(JVMStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JVMStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(JVMStatsTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void enableMonitoring(boolean flag) {
        if (this.isEnabled != flag) {
            this.isEnabled = flag;
            this.jvmNode.setEnabled(flag);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private TreeNode createClassLoadingSystemNode() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String[] mList;
        TreeNode classLoadingSystemNode = TreeNodeFactory.createTreeNode("class-loading-system", null, "jvm");
        ClassLoadingMXBean clBean = ManagementFactory.getClassLoadingMXBean();
        for (String methodName : mList = new String[]{"getLoadedClassCount", "getTotalLoadedClassCount", "getUnloadedClassCount"}) {
            Method method = ClassLoadingMXBean.class.getMethod(methodName, new Class[0]);
            String nodeName = this.createNodeName(methodName);
            TreeNode tn = TreeNodeFactory.createMethodInvoker(nodeName, clBean, "jvm", method);
            classLoadingSystemNode.addChild(tn);
        }
        return classLoadingSystemNode;
    }

    private TreeNode createCompilationSystemNode() throws NoSuchMethodException {
        String[] mList;
        TreeNode compilationSystemNode = TreeNodeFactory.createTreeNode("compilation-system", null, "jvm");
        CompilationMXBean compBean = ManagementFactory.getCompilationMXBean();
        for (String methodName : mList = new String[]{"getName", "getTotalCompilationTime"}) {
            Method method = CompilationMXBean.class.getMethod(methodName, new Class[0]);
            String nodeName = this.createNodeName(methodName);
            TreeNode tn = TreeNodeFactory.createMethodInvoker(nodeName, compBean, "jvm", method);
            compilationSystemNode.addChild(tn);
        }
        return compilationSystemNode;
    }

    private TreeNode createGarbageCollectorsNode() throws NoSuchMethodException {
        TreeNode garbageCollectorsNode = TreeNodeFactory.createTreeNode("garbage-collectors", null, "jvm");
        List<GarbageCollectorMXBean> gcBeanList = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeanList) {
            String[] mList;
            TreeNode gcNode = TreeNodeFactory.createTreeNode(gcBean.getName(), null, "garbage-collectors");
            for (String methodName : mList = new String[]{"getCollectionCount", "getCollectionTime"}) {
                Method method = GarbageCollectorMXBean.class.getMethod(methodName, new Class[0]);
                String nodeName = this.createNodeName(methodName);
                TreeNode tn = TreeNodeFactory.createMethodInvoker(nodeName, gcBean, "jvm", method);
                gcNode.addChild(tn);
            }
            garbageCollectorsNode.addChild(gcNode);
        }
        return garbageCollectorsNode;
    }

    private TreeNode createMemoryNode() throws NoSuchMethodException {
        TreeNode memoryNode = TreeNodeFactory.createTreeNode("memory", null, "jvm");
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        this.createMemoryUsageNodes(memBean.getHeapMemoryUsage(), "Heap", memoryNode);
        this.createMemoryUsageNodes(memBean.getNonHeapMemoryUsage(), "NonHeap", memoryNode);
        Method method = MemoryMXBean.class.getMethod("getObjectPendingFinalizationCount", null);
        TreeNode tn = TreeNodeFactory.createMethodInvoker("objectPendingFinalizationCount", memBean, "jvm", method);
        memoryNode.addChild(tn);
        return memoryNode;
    }

    private void createMemoryUsageNodes(MemoryUsage memUsage, String type, TreeNode memoryNode) throws NoSuchMethodException {
        String[] mList;
        for (String methodName : mList = new String[]{"getCommitted", "getInit", "getMax", "getUsed"}) {
            Method method = memUsage.getClass().getMethod(methodName, null);
            String nodeName = this.createMemUsageNodeName(methodName, type);
            TreeNode tn = TreeNodeFactory.createMethodInvoker(nodeName, memUsage, "jvm", method);
            memoryNode.addChild(tn);
        }
    }

    private String createMemUsageNodeName(String methodName, String type) {
        return this.createNodeName(methodName) + type + "Size";
    }

    private TreeNode createOperatingSystemNode() throws NoSuchMethodException {
        String[] mList;
        TreeNode operatingSystemNode = TreeNodeFactory.createTreeNode("operating-system", null, "jvm");
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        for (String methodName : mList = new String[]{"getArch", "getAvailableProcessors", "getName", "getVersion"}) {
            Method method = OperatingSystemMXBean.class.getMethod(methodName, null);
            String nodeName = this.createNodeName(methodName);
            TreeNode tn = TreeNodeFactory.createMethodInvoker(nodeName, osBean, "jvm", method);
            operatingSystemNode.addChild(tn);
        }
        return operatingSystemNode;
    }

    private TreeNode createRuntimeNode() throws NoSuchMethodException {
        String[] mList;
        TreeNode runtimeNode = TreeNodeFactory.createTreeNode("runtime", null, "jvm");
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        for (String methodName : mList = new String[]{"getBootClassPath", "getClassPath", "getInputArguments", "getLibraryPath", "getManagementSpecVersion", "getName", "getSpecName", "getSpecVendor", "getSpecVersion", "getUptime", "getVmName", "getVmVendor", "getVmVersion"}) {
            Method method = RuntimeMXBean.class.getMethod(methodName, null);
            String nodeName = this.createNodeName(methodName);
            TreeNode tn = TreeNodeFactory.createMethodInvoker(nodeName, rtBean, "jvm", method);
            runtimeNode.addChild(tn);
        }
        return runtimeNode;
    }

    private String createNodeName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }
}

