/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.Collection;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Lead;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Womb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWombImpl<T>
extends AbstractInhabitantImpl<T>
implements Womb<T> {
    protected final Class<T> type;
    private final MultiMap<String, String> metadata;

    public AbstractWombImpl(Class<T> type, MultiMap<String, String> metadata) {
        this.type = type;
        this.metadata = metadata;
    }

    @Override
    public final String typeName() {
        return this.type.getName();
    }

    @Override
    public final Class<T> type() {
        return this.type;
    }

    @Override
    public final T get(Inhabitant onBehalfOf) throws ComponentException {
        Object o = this.create(onBehalfOf);
        this.initialize(o, onBehalfOf);
        return o;
    }

    @Override
    public void initialize(T t, Inhabitant onBehalfOf) throws ComponentException {
    }

    @Override
    public void release() {
    }

    @Override
    public MultiMap<String, String> metadata() {
        return this.metadata;
    }

    protected void inject(final Habitat habitat, T t, final Inhabitant onBehalfOf) {
        new InjectionManager<Inject>(){

            @Override
            public boolean isOptional(Inject annotation) {
                return annotation.optional();
            }

            @Override
            protected Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
                if (type.isArray()) {
                    Class<?> ct = type.getComponentType();
                    Collection<?> instances = habitat.isContract(ct) ? habitat.getAllByContract(ct) : habitat.getAllByType(ct);
                    return instances.toArray((Object[])Array.newInstance(ct, instances.size()));
                }
                if (habitat.isContract(type)) {
                    return habitat.getComponent(type, target.getAnnotation(Inject.class).name());
                }
                return habitat.getByType(type);
            }
        }.inject(t, Inject.class);
        new InjectionManager<Lead>(){

            @Override
            protected Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
                Inhabitant lead = onBehalfOf.lead();
                if (lead == null) {
                    throw new ComponentException(component.getClass() + " requested @Lead injection but this is not a companion");
                }
                if (type == Inhabitant.class) {
                    return lead;
                }
                return lead.get();
            }
        }.inject(t, Lead.class);
        if (t instanceof PostConstruct) {
            ((PostConstruct)t).postConstruct();
        }
    }
}

