/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.branding;

import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.glassfish.api.branding.Branding;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class GlassFishBranding
implements Branding,
PostConstruct {
    private String product_name = "GlassFish Prelude";
    private String abbrev_product_name = "GlassFish";
    private String full_version = "10.0-b28";
    private String major_version = "10";
    private String minor_version = "0";
    private String build_id = "java_re-private";

    public void postConstruct() {
        try {
            PropertyResourceBundle vRes = (PropertyResourceBundle)PropertyResourceBundle.getBundle("BrandingVersion");
            String str = vRes.getString("product_name");
            if (str != null && str.length() > 0) {
                this.product_name = str;
            }
            if ((str = vRes.getString("abbrev_product_name")) != null && str.length() > 0) {
                this.abbrev_product_name = vRes.getString("abbrev_product_name");
            }
            if ((str = vRes.getString("full_version")) != null && str.length() > 0) {
                this.full_version = vRes.getString("full_version");
            }
            if ((str = vRes.getString("major_version")) != null && str.length() > 0) {
                this.major_version = vRes.getString("major_version");
            }
            if ((str = vRes.getString("minor_version")) != null && str.length() > 0) {
                this.minor_version = vRes.getString("minor_version");
            }
            if ((str = vRes.getString("build_id")) != null && str.length() > 0) {
                this.build_id = vRes.getString("build_id");
            }
        }
        catch (MissingResourceException mre) {
            System.out.println("no resource bundle found for version, using default GlassFish version");
        }
    }

    public String getVersion() {
        return this.product_name + " " + this.full_version;
    }

    public String getFullVersion() {
        return this.getVersion() + " (build " + this.build_id + ")";
    }

    public String getAbbreviatedVersion() {
        return this.abbrev_product_name + this.major_version + "." + this.minor_version;
    }

    public String getMajorVersion() {
        return this.major_version;
    }

    public String getMinorVersion() {
        return this.minor_version;
    }

    public String getBuildVersion() {
        return this.build_id;
    }

    public String getProductName() {
        return this.product_name;
    }

    public String getAbbrevProductName() {
        return this.abbrev_product_name;
    }
}

