/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaConfig {
    private Map<String, String> map;

    JavaConfig(Map<String, String> map) {
        this.map = map;
    }

    Map<String, String> getMap() {
        return this.map;
    }

    String getJavaHome() {
        return this.map.get("java-home");
    }

    List<File> getEnvClasspath() {
        if (this.useEnvClasspath()) {
            String s = System.getenv("CLASSPATH");
            return GFLauncherUtils.stringToFiles((String)s);
        }
        return new ArrayList<File>();
    }

    List<File> getPrefixClasspath() {
        String cp = this.map.get("classpath-prefix");
        if (GFLauncherUtils.ok((String)cp)) {
            return GFLauncherUtils.stringToFiles((String)cp);
        }
        return new ArrayList<File>();
    }

    List<File> getSuffixClasspath() {
        String cp = this.map.get("classpath-suffix");
        if (GFLauncherUtils.ok((String)cp)) {
            return GFLauncherUtils.stringToFiles((String)cp);
        }
        return new ArrayList<File>();
    }

    List<File> getSystemClasspath() {
        String cp = this.map.get("system-classpath");
        if (GFLauncherUtils.ok((String)cp)) {
            return GFLauncherUtils.stringToFiles((String)cp);
        }
        return new ArrayList<File>();
    }

    List<String> getDebugOptions() {
        List<String> empty = Collections.emptyList();
        String s = this.map.get("debug-options");
        if (!GFLauncherUtils.ok((String)s)) {
            return empty;
        }
        String[] ss = s.split(" ");
        if (ss == null || ss.length <= 0) {
            return empty;
        }
        return Arrays.asList(ss);
    }

    boolean isDebugEnabled() {
        return Boolean.parseBoolean(this.map.get("debug-enabled"));
    }

    private boolean useEnvClasspath() {
        return !Boolean.parseBoolean(this.map.get("env-classpath-ignored"));
    }
}

