/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttps;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.WebProtocolHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.http.portunif.HttpProtocolFinder;
import com.sun.grizzly.portunif.TLSPUPreProcessor;
import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;

public class GrizzlyServiceListener {
    private Controller controller;
    private int port;
    private GrizzlyService grizzlyService;
    private boolean isEmbeddedHttpSecured;
    private GrizzlyEmbeddedHttp embeddedHttp;
    private String name;

    public GrizzlyServiceListener() {
    }

    public GrizzlyServiceListener(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
        this.controller = grizzlyService.getController();
    }

    public void start(final GrizzlyProxy.GrizzlyFuture future) throws IOException, InstantiationException {
        final Thread t = Thread.currentThread();
        this.embeddedHttp.initEndpoint();
        this.embeddedHttp.getController().addStateListener(new ControllerStateListener(){

            public void onStarted() {
            }

            public void onReady() {
                future.setResult((Result<Thread>)new Result((Object)t));
            }

            public void onStopped() {
            }

            public void onException(Throwable throwable) {
                future.setResult((Result<Thread>)new Result(throwable));
            }
        });
        this.embeddedHttp.startEndpoint();
    }

    public void stop() {
        this.embeddedHttp.stopEndpoint();
    }

    public void initializeEmbeddedHttp(boolean isSecured) {
        this.isEmbeddedHttpSecured = isSecured;
        this.embeddedHttp = isSecured ? new GrizzlyEmbeddedHttps(this.grizzlyService) : new GrizzlyEmbeddedHttp(this.grizzlyService);
        this.embeddedHttp.setPort(this.port);
    }

    public void configurePortUnification() {
        WebProtocolHandler.Mode webProtocolHandlerMode;
        ArrayList<TLSPUPreProcessor> puPreProcessors = new ArrayList<TLSPUPreProcessor>();
        if (this.isEmbeddedHttpSecured) {
            SSLContext sslContext = ((GrizzlyEmbeddedHttps)this.embeddedHttp).getSSLContext();
            TLSPUPreProcessor preProcessor = new TLSPUPreProcessor(sslContext);
            puPreProcessors.add(preProcessor);
            webProtocolHandlerMode = WebProtocolHandler.Mode.HTTPS;
        } else {
            webProtocolHandlerMode = WebProtocolHandler.Mode.HTTP;
        }
        ArrayList<HttpProtocolFinder> protocolFinders = new ArrayList<HttpProtocolFinder>();
        protocolFinders.add(new HttpProtocolFinder());
        ArrayList<WebProtocolHandler> protocolHandlers = new ArrayList<WebProtocolHandler>();
        WebProtocolHandler webProtocolHandler = new WebProtocolHandler(webProtocolHandlerMode, this.embeddedHttp);
        protocolHandlers.add(webProtocolHandler);
        this.embeddedHttp.configurePortUnification(protocolFinders, protocolHandlers, puPreProcessors);
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public GrizzlyEmbeddedHttp getEmbeddedHttp() {
        return this.embeddedHttp;
    }

    public boolean isEmbeddedHttpSecured() {
        return this.isEmbeddedHttpSecured;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        if (this.embeddedHttp != null) {
            this.embeddedHttp.setPort(port);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

