/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import org.glassfish.api.branding.Branding;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class Version
implements PostConstruct {
    private static final String product_name = "GlassFish";
    private static final String abbrev_product_name = "glassfish";
    private static String full_version = "3.0-Prelude-Embedded-b13";
    private static final String major_version = "3";
    private static final String minor_version = "0";
    private static final String build_id = "java_re-private";
    private static final String version_prefix = "v";
    private static final String version_suffix = "Prelude";
    private static Branding br = null;
    @Inject
    private static Habitat mHabitat;

    public void postConstruct() {
        if (br == null && mHabitat != null) {
            br = (Branding)mHabitat.getByContract(Branding.class);
        }
        if (minor_version != null && minor_version.length() > 0) {
            try {
                full_version = Integer.parseInt(minor_version) > 0 ? "3.0" : major_version;
            }
            catch (NumberFormatException nfe) {
                full_version = major_version;
            }
        }
    }

    public static String getVersion() {
        if (br != null) {
            return br.getVersion();
        }
        StringBuffer sb = new StringBuffer("");
        if (product_name == null) {
            return null;
        }
        sb.append(product_name);
        if (version_prefix != null) {
            sb.append(" v");
        }
        if (full_version != null) {
            sb.append(full_version);
        }
        if (version_suffix != null) {
            sb.append(" Prelude");
        }
        return sb.toString();
    }

    public static String getFullVersion() {
        if (br != null) {
            return br.getFullVersion();
        }
        return Version.getVersion() + " (build " + build_id + ")";
    }

    public static String getAbbreviatedVersion() {
        if (br != null) {
            return br.getAbbreviatedVersion();
        }
        return abbrev_product_name;
    }

    public static String getMajorVersion() {
        if (br != null) {
            return br.getMajorVersion();
        }
        return major_version;
    }

    public static String getMinorVersion() {
        if (br != null) {
            return br.getMinorVersion();
        }
        return minor_version;
    }

    public static String getBuildVersion() {
        if (br != null) {
            return br.getBuildVersion();
        }
        return build_id;
    }

    public static String getVersionPrefix() {
        if (br != null) {
            return br.getVersionPrefix();
        }
        return version_prefix;
    }

    public static String getVersionSuffix() {
        if (br != null) {
            return br.getVersionSuffix();
        }
        return version_suffix;
    }

    public static String getProductName() {
        if (br != null) {
            return br.getProductName();
        }
        return product_name;
    }

    public static String getAbbrevProductName() {
        if (br != null) {
            return br.getAbbrevProductName();
        }
        return abbrev_product_name;
    }
}

