/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="enable")
@I18n(value="enable.command")
@Scoped(value=PerLookup.class)
public class EnableCommand
extends ApplicationLifecycle
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableCommand.class);
    @Inject
    ServerEnvironmentImpl env;
    @Param(primary=true)
    String component = null;
    @Param(optional=true)
    String target = "server";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(AdminCommandContext context) {
        parameters = context.getCommandParameters();
        report = context.getActionReport();
        if (!this.isRegistered(this.component)) {
            report.setMessage(EnableCommand.localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.component}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (Boolean.valueOf(ConfigBeansUtilities.getEnabled((String)this.target, (String)this.component)).booleanValue()) {
            this.logger.fine("The application is already enabled");
            return;
        }
        if (this.snifferManager.getSniffers().isEmpty()) {
            msg = EnableCommand.localStrings.getLocalString("nocontainer", "No container services registered, done...");
            this.logger.severe(msg);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        file = null;
        try {
            path = null;
            app = null;
            appRef = null;
            for (Module module : this.applications.getModules()) {
                if (!module.getName().equals(this.component)) continue;
                app = (Application)module;
                break;
            }
            for (ApplicationRef ref : this.server.getApplicationRef()) {
                if (!ref.getRef().equals(this.component)) continue;
                appRef = ref;
                break;
            }
            commandParams = this.populateDeployParamsFromDomainXML(app, appRef);
            contextProps = this.populateDeployPropsFromDomainXML(app);
            parameters.putAll((Map<?, ?>)commandParams);
            uri = new URI(parameters.getProperty("location"));
            file = new File(uri);
            if (!file.exists()) {
                report.setMessage(EnableCommand.localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            archive = this.archiveFactory.openArchive(file);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
            report.setMessage(EnableCommand.localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            block19: {
                archiveHandler = this.getArchiveHandler(archive);
                if (archiveHandler != null) break block19;
                report.setMessage(EnableCommand.localStrings.getLocalString("unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{file.getName()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                var14_16 = null;
                ** GOTO lbl85
            }
            deploymentContext = new DeploymentContextImpl(this.logger, archive, parameters, this.env);
            deploymentContext.setPhase(DeploymentContextImpl.Phase.PREPARE);
            deploymentContext.createClassLoaders(this.clh, archiveHandler);
            deploymentContext.setProps(contextProps);
            this.enable(this.component, deploymentContext, report);
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.setEnableAttributeInDomainXML(this.component, true);
            }
            ** GOTO lbl91
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during enabling: ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
            var14_18 = null;
            try {
                archive.close();
                return;
            }
            catch (IOException e) {
                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                return;
            }
        }
        {
            catch (Throwable var13_24) {
                var14_19 = null;
                ** try [egrp 3[TRYBLOCK] [8 : 628->638)] { 
lbl80:
                // 1 sources

                archive.close();
                throw var13_24;
lbl82:
                // 1 sources

                catch (IOException e) {
                    this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
                throw var13_24;
            }
lbl85:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [8 : 628->638)] { 
lbl86:
            // 1 sources

            archive.close();
            return;
lbl88:
            // 1 sources

            catch (IOException e) {
                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
            }
            return;
lbl91:
            // 1 sources

            var14_17 = null;
            try {}
            catch (IOException e) {}
            this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
            return;
            archive.close();
            return;
        }
    }
}

