/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractWombImpl;
import com.sun.hk2.component.ScopeInstance;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jvnet.hk2.annotations.Extract;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.Scope;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorWomb<T>
extends AbstractWombImpl<T> {
    private final Habitat habitat;
    private final ScopeInstance singletonScope;

    public ConstructorWomb(Class<T> type, Habitat habitat, MultiMap<String, String> metadata) {
        super(type, metadata);
        this.habitat = habitat;
        this.singletonScope = habitat.singletonScope;
    }

    @Override
    public T create(Inhabitant onBehalfOf) throws ComponentException {
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (IllegalAccessException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (LinkageError e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
    }

    @Override
    public void initialize(final T t, final Inhabitant onBehalfOf) throws ComponentException {
        Scoped scoped = t.getClass().getAnnotation(Scoped.class);
        ScopeInstance si = scoped == null ? this.singletonScope : this.getScope(scoped);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ConstructorWomb.this.inject(ConstructorWomb.this.habitat, t, onBehalfOf);
                return null;
            }
        });
        if (si != null) {
            this.extract(t, si);
        }
    }

    public void extract(Object component, ScopeInstance si) throws ComponentException {
        Class<?> currentClass = component.getClass();
        while (!currentClass.equals(Object.class)) {
            Extract extract;
            for (Field field : currentClass.getDeclaredFields()) {
                extract = field.getAnnotation(Extract.class);
                if (extract == null) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(component);
                    Class<?> type = field.getType();
                    if (value == null) continue;
                    this.extractValue(value, si, extract.name(), type);
                }
                catch (IllegalArgumentException ex) {
                    throw new ComponentException("Extraction failed on " + field, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new ComponentException("Extraction failed on " + field, ex);
                }
            }
            for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
                extract = ((Method)accessibleObject).getAnnotation(Extract.class);
                if (extract == null) continue;
                Class<?> type = ((Method)accessibleObject).getReturnType();
                if (type == null) {
                    throw new ComponentException("Extraction failed : %s has a void return type", accessibleObject);
                }
                if (((Method)accessibleObject).getParameterTypes().length > 0) {
                    throw new ComponentException("Extraction failed : %s takes parameters, it should not", accessibleObject);
                }
                try {
                    ((Method)accessibleObject).setAccessible(true);
                    Object value = ((Method)accessibleObject).invoke(component, new Object[0]);
                    if (value == null) continue;
                    this.extractValue(value, si, extract.name(), type);
                }
                catch (IllegalArgumentException ex) {
                    throw new ComponentException("Extraction failed on " + ((Method)accessibleObject).toGenericString(), ex);
                }
                catch (InvocationTargetException ex) {
                    throw new ComponentException("Extraction failed on " + ((Method)accessibleObject).toGenericString(), ex);
                }
                catch (IllegalAccessException ex) {
                    throw new ComponentException("Extraction failed on " + ((Method)accessibleObject).toGenericString(), ex);
                }
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    private void extractValue(Object value, ScopeInstance si, String name, Class type) {
        if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.extractSingleValue(o, name, type, si);
            }
        } else if (type.isArray()) {
            Object[] values;
            for (Object o : values = (Object[])value) {
                this.extractSingleValue(o, name, type, si);
            }
        } else {
            this.extractSingleValue(value, name, type, si);
        }
    }

    private <T> void extractSingleValue(T o, String name, Class type, final ScopeInstance si) {
        AbstractWombImpl i = new AbstractWombImpl<T>(o.getClass(), MultiMap.emptyMap()){

            @Override
            public T create(Inhabitant onBehalfOf) throws ComponentException {
                return si.get(this);
            }
        };
        if (name == null) {
            this.habitat.add(i);
        } else {
            this.habitat.addIndex(i, type.getName(), name);
        }
        si.put(i, o);
    }

    private ScopeInstance getScope(Scoped svc) throws ComponentException {
        Class<? extends Scope> s = svc.value();
        if (s == Singleton.class) {
            return this.singletonScope;
        }
        if (s == PerLookup.class) {
            return null;
        }
        Scope scope = this.habitat.getByType(s);
        ScopeInstance si = scope.current();
        if (si == null) {
            throw new ComponentException(scope + " returned null from the current() method");
        }
        return si;
    }
}

