/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validation.engine.BeanMetaDataCache;
import org.hibernate.validation.engine.BeanMetaDataImpl;
import org.hibernate.validation.engine.ConstraintHelper;
import org.hibernate.validation.engine.MetaConstraint;
import org.hibernate.validation.engine.ValidatorContextImpl;
import org.hibernate.validation.engine.xml.AnnotationIgnores;
import org.hibernate.validation.engine.xml.XmlMappingParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorFactoryImpl
implements ValidatorFactory {
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.constraintHelper = new ConstraintHelper();
        this.beanMetaDataCache = new BeanMetaDataCache();
        this.initBeanMetaData(configurationState.getMappingStreams());
    }

    @Override
    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    @Override
    public ValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.constraintHelper, this.beanMetaDataCache);
    }

    private <T> void initBeanMetaData(Set<InputStream> mappingStreams) {
        XmlMappingParser mappingParser = new XmlMappingParser(this.constraintHelper);
        mappingParser.parse(mappingStreams);
        AnnotationIgnores annotationIgnores = mappingParser.getAnnotationIgnores();
        for (Class<?> beanClass : mappingParser.getProcessedClasses()) {
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, annotationIgnores);
            for (MetaConstraint<?, ? extends Annotation> metaConstraint : mappingParser.getConstraintMap().get(beanClass)) {
                metaData.addMetaConstraint(metaConstraint);
            }
            for (Member member : mappingParser.getCascadedMembers().get(beanClass)) {
                metaData.addCascadedMember(member);
            }
            if (mappingParser.getDefaultSequences().containsKey(beanClass)) {
                metaData.setDefaultGroupSequence(mappingParser.getDefaultSequences().get(beanClass));
            }
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }
}

