/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.HtmlHelper;
import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.Task;
import com.sun.grizzly.http.TaskEvent;
import com.sun.grizzly.http.TaskListener;
import com.sun.grizzly.tcp.RequestGroupInfo;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskBase
implements Task,
TaskListener {
    protected int type;
    protected ArrayList<TaskListener> listeners;
    protected ExecutorService threadPool;
    protected SelectionKey key;
    protected boolean recycle = true;
    protected SelectorThread selectorThread;

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setSelectorThread(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    @Override
    public SelectorThread getSelectorThread() {
        return this.selectorThread;
    }

    @Override
    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.key;
    }

    @Override
    public RequestGroupInfo getRequestGroupInfo() {
        return this.selectorThread != null ? this.selectorThread.getRequestGroupInfo() : null;
    }

    @Override
    public boolean isMonitoringEnabled() {
        return this.selectorThread != null ? this.selectorThread.isMonitoringEnabled() : false;
    }

    @Override
    public KeepAliveStats getKeepAliveStats() {
        return this.selectorThread != null ? this.selectorThread.getKeepAliveStats() : null;
    }

    @Override
    public void execute() {
        if (this.threadPool != null) {
            this.threadPool.execute(this);
        } else {
            this.run();
        }
    }

    private void initListener() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    @Override
    public void addTaskListener(TaskListener task) {
        this.initListener();
        this.listeners.add(task);
    }

    @Override
    public void removeTaskListener(TaskListener task) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(task);
    }

    @Override
    public void clearTaskListeners() {
        if (this.listeners == null) {
            return;
        }
        this.listeners.clear();
    }

    protected void fireTaskEvent(TaskEvent<?> event) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskEvent(event);
        }
    }

    @Override
    public void recycle() {
    }

    @Override
    public ArrayList getTaskListeners() {
        this.initListener();
        return this.listeners;
    }

    @Override
    public void run() {
        try {
            this.doTask();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setRecycle(boolean recycle) {
        this.recycle = recycle;
    }

    @Override
    public boolean getRecycle() {
        return this.recycle;
    }

    public Socket getSocket() {
        return null;
    }

    private SocketChannel getChannel() {
        if (this.key == null) {
            return this.getSocket().getChannel();
        }
        return (SocketChannel)this.key.channel();
    }

    @Override
    public void cancelTask(String message, String code) {
        SocketChannel channel = this.getChannel();
        if (code != null) {
            SelectorThread.logger().log(Level.WARNING, message);
            try {
                ByteBuffer byteBuffer = HtmlHelper.getErrorPage(message, code);
                OutputWriter.flushChannel((SelectableChannel)channel, byteBuffer);
            }
            catch (IOException ex) {
                SelectorThread.logger().log(Level.FINE, "CancelTask failed", ex);
            }
        }
        TaskBase taskBase = this;
        if (taskBase.selectorThread.isEnableNioLogging()) {
            SelectorThread.logger().log(Level.INFO, "Cancelling SocketChannel " + this.getChannel());
        }
        if (this.key != null) {
            this.selectorThread.cancelKey(this.key);
        } else if (this.getSocket() != null) {
            try {
                this.getSocket().close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public Object call() throws Exception {
        this.doTask();
        return null;
    }

    @Override
    public void taskEvent(TaskEvent event) {
    }
}

