/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.util.SelectorFactory;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public class OutputWriter {
    private static int defaultWriteTimeout = 30000;

    public static long flushChannel(SelectableChannel channel, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(channel, bb, (long)defaultWriteTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long flushChannel(SelectableChannel channel, ByteBuffer bb, long writeTimeout) throws IOException {
        int len;
        int nWrite;
        SelectionKey key;
        block13: {
            if (bb == null) {
                throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
            }
            if (channel == null) {
                throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
            }
            key = null;
            Selector writeSelector = null;
            int attempts = 0;
            nWrite = 0;
            len = -1;
            try {
                try {
                    WritableByteChannel writableChannel = (WritableByteChannel)((Object)channel);
                    while (bb.hasRemaining()) {
                        len = writableChannel.write(bb);
                        if (len > 0) {
                            attempts = 0;
                            nWrite += len;
                            continue;
                        }
                        ++attempts;
                        if (writeSelector == null) {
                            writeSelector = SelectorFactory.getSelector();
                            if (writeSelector == null) continue;
                            key = channel.register(writeSelector, 4);
                        }
                        if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
                        throw new IOException("Client disconnected");
                    }
                    Object var11_10 = null;
                    if (key != null) {
                        key.cancel();
                        key = null;
                    }
                    if (writeSelector == null) break block13;
                }
                catch (IOException ex) {
                    len = -1;
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (key != null) {
                    key.cancel();
                    key = null;
                }
                if (writeSelector != null) {
                    SelectorFactory.selectNowAndReturnSelector(writeSelector);
                }
                if (len != -1) throw throwable;
                if (!(Thread.currentThread() instanceof WorkerThread)) throw throwable;
                ConnectionCloseHandler cch222 = (ConnectionCloseHandler)((WorkerThread)Thread.currentThread()).getAttachment().getAttribute("ConnectionCloseHandler");
                if (cch222 == null) throw throwable;
                cch222.remotlyClosed(key);
                throw throwable;
            }
            SelectorFactory.selectNowAndReturnSelector(writeSelector);
        }
        if (len != -1) return nWrite;
        if (!(Thread.currentThread() instanceof WorkerThread)) return nWrite;
        ConnectionCloseHandler cch222 = (ConnectionCloseHandler)((WorkerThread)Thread.currentThread()).getAttachment().getAttribute("ConnectionCloseHandler");
        if (cch222 == null) return nWrite;
        cch222.remotlyClosed(key);
        return nWrite;
    }

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb, long writeTimeout) throws IOException {
        ByteBuffer aBb;
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (socketChannel == null) {
            throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        long totalBytes = 0L;
        ByteBuffer[] arr$ = bb;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; totalBytes += (long)aBb.remaining(), ++i$) {
            aBb = arr$[i$];
        }
        long nWrite = 0L;
        long len = -1L;
        try {
            try {}
            catch (IOException ex) {
                len = -1L;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(writeSelector);
            }
            if (len != -1L) throw throwable;
            if (!(Thread.currentThread() instanceof WorkerThread)) throw throwable;
            ConnectionCloseHandler cch222 = (ConnectionCloseHandler)((WorkerThread)Thread.currentThread()).getAttachment().getAttribute("ConnectionCloseHandler");
            if (cch222 == null) throw throwable;
            cch222.remotlyClosed(key);
            throw throwable;
        }
        while (nWrite < totalBytes) {
            len = socketChannel.write(bb);
            if (len > 0L) {
                attempts = 0;
                nWrite += len;
                continue;
            }
            if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
            key = socketChannel.register(writeSelector, 4);
            if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
            throw new IOException("Client disconnected");
        }
        Object var15_13 = null;
        if (key != null) {
            key.cancel();
            key = null;
        }
        if (writeSelector != null) {
            SelectorFactory.selectNowAndReturnSelector(writeSelector);
        }
        if (len != -1L) return nWrite;
        if (!(Thread.currentThread() instanceof WorkerThread)) return nWrite;
        ConnectionCloseHandler cch222 = (ConnectionCloseHandler)((WorkerThread)Thread.currentThread()).getAttachment().getAttribute("ConnectionCloseHandler");
        if (cch222 == null) return nWrite;
        cch222.remotlyClosed(key);
        return nWrite;
    }

    public static long flushChannel(DatagramChannel datagramChannel, SocketAddress socketAddress, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(datagramChannel, socketAddress, bb, defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long flushChannel(DatagramChannel datagramChannel, SocketAddress socketAddress, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (datagramChannel == null) {
            throw new IllegalStateException("Invalid Response State. DatagramChannel cannot be null.");
        }
        if (socketAddress == null) {
            throw new IllegalStateException("Invalid Response State. SocketAddress cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int nWrite = 0;
        try {
            while (bb.hasRemaining()) {
                int len = datagramChannel.send(bb, socketAddress);
                if (len > 0) {
                    attempts = 0;
                    nWrite += len;
                    continue;
                }
                if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                key = datagramChannel.register(writeSelector, 4);
                if (writeSelector.select(writeTimeout) == 0) {
                    if (attempts <= 2) continue;
                    throw new IOException("Client disconnected");
                }
                --attempts;
            }
            Object var11_9 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) return nWrite;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) throw throwable;
            SelectorFactory.selectNowAndReturnSelector(writeSelector);
            throw throwable;
        }
        SelectorFactory.selectNowAndReturnSelector(writeSelector);
        return nWrite;
    }

    public static int getDefaultWriteTimeout() {
        return defaultWriteTimeout;
    }

    public static void setDefaultWriteTimeout(int aDefaultWriteTimeout) {
        defaultWriteTimeout = aDefaultWriteTimeout;
    }
}

