/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CommandRunner;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="redeploy")
@Scoped(value=PerLookup.class)
@I18n(value="redeploy.command")
public class ReDeployCommand
extends ApplicationLifecycle
implements AdminCommand {
    @Inject
    CommandRunner commandRunner;
    @Param(optional=false)
    String name;
    @Param(primary=true, optional=true)
    String path = null;
    @Param(optional=true)
    Properties properties = null;
    boolean skipParamValidation = true;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ReDeployCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.validateParameters(this.name, report)) {
            return;
        }
        Properties deployParam = new Properties(context.getCommandParameters());
        deployParam.put("force", Boolean.TRUE.toString());
        deployParam.put("path", this.path);
        if (context.getUploadedFiles().size() >= 1) {
            this.commandRunner.doCommand("deploy", deployParam, report, context.getUploadedFiles());
        } else {
            this.commandRunner.doCommand("deploy", deployParam, report);
        }
    }

    boolean validateParameters(String name, ActionReport report) {
        if (!this.isRegistered(name)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.path == null && !Boolean.parseBoolean(ConfigBeansUtilities.getDirectoryDeployed((String)name))) {
            report.setMessage(localStrings.getLocalString("redeploy.command.cannot.redeploy", "Cannot redeploy this app {0} without specify the operand.", new Object[]{name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        String string = this.path = this.path == null ? ConfigBeansUtilities.getLocation((String)name) : this.path;
        if (this.path == null) {
            report.setMessage(localStrings.getLocalString("redeploy.command.invalid.path", "Cannot determine the path of application."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

