/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public final class Transactions {
    private static Transactions singleton;
    List<ListenerInfo<TransactionListener>> listeners;
    ExecutorService executor;
    private ListenerInfo<Object> configListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionsListener(TransactionListener listener) {
        List<ListenerInfo<TransactionListener>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(new ListenerInfo<TransactionListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTransactionsListener(TransactionListener listener) {
        List<ListenerInfo<TransactionListener>> list = this.listeners;
        synchronized (list) {
            for (ListenerInfo<TransactionListener> info : this.listeners) {
                if (((ListenerInfo)info).listener != listener) continue;
                info.stop();
                return this.listeners.remove(info);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionListener> currentListeners() {
        List<ListenerInfo<TransactionListener>> list = this.listeners;
        synchronized (list) {
            ArrayList<TransactionListener> l = new ArrayList<TransactionListener>();
            for (ListenerInfo<TransactionListener> info : this.listeners) {
                l.add((TransactionListener)((ListenerInfo)info).listener);
            }
            return l;
        }
    }

    void addTransaction(List<PropertyChangeEvent> events) {
        this.addTransaction(events, false);
    }

    void addTransaction(List<PropertyChangeEvent> events, boolean waitTillCleared) {
        ArrayList<ListenerInfo<TransactionListener>> listInfos = new ArrayList<ListenerInfo<TransactionListener>>();
        listInfos.addAll(this.listeners);
        CountDownLatch latch = waitTillCleared ? new CountDownLatch(listInfos.size() + 1) : null;
        TransactionListenerJob job = new TransactionListenerJob(events, latch);
        try {
            for (ListenerInfo listenerInfo : listInfos) {
                listenerInfo.addTransaction(job);
            }
            this.configListeners.addTransaction(new ConfigListenerJob(events, latch));
            job.waitForLatch();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitForDrain() {
        this.addTransaction(new ArrayList<PropertyChangeEvent>(), true);
    }

    private Transactions(ExecutorService executor) {
        this.executor = executor;
        this.listeners = new ArrayList<ListenerInfo<TransactionListener>>();
        this.configListeners = new ListenerInfo<Object>(null);
    }

    public static synchronized Transactions get(ExecutorService executor) {
        if (singleton == null) {
            singleton = new Transactions(executor);
        }
        return singleton;
    }

    public static final Transactions get() {
        return singleton;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigListenerJob
    extends Job<Object, PropertyChangeEvent> {
        public ConfigListenerJob(List events, CountDownLatch latch) {
            super(events, latch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Object target) {
            HashSet<ConfigListener> notifiedListeners = new HashSet<ConfigListener>();
            ArrayList<UnprocessedChangeEvents> unprocessedEvents = new ArrayList<UnprocessedChangeEvents>();
            for (PropertyChangeEvent evt : this.mEvents) {
                UnprocessedChangeEvents unprocessed;
                Dom dom = (Dom)((Object)((ConfigView)Proxy.getInvocationHandler(evt.getSource())).getMasterView());
                if (dom.getListeners() != null && dom.getListeners().size() != 0) {
                    ArrayList<ConfigListener> listeners = new ArrayList<ConfigListener>(dom.getListeners());
                    for (ConfigListener listener : listeners) {
                        if (listener == null) {
                            Logger.getAnonymousLogger().warning("Null config listener is registered to " + dom);
                            continue;
                        }
                        if (!notifiedListeners.contains(listener)) {
                            try {
                                unprocessed = listener.changed(this.mEvents.toArray(new PropertyChangeEvent[this.mEvents.size()]));
                                if (unprocessed != null && unprocessed.size() != 0) {
                                    unprocessedEvents.add(unprocessed);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        notifiedListeners.add(listener);
                    }
                }
                if (dom.parent() == null || dom.parent().getListeners() == null) continue;
                ArrayList<ConfigListener> parentListeners = new ArrayList<ConfigListener>(dom.parent().getListeners());
                for (ConfigListener parentListener : parentListeners) {
                    if (parentListener == null) {
                        Logger.getAnonymousLogger().warning("Null config listener is registered to " + dom);
                        continue;
                    }
                    if (notifiedListeners.contains(parentListener)) continue;
                    try {
                        unprocessed = parentListener.changed(this.mEvents.toArray(new PropertyChangeEvent[this.mEvents.size()]));
                        if (unprocessed != null && unprocessed.size() != 0) {
                            unprocessedEvents.add(unprocessed);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    notifiedListeners.add(parentListener);
                }
            }
            if (!unprocessedEvents.isEmpty()) {
                List<ListenerInfo<TransactionListener>> list = Transactions.this.listeners;
                synchronized (list) {
                    UnprocessedEventsJob job = new UnprocessedEventsJob(unprocessedEvents, null);
                    for (ListenerInfo<TransactionListener> listener : Transactions.this.listeners) {
                        listener.addTransaction(job);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnprocessedEventsJob
    extends Job<TransactionListener, UnprocessedChangeEvents> {
        public UnprocessedEventsJob(List<UnprocessedChangeEvents> events, CountDownLatch latch) {
            super(events, latch);
        }

        @Override
        public void process(TransactionListener listener) {
            try {
                listener.unprocessedTransactedEvents(this.mEvents);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransactionListenerJob
    extends Job<TransactionListener, PropertyChangeEvent> {
        public TransactionListenerJob(List<PropertyChangeEvent> events, CountDownLatch latch) {
            super(events, latch);
        }

        @Override
        public void process(TransactionListener listener) {
            try {
                listener.transactionCommited(this.mEvents);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Job<T, U> {
        private final CountDownLatch mLatch;
        protected final List<U> mEvents;

        public Job(List events, CountDownLatch latch) {
            this.mLatch = latch;
            this.mEvents = events;
        }

        public void waitForLatch() throws InterruptedException {
            if (this.mLatch != null) {
                this.mLatch.await();
            }
        }

        public void releaseLatch() {
            if (this.mLatch != null) {
                this.mLatch.countDown();
            }
        }

        public abstract void process(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ListenerInfo<T> {
        private final T listener;
        private final BlockingQueue<Job> pendingJobs = new ArrayBlockingQueue<Job>(50);
        private CountDownLatch latch = new CountDownLatch(1);

        public ListenerInfo(T listener) {
            this.listener = listener;
            this.start();
        }

        public void addTransaction(Job job) {
            if (this.latch.getCount() == 0L) {
                throw new RuntimeException("TransactionListener is inactive, yet jobs are published to it");
            }
            try {
                this.pendingJobs.put(job);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private void start() {
            Transactions.this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (ListenerInfo.this.latch.getCount() > 0L) {
                        try {
                            Job job = (Job)ListenerInfo.this.pendingJobs.take();
                            try {
                                if (job.mEvents.size() == 0) continue;
                                job.process(ListenerInfo.this.listener);
                            }
                            finally {
                                job.releaseLatch();
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
        }

        void stop() {
            this.latch.countDown();
            this.pendingJobs.add(new TransactionListenerJob(new ArrayList<PropertyChangeEvent>(), null));
        }
    }
}

