/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.FileList;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileAction
extends Action
implements FileList.DataSink {
    Image img;
    Fmri fmri;
    String path = "";
    String hash;
    String owner = "";
    String group = "";
    String mode = "";
    int size;
    File gzipfile;

    FileAction(Image image, Fmri f, String[] tokens) {
        super(6);
        this.img = image;
        this.fmri = f;
        this.hash = tokens[1];
        for (int i = 2; i < tokens.length; ++i) {
            if (tokens[i].startsWith("owner=")) {
                this.owner = tokens[i].substring(6);
                continue;
            }
            if (tokens[i].startsWith("path=")) {
                this.path = tokens[i].substring(5);
                continue;
            }
            if (tokens[i].startsWith("mode=")) {
                this.mode = tokens[i].substring(5);
                continue;
            }
            if (tokens[i].startsWith("group=")) {
                this.group = tokens[i].substring(6);
                continue;
            }
            if (!tokens[i].startsWith("pkg.size=")) continue;
            this.size = Integer.parseInt(tokens[i].substring(9));
        }
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setGzipFile(File f) {
        this.gzipfile = f;
    }

    @Override
    void preinstall(Action orig, FileList flist) {
        flist.add(this);
    }

    @Override
    void install(Action orig) throws IOException {
        int n;
        if (this.gzipfile == null || this.path == null) {
            return;
        }
        File target = new File(this.img.getRootDirectory(), this.path);
        target.delete();
        target.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(target);
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(this.gzipfile));
        byte[] buf = new byte[4096];
        while ((n = gis.read(buf)) > 0) {
            fos.write(buf, 0, n);
        }
        fos.close();
        gis.close();
        this.setPermissions(target, this.mode);
    }

    @Override
    void remove() throws IOException {
        File target = new File(this.img.getRootDirectory(), this.path);
        this.setPermissions(target, "0644");
        target.delete();
    }

    @Override
    List<File> getReferencedDirectories() {
        ArrayList<File> l = new ArrayList<File>(1);
        l.add(new File(this.path).getParentFile());
        return l;
    }

    @Override
    String keyValue() {
        return this.path;
    }

    public String toString() {
        return "file: path=" + this.path;
    }

    @Override
    boolean isDifferent(Action a) {
        if (!(a instanceof FileAction)) {
            return true;
        }
        FileAction fa = (FileAction)a;
        return !this.equals(a) || !this.hash.equals(fa.hash) || !this.owner.equals(fa.owner) || !this.group.equals(fa.group) || !this.mode.equals(fa.mode);
    }
}

