/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyActionAttachment;
import com.sun.grizzly.util.SelectionKeyAttachment;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSelectionKeyHandler
implements SelectionKeyHandler {
    protected Logger logger = Controller.logger();
    private ConnectionCloseHandler cch = new ConnectionCloseHandler(){

        public void locallyClosed(SelectionKey key) {
            if (BaseSelectionKeyHandler.this.logger.isLoggable(Level.FINE)) {
                BaseSelectionKeyHandler.this.logger.fine(key + " is being locally cancelled");
            }
        }

        public void remotlyClosed(SelectionKey key) {
            if (BaseSelectionKeyHandler.this.logger.isLoggable(Level.FINE)) {
                BaseSelectionKeyHandler.this.logger.fine(key + " is being remotly cancelled (connection closed)");
            }
        }
    };
    protected SelectorHandler selectorHandler;

    public BaseSelectionKeyHandler() {
    }

    public BaseSelectionKeyHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    @Override
    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    @Override
    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    @Override
    public void process(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment instanceof SelectionKeyActionAttachment) {
            ((SelectionKeyActionAttachment)attachment).process(key);
        }
    }

    @Override
    public void postProcess(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment instanceof SelectionKeyActionAttachment) {
            ((SelectionKeyActionAttachment)attachment).postProcess(key);
        }
    }

    @Override
    public void register(SelectionKey key, long currentTime) {
        throw new UnsupportedOperationException(this.getClass().getName() + " use of this API not allowed.");
    }

    @Override
    public void register(SelectionKey key, int selectionKeyOps) {
        this.doRegisterKey(key, selectionKeyOps);
    }

    protected void doRegisterKey(SelectionKey key, int selectionKeyOps) {
        if (!key.isValid()) {
            return;
        }
        key.interestOps(key.interestOps() | selectionKeyOps);
    }

    @Override
    public void register(SelectableChannel channel, int selectionKeyOps) throws ClosedChannelException {
        if (!channel.isOpen()) {
            return;
        }
        Selector selector = this.selectorHandler.getSelector();
        SelectionKey key = channel.keyFor(selector);
        if (key == null) {
            channel.register(selector, selectionKeyOps);
        } else {
            this.doRegisterKey(key, selectionKeyOps);
        }
    }

    @Override
    public void register(Iterator<SelectionKey> keyIterator, int selectionKeyOps) {
        while (keyIterator.hasNext()) {
            SelectionKey key = keyIterator.next();
            keyIterator.remove();
            this.doRegisterKey(key, selectionKeyOps);
        }
    }

    @Override
    public void expire(SelectionKey key, long currentTime) {
    }

    @Override
    public void expire(Iterator<SelectionKey> keyIterator) {
    }

    @Override
    public void cancel(SelectionKey key) {
        if (!this.keyIsValid(key)) {
            return;
        }
        this.closeChannel(key);
        this.cch.locallyClosed(key);
        this.clearKeyAttachment(key);
        this.cancelKey(key);
    }

    public void notifyRemotlyClose(SelectionKey key) {
        this.cch.remotlyClosed(key);
    }

    @Override
    public void close(SelectionKey key) {
        this.cancel(key);
    }

    @Override
    public void copyTo(Copyable copy) {
        BaseSelectionKeyHandler copyHandler = (BaseSelectionKeyHandler)copy;
        copyHandler.selectorHandler = this.selectorHandler;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected void cancelKey(SelectionKey key) {
        key.cancel();
        key = null;
    }

    protected boolean keyIsValid(SelectionKey key) {
        return key != null && key.isValid();
    }

    protected void closeChannel(SelectionKey key) {
        if (this.selectorHandler != null) {
            this.selectorHandler.closeChannel(key.channel());
        } else {
            this.closeChannel(key.channel());
        }
    }

    protected Object clearKeyAttachment(SelectionKey key) {
        Object attachment = key.attach(null);
        if (attachment instanceof SelectionKeyAttachment) {
            ((SelectionKeyAttachment)attachment).release(key);
        }
        return attachment;
    }

    protected void closeChannel(SelectableChannel channel) {
        try {
            if (channel instanceof SocketChannel) {
                Socket socket = ((SocketChannel)channel).socket();
                try {
                    if (!socket.isInputShutdown()) {
                        socket.shutdownInput();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BaseSelectionKeyHandler.class.getName()).log(Level.FINE, null, ex);
                }
                try {
                    if (!socket.isOutputShutdown()) {
                        socket.shutdownOutput();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BaseSelectionKeyHandler.class.getName()).log(Level.FINE, null, ex);
                }
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(BaseSelectionKeyHandler.class.getName()).log(Level.FINE, null, ex);
                }
            }
            channel.close();
        }
        catch (IOException ex) {
            Logger.getLogger(BaseSelectionKeyHandler.class.getName()).log(Level.FINE, null, ex);
        }
    }

    public ConnectionCloseHandler getConnectionCloseHandler() {
        return this.cch;
    }

    public void setConnectionCloseHandler(ConnectionCloseHandler cch) {
        this.cch = cch;
    }
}

