/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.LoggerUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;

public class ClassLoaderUtil {
    public static final ClassLoader createClassloader(File libDir, ClassLoader cl) throws IOException {
        URLClassLoader urlClassloader = null;
        if (libDir.exists() && libDir.isDirectory()) {
            String[] jars = libDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            URL[] urls = new URL[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                String path = new File(libDir.getName() + File.separator + jars[i]).getCanonicalFile().toURL().toString();
                urls[i] = new URL(path);
            }
            urlClassloader = new URLClassLoader(urls, cl);
        }
        return urlClassloader;
    }

    public static Object load(String clazzName) {
        return ClassLoaderUtil.load(clazzName, Thread.currentThread().getContextClassLoader());
    }

    public static Object load(String clazzName, ClassLoader classLoader) {
        Class<?> className = null;
        try {
            className = Class.forName(clazzName, true, classLoader);
            return className.newInstance();
        }
        catch (Throwable t) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Unable to load class " + clazzName, t);
            return null;
        }
    }
}

