/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.server.AppServerStartup;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.SnifferManager;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerInfo;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ApplicationLifecycle {
    @Inject
    protected SnifferManager snifferManager;
    @Inject
    Habitat habitat;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    protected GrizzlyService adapter;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected Applications applications;
    @Inject
    protected Server server;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    protected ClassLoaderHierarchy clh;
    protected Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);

    protected <T extends Container, U extends ApplicationContainer> Deployer<T, U> getDeployer(ContainerInfo<T, U> containerInfo) {
        return containerInfo.getDeployer();
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) throws IOException {
        for (ArchiveHandler handler : this.habitat.getAllByContract(ArchiveHandler.class)) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        return null;
    }

    public ApplicationInfo deploy(Iterable<Sniffer> sniffers, final DeploymentContextImpl context, final ActionReport report) {
        final ApplicationLifecycle myself = this;
        ProgressTracker tracker = new ProgressTracker(){

            public void actOn(Logger logger) {
                for (ModuleInfo module : this.get("started", ModuleInfo.class)) {
                    module.stop((ApplicationContext)context, logger);
                }
                for (ModuleInfo module : this.get(ModuleInfo.class)) {
                    module.unload(null, (DeploymentContext)context, report);
                }
                myself.clean(this.get(Deployer.class).toArray(new Deployer[0]), (DeploymentContext)context);
                ApplicationLifecycle.this.stopContainers(this.get(ContainerInfo.class).toArray(new ContainerInfo[0]), logger);
            }
        };
        context.setPhase(DeploymentContextImpl.Phase.PREPARE);
        try {
            ArchiveHandler handler = this.getArchiveHandler(context.getSource());
            context.createClassLoaders(this.clh, handler);
            LinkedList<ContainerInfo> sortedContainerInfos = this.setupContainerInfos(sniffers, context, report, tracker);
            if (sortedContainerInfos == null || sortedContainerInfos.isEmpty()) {
                report.failure(this.logger, "There is no installed container capable of handling this application", null);
                tracker.actOn(this.logger);
                return null;
            }
            ApplicationInfo appInfo = this.prepare(sortedContainerInfos, context, report, tracker);
            if ((appInfo = this.load(sortedContainerInfos, appInfo, context, report, tracker)) == null) {
                report.failure(this.logger, "Exception while loading the app", null);
                tracker.actOn(this.logger);
                return null;
            }
            if (Boolean.valueOf(context.getCommandParameters().getProperty("enabled")).booleanValue()) {
                appInfo.start((DeploymentContext)context, report, tracker);
            }
            return appInfo;
        }
        catch (Exception e) {
            report.failure(this.logger, "Exception while deploying the app", (Throwable)e);
            tracker.actOn(this.logger);
            return null;
        }
    }

    public ApplicationInfo enable(String appName, final DeploymentContextImpl context, final ActionReport report) {
        final ApplicationInfo appInfo = this.appRegistry.get(appName);
        Collection<Sniffer> sniffers = this.snifferManager.getSniffers(context.getSource(), context.getClassLoader());
        if (appInfo != null) {
            ProgressTracker tracker = new ProgressTracker(){

                public void actOn(Logger logger) {
                    for (ModuleInfo module : this.get("started", ModuleInfo.class)) {
                        module.unload(appInfo, (DeploymentContext)context, report);
                    }
                }
            };
            try {
                ArchiveHandler handler = this.getArchiveHandler(context.getSource());
                context.createClassLoaders(this.clh, handler);
                ArrayList<ContainerInfo> containerInfos = new ArrayList<ContainerInfo>();
                for (Sniffer sniffer : sniffers) {
                    containerInfos.add(this.containerRegistry.getContainer(sniffer.getContainersNames()[0]));
                }
                if (sniffers.size() == 0) {
                    report.setMessage(localStrings.getLocalString("unknownmoduletpe", "Module type not recognized"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return null;
                }
                this.load(containerInfos, appInfo, context, report, tracker);
                appInfo.start((DeploymentContext)context, report, tracker);
                return appInfo;
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while enabling the app", (Throwable)e);
                tracker.actOn(this.logger);
                return null;
            }
        }
        return this.deploy(sniffers, context, report);
    }

    public void disable(String appName, DeploymentContext context, ActionReport report) {
        this.unload(appName, context, report);
    }

    public boolean suspend(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.suspend(this.logger);
        }
        return isSuccess;
    }

    public boolean resume(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.resume(this.logger);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList<ContainerInfo> setupContainerInfos(Iterable<Sniffer> sniffers, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        HashMap<Deployer, ContainerInfo> containerInfosByDeployers = new HashMap<Deployer, ContainerInfo>();
        for (Sniffer sniffer : sniffers) {
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                report.failure(this.logger, "no container associated with application of type : " + sniffer.getModuleType(), null);
                return null;
            }
            com.sun.enterprise.module.Module snifferModule = this.modulesRegistry.find(sniffer.getClass());
            if (snifferModule == null) {
                report.failure(this.logger, "cannot find container module from service implementation " + sniffer.getClass(), null);
                return null;
            }
            String containerName = sniffer.getContainersNames()[0];
            ContainerInfo containerInfo = this.containerRegistry.getContainer(containerName);
            if (containerInfo == null) {
                Collection<ContainerInfo> containersInfo = null;
                ContainerRegistry containerRegistry = this.containerRegistry;
                synchronized (containerRegistry) {
                    if (this.containerRegistry.getContainer(containerName) == null && ((containersInfo = this.setupContainer(sniffer, snifferModule, this.logger, report)) == null || containersInfo.size() == 0)) {
                        String msg = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                        report.failure(this.logger, msg, null);
                        throw new Exception(msg);
                    }
                }
                if (!this.startContainers(containersInfo, this.logger, report)) {
                    String msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
                tracker.addAll(ContainerInfo.class, containersInfo);
            }
            if ((containerInfo = this.containerRegistry.getContainer(sniffer.getContainersNames()[0])) == null) {
                String msg = "Aborting, Failed to start container " + containerName;
                report.failure(this.logger, msg, null);
                throw new Exception(msg);
            }
            Deployer deployer = this.getDeployer(containerInfo);
            if (deployer == null) {
                report.failure(this.logger, "Got a null deployer out of the " + containerInfo.getContainer().getClass() + " container");
                return null;
            }
            containerInfosByDeployers.put(deployer, containerInfo);
        }
        LinkedList providers = new LinkedList();
        providers.addAll(this.habitat.getAllByContract(ApplicationMetaDataProvider.class));
        LinkedList<ContainerInfo> sortedContainerInfos = new LinkedList<ContainerInfo>();
        HashMap<Class, ApplicationMetaDataProvider> typeByProvider = new HashMap<Class, ApplicationMetaDataProvider>();
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class provided : provider.getMetaData().provides()) {
                typeByProvider.put(provided, provider);
            }
        }
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class dependency : provider.getMetaData().requires()) {
                if (typeByProvider.containsKey(dependency)) continue;
                report.failure(this.logger, "ApplicationMetaDataProvider " + provider + " requires " + dependency + " but no other ApplicationMetaDataProvider provides it", null);
                return null;
            }
        }
        HashMap<Class, Deployer> typeByDeployer = new HashMap<Class, Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class provided : deployer.getMetaData().provides()) {
                typeByDeployer.put(provided, deployer);
            }
        }
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class dependency : deployer.getMetaData().requires()) {
                if (typeByDeployer.containsKey(dependency) || typeByProvider.containsKey(dependency)) continue;
                report.failure(this.logger, "Deployer " + dependency + " requires " + deployer + " but no other deployer provides it", null);
                return null;
            }
        }
        LinkedList<Deployer> orderedDeployers = new LinkedList<Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            this.loadDeployer(orderedDeployers, deployer, typeByDeployer, typeByProvider, (DeploymentContext)context);
        }
        for (Deployer deployer : orderedDeployers) {
            MetaData metadata = deployer.getMetaData();
            try {
                if (metadata != null) {
                    if (metadata.provides() == null || metadata.provides().length == 0) {
                        deployer.loadMetaData(null, (DeploymentContext)context);
                    } else {
                        for (Class provide : metadata.provides()) {
                            if (context.getModuleMetaData(provide) != null) continue;
                            context.addModuleMetaData(deployer.loadMetaData(provide, (DeploymentContext)context));
                        }
                    }
                } else {
                    deployer.loadMetaData(null, (DeploymentContext)context);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", (Throwable)e);
                throw e;
            }
            sortedContainerInfos.add((ContainerInfo)containerInfosByDeployers.get(deployer));
        }
        return sortedContainerInfos;
    }

    private void loadDeployer(LinkedList<Deployer> results, Deployer deployer, Map<Class, Deployer> typeByDeployer, Map<Class, ApplicationMetaDataProvider> typeByProvider, DeploymentContext dc) throws IOException {
        if (results.contains(deployer)) {
            return;
        }
        results.addFirst(deployer);
        if (deployer.getMetaData() != null) {
            for (Class required : deployer.getMetaData().requires()) {
                if (typeByDeployer.containsKey(required)) {
                    this.loadDeployer(results, typeByDeployer.get(required), typeByDeployer, typeByProvider, dc);
                    continue;
                }
                ApplicationMetaDataProvider provider = typeByProvider.get(required);
                if (provider == null) {
                    this.logger.severe("I don't get it, file a bug, no-one is providing " + required + " yet it passed validation");
                    continue;
                }
                LinkedList<ApplicationMetaDataProvider> providers = new LinkedList<ApplicationMetaDataProvider>();
                this.addRecursively(providers, typeByProvider, provider);
                for (ApplicationMetaDataProvider p : providers) {
                    dc.addModuleMetaData(p.load(dc));
                }
            }
        }
    }

    private void addRecursively(LinkedList<ApplicationMetaDataProvider> results, Map<Class, ApplicationMetaDataProvider> providers, ApplicationMetaDataProvider provider) {
        results.addFirst(provider);
        for (Class type : provider.getMetaData().requires()) {
            if (!providers.containsKey(type)) continue;
            this.addRecursively(results, providers, providers.get(type));
        }
    }

    public ApplicationInfo prepare(LinkedList<ContainerInfo> sortedContainerInfos, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            try {
                deployer.prepare((DeploymentContext)context);
                ModuleInfo moduleInfo = new ModuleInfo(containerInfo, (RequestDispatcher)this.adapter, null);
                tracker.add(ModuleInfo.class, (Object)moduleInfo);
                tracker.add(Deployer.class, (Object)deployer);
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", (Throwable)e);
                throw e;
            }
        }
        String appName = context.getCommandParameters().getProperty("name");
        ApplicationInfo appInfo = new ApplicationInfo(context.getSource(), appName, tracker.get(ModuleInfo.class).toArray(new ModuleInfo[0]));
        this.appRegistry.add(appName, appInfo);
        return appInfo;
    }

    public ApplicationInfo load(List<ContainerInfo> sortedContainerInfos, ApplicationInfo appInfo, DeploymentContextImpl context, ActionReport report, ProgressTracker tracker) throws Exception {
        context.setPhase(DeploymentContextImpl.Phase.LOAD);
        ModuleInfo[] moduleInfos = tracker.get(ModuleInfo.class).toArray(new ModuleInfo[0]);
        if (!context.getTransformers().isEmpty()) {
            try {
                InstrumentableClassLoader icl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(context.getFinalClassLoader());
                for (ClassFileTransformer transformer : context.getTransformers()) {
                    icl.addTransformer(transformer);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Class loader used for loading application cannot handle bytecode enhancer", (Throwable)e);
                throw e;
            }
        }
        block8: for (ContainerInfo containerInfo : sortedContainerInfos) {
            Deployer deployer = containerInfo.getDeployer();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                ApplicationContainer appCtr = deployer.load(containerInfo.getContainer(), (DeploymentContext)context);
                if (appCtr == null) {
                    String msg = "Cannot load application in " + containerInfo.getContainer().getName() + " container";
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
                if (moduleInfos.length == 0) {
                    ModuleInfo moduleInfo = new ModuleInfo(containerInfo, (RequestDispatcher)this.adapter, appCtr);
                    tracker.add(ModuleInfo.class, (Object)moduleInfo);
                    continue;
                }
                for (ModuleInfo moduleInfo : moduleInfos) {
                    if (!moduleInfo.getContainerInfo().getContainer().getName().equals(containerInfo.getContainer().getName())) continue;
                    moduleInfo.setApplicationContainer(appCtr);
                    continue block8;
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", (Throwable)e);
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        if (appInfo == null) {
            String appName = context.getCommandParameters().getProperty("name");
            appInfo = new ApplicationInfo(context.getSource(), appName, tracker.get(ModuleInfo.class).toArray(new ModuleInfo[0]));
        }
        return appInfo;
    }

    protected void clean(Deployer[] deployers, DeploymentContext context) {
        for (Deployer deployer : deployers) {
            try {
                deployer.clean(context);
            }
            catch (Throwable e) {
                context.getLogger().log(Level.INFO, "Deployer.clean failed for " + deployer, e);
            }
        }
    }

    protected Collection<ContainerInfo> setupContainer(Sniffer sniffer, com.sun.enterprise.module.Module snifferModule, Logger logger, ActionReport report) {
        ContainerStarter starter = (ContainerStarter)this.habitat.getComponent(ContainerStarter.class);
        Collection<ContainerInfo> containersInfo = starter.startContainer(sniffer, snifferModule);
        if (containersInfo == null || containersInfo.size() == 0) {
            report.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null);
            return null;
        }
        return containersInfo;
    }

    protected boolean startContainers(Collection<ContainerInfo> containersInfo, Logger logger, ActionReport report) {
        for (ContainerInfo containerInfo : containersInfo) {
            Container container;
            try {
                container = containerInfo.getContainer();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot start container  " + containerInfo.getSniffer().getModuleType(), e);
                return false;
            }
            Class deployerClass = container.getDeployer();
            try {
                Deployer deployer = (Deployer)this.habitat.getComponent(deployerClass);
                containerInfo.setDeployer(deployer);
            }
            catch (ComponentException e) {
                report.failure(logger, "Cannot instantiate or inject " + deployerClass, (Throwable)e);
                this.stopContainer(logger, containerInfo);
                return false;
            }
            catch (ClassCastException e) {
                this.stopContainer(logger, containerInfo);
                report.failure(logger, deployerClass + " does not implement " + " the org.jvnet.glassfish.api.deployment.Deployer interface", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected void stopContainers(ContainerInfo[] ctrInfos, Logger logger) {
        for (ContainerInfo ctrInfo : ctrInfos) {
            try {
                this.stopContainer(logger, ctrInfo);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Cannot release container " + ctrInfo.getSniffer().getModuleType(), e);
            }
        }
    }

    protected void stopContainer(Logger logger, ContainerInfo info) {
        Inhabitant i;
        if (info.getDeployer() != null && (i = this.habitat.getInhabitantByType(info.getDeployer().getClass())) != null) {
            i.release();
        }
        if (info.getContainer() != null && (i = this.habitat.getInhabitantByType(info.getContainer().getClass())) != null) {
            i.release();
        }
        this.containerRegistry.removeContainer(info);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Container " + info.getContainer().getName() + " stopped");
        }
    }

    protected ApplicationInfo unload(String appName, DeploymentContext context, ActionReport report) {
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            return null;
        }
        info.unload(context, report);
        return info;
    }

    public void undeploy(String appName, DeploymentContext context, ActionReport report) {
        if (report.getExtraProperties() != null) {
            context.getProps().put("ActionReportProperties", report.getExtraProperties());
        }
        ApplicationInfo info = this.unload(appName, context, report);
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            for (ModuleInfo moduleInfo : info.getModuleInfos()) {
                try {
                    moduleInfo.getContainerInfo().getDeployer().clean(context);
                }
                catch (Exception e) {
                    report.failure(context.getLogger(), "Exception while cleaning application artifacts", (Throwable)e);
                    return;
                }
            }
        }
        this.appRegistry.remove(appName);
    }

    protected void registerAppInDomainXML(final ApplicationInfo applicationInfo, DeploymentContext context) throws TransactionFailure {
        final Properties moduleProps = context.getProps();
        ConfigSupport.apply((ConfigCode)new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                Applications apps = (Applications)params[0];
                Server servr = (Server)params[1];
                Application app = (Application)ConfigSupport.createChildOf((Object)params[0], Application.class);
                app.setName(moduleProps.getProperty("name"));
                app.setLocation(moduleProps.getProperty("location"));
                app.setObjectType(moduleProps.getProperty("object-type"));
                app.setEnabled(String.valueOf(true));
                if (moduleProps.getProperty("context-root") != null) {
                    app.setContextRoot(moduleProps.getProperty("context-root"));
                }
                if (moduleProps.getProperty("libraries") != null) {
                    app.setLibraries(moduleProps.getProperty("libraries"));
                }
                app.setDirectoryDeployed(moduleProps.getProperty("directory-deployed"));
                if (moduleProps.getProperty("description") != null) {
                    app.setDescription(moduleProps.getProperty("description"));
                }
                apps.getModules().add(app);
                for (ModuleInfo moduleInfo : applicationInfo.getModuleInfos()) {
                    Engine engine = (Engine)ConfigSupport.createChildOf((Object)app, Engine.class);
                    app.getEngine().add(engine);
                    engine.setSniffer(moduleInfo.getContainerInfo().getSniffer().getModuleType());
                }
                for (String string : moduleProps.keySet()) {
                    if (string.equals("name") || string.equals("location") || string.equals("enabled") || string.equals("context-root") || string.equals("libraries") || string.equals("object-type") || string.equals("virtual-servers") || string.equals("directory-deployed") || string.startsWith("appConfig")) continue;
                    Property prop = (Property)ConfigSupport.createChildOf((Object)app, Property.class);
                    app.getProperty().add(prop);
                    prop.setName(string);
                    prop.setValue(moduleProps.getProperty(string));
                }
                ApplicationRef appRef = (ApplicationRef)ConfigSupport.createChildOf((Object)params[1], ApplicationRef.class);
                appRef.setRef(moduleProps.getProperty("name"));
                if (moduleProps.getProperty("virtual-servers") != null) {
                    appRef.setVirtualServers(moduleProps.getProperty("virtual-servers"));
                } else {
                    HttpService httpService = (HttpService)ApplicationLifecycle.this.habitat.getComponent(HttpService.class);
                    StringBuilder sb = new StringBuilder();
                    for (VirtualServer s : httpService.getVirtualServer()) {
                        if (s.getId().equals("__asadmin")) continue;
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(s.getId());
                    }
                    appRef.setVirtualServers(sb.toString());
                }
                appRef.setEnabled(moduleProps.getProperty("enabled"));
                List list = (List)moduleProps.get("appConfig");
                if (list != null) {
                    for (ApplicationConfig ac : list) {
                        app.getApplicationConfigs().add(ac);
                    }
                }
                servr.getApplicationRef().add(appRef);
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.applications, this.server});
    }

    protected void unregisterAppFromDomainXML(final String appName) throws TransactionFailure {
        ConfigSupport.apply((ConfigCode)new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                Applications apps = (Applications)params[0];
                Server servr = (Server)params[1];
                for (ApplicationRef appRef : servr.getApplicationRef()) {
                    if (!appRef.getRef().equals(appName)) continue;
                    ((Server)params[1]).getApplicationRef().remove(appRef);
                    break;
                }
                for (Module module : apps.getModules()) {
                    if (!module.getName().equals(appName)) continue;
                    ((Applications)params[0]).getModules().remove(module);
                    break;
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.applications, this.server});
    }

    protected void setEnableAttributeInDomainXML(String appName, final boolean newEnabledValue) throws Exception {
        ApplicationRef applicationRef = null;
        for (ApplicationRef appRef : this.server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            applicationRef = appRef;
            if (Boolean.valueOf(appRef.getEnabled()) != newEnabledValue) break;
            return;
        }
        if (applicationRef == null) {
            throw new Exception("Application Ref not found for " + appName + " in configuration");
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ApplicationRef>(){

            public Object run(ApplicationRef param) throws PropertyVetoException, TransactionFailure {
                param.setEnabled(String.valueOf(newEnabledValue));
                return null;
            }
        }, applicationRef);
    }

    protected Properties populateDeployParamsFromDomainXML(Application app, ApplicationRef appRef) {
        if (app == null || appRef == null) {
            return new Properties();
        }
        Properties deploymentParams = new Properties();
        deploymentParams.setProperty("name", app.getName());
        deploymentParams.setProperty("location", app.getLocation());
        deploymentParams.setProperty("enabled", app.getEnabled());
        if (app.getContextRoot() != null) {
            deploymentParams.setProperty("contextroot", app.getContextRoot());
        }
        if (app.getLibraries() != null) {
            deploymentParams.setProperty("libraries", app.getLibraries());
        }
        deploymentParams.setProperty("directorydeployed", app.getDirectoryDeployed());
        if (appRef.getVirtualServers() != null) {
            deploymentParams.setProperty("virtualservers", appRef.getVirtualServers());
        }
        if (app.getApplicationConfigs() != null) {
            this.addApplicationConfigToProps(deploymentParams, app.getApplicationConfigs());
        }
        return deploymentParams;
    }

    protected void addApplicationConfigToProps(Properties props, List<ApplicationConfig> appConfigList) {
        props.put("appConfig", appConfigList);
    }

    protected Properties populateDeployPropsFromDomainXML(Application app) {
        if (app == null) {
            return new Properties();
        }
        Properties deploymentProps = new Properties();
        for (Property prop : app.getProperty()) {
            deploymentProps.put(prop.getName(), prop.getValue());
        }
        deploymentProps.setProperty("object-type", app.getObjectType());
        return deploymentProps;
    }

    protected boolean isRegistered(String appName) {
        return ConfigBeansUtilities.getModule((String)appName) != null;
    }

    public void deleteContainerMetaInfo(DeploymentContext context) {
        File generatedXmlRoot = context.getScratchDir("xml");
        FileUtils.whack((File)generatedXmlRoot);
        File generatedEjbRoot = context.getScratchDir("ejb");
        FileUtils.whack((File)generatedEjbRoot);
        File generatedJspRoot = context.getScratchDir("jsp");
        FileUtils.whack((File)generatedJspRoot);
    }
}

