/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ContainerMapper;
import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.http.HtmlHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpHandler {
    private static final char ROOT = '/';
    protected GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    protected ContainerMapper.ContextRootInfo fallbackContextRootInfo;
    protected volatile List<ProtocolFilter> defaultProtocolFilters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initializeHttpRequestProcessing(Context context, ByteBuffer byteBuffer) {
        try {
            if (GrizzlyEmbeddedHttp.logger().isLoggable(Level.FINE)) {
                GrizzlyEmbeddedHttp.logger().fine(AbstractHttpHandler.dump(byteBuffer));
            }
            SelectionKey selectionKey = context.getSelectionKey();
            boolean wasMap = true;
            try {
                wasMap = this.grizzlyEmbeddedHttp.getContainerMapper().map(selectionKey, byteBuffer, (GlassfishProtocolChain)context.getProtocolChain(), null, this.fallbackContextRootInfo);
            }
            catch (Exception ex) {
                GrizzlyEmbeddedHttp.logger().log(Level.WARNING, "Mapper exception", ex);
                wasMap = false;
            }
            if (!wasMap) {
                try {
                    ByteBuffer bb = HtmlHelper.getErrorPage("Not Found", "HTTP/1.1 404 Not Found\n", "Glassfish/v3");
                    OutputWriter.flushChannel(selectionKey.channel(), bb);
                }
                catch (IOException ex) {
                    GrizzlyEmbeddedHttp.logger().log(Level.FINE, "Send Error failed", ex);
                }
                finally {
                    byteBuffer.clear();
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            GrizzlyEmbeddedHttp.logger().log(Level.WARNING, "Unexpected exception happened, when parsing context-root", e);
            return false;
        }
    }

    public List<ProtocolFilter> getDefaultProtocolFilters() {
        return this.defaultProtocolFilters;
    }

    public void setDefaultProtocolFilters(List<ProtocolFilter> defaultProtocolFilters) {
        this.defaultProtocolFilters = defaultProtocolFilters;
    }

    public List<ProtocolFilter> getFallbackProtocolFilters() {
        return this.fallbackContextRootInfo.getProtocolFilters();
    }

    public void setFallbackProtocolFilters(List<ProtocolFilter> fallbackProtocolFilters) {
        this.fallbackContextRootInfo.setProtocolFilters(fallbackProtocolFilters);
    }

    public void setFallbackAdapter(Adapter adapter) {
        this.fallbackContextRootInfo.setAdapter(adapter);
    }

    public Adapter getFallbackAdapter() {
        return this.fallbackContextRootInfo.getAdapter();
    }

    protected static final String dump(ByteBuffer byteBuffer) {
        ByteBuffer dd = byteBuffer.duplicate();
        dd.flip();
        int length = dd.limit();
        byte[] dump = new byte[length];
        dd.get(dump, 0, length);
        return new String(dump);
    }

    protected static final String notSlashed(String s) {
        if (s != null && (s.length() == 0 || s.charAt(0) == '/')) {
            return s.substring(1);
        }
        return s;
    }
}

