/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.http;

import com.sun.grizzly.util.buf.B2CConverter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpRequestURIDecoder {
    protected static final boolean ALLOW_BACKSLASH = false;
    private static final boolean COLLAPSE_ADJACENT_SLASHES = Boolean.valueOf(System.getProperty("com.sun.enterprise.web.collapseAdjacentSlashes", "true"));
    private static Logger log = Logger.getLogger(HttpRequestURIDecoder.class.getName());

    public static final void decode(MessageBytes decodedURI, UDecoder urlDecoder) throws Exception {
        HttpRequestURIDecoder.decode(decodedURI, urlDecoder, null, null);
    }

    public static final void decode(MessageBytes decodedURI, UDecoder urlDecoder, String encoding, B2CConverter b2cConverter) throws Exception {
        urlDecoder.convert(decodedURI, false);
        if (!HttpRequestURIDecoder.normalize(decodedURI)) {
            throw new IOException("Invalid URI character encoding");
        }
        if (encoding == null) {
            encoding = "utf-8";
        }
        HttpRequestURIDecoder.convertURI(decodedURI, encoding, b2cConverter);
        if (!HttpRequestURIDecoder.checkNormalize(decodedURI)) {
            throw new IOException("Invalid URI character encoding");
        }
    }

    private static final void convertURI(MessageBytes uri, String encoding, B2CConverter b2cConverter) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        if (encoding != null) {
            try {
                if (b2cConverter == null) {
                    b2cConverter = new B2CConverter(encoding);
                }
            }
            catch (IOException e) {
                log.severe("Invalid URI encoding; using HTTP default");
            }
            if (b2cConverter != null) {
                try {
                    b2cConverter.convert(bc, cc);
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    log.severe("Invalid URI character encoding; trying ascii");
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, bc.getLength());
    }

    public static boolean normalize(MessageBytes uriMB) {
        int type = uriMB.getType();
        if (type == 3) {
            return HttpRequestURIDecoder.normalizeChars(uriMB);
        }
        return HttpRequestURIDecoder.normalizeBytes(uriMB);
    }

    public static boolean checkNormalize(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        int pos = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                return false;
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (c[pos] != '/' || c[pos + 1] != '/') continue;
            return false;
        }
        if (end - start >= 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            return false;
        }
        return uriCC.indexOf("/./", 0, 3, 0) < 0;
    }

    private static boolean normalizeBytes(MessageBytes uriMB) {
        int end;
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        if (start == (end = uriBC.getEnd())) {
            return false;
        }
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                return false;
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (b[pos] != 47) continue;
                while (pos + 1 < end && b[pos + 1] == 47) {
                    HttpRequestURIDecoder.copyBytes(b, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            HttpRequestURIDecoder.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            HttpRequestURIDecoder.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    private static boolean normalizeChars(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        if (end - start == 1 && c[start] == '*') {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                return false;
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        if (c[start] != '/') {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (c[pos] != '/') continue;
                while (pos + 1 < end && c[pos + 1] == '/') {
                    HttpRequestURIDecoder.copyChars(c, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            c[end] = 47;
            ++end;
        }
        uriCC.setEnd(end);
        index = 0;
        while ((index = uriCC.indexOf("/./", 0, 3, index)) >= 0) {
            HttpRequestURIDecoder.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            uriCC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriCC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            HttpRequestURIDecoder.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriCC.setEnd(end);
            index = index2;
        }
        uriCC.setChars(c, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        System.arraycopy(b, src, b, dest, len);
    }

    private static void copyChars(char[] c, int dest, int src, int len) {
        System.arraycopy(c, src, c, dest, len);
    }

    protected void log(String message) {
        log.info(message);
    }

    protected void log(String message, Throwable throwable) {
        log.log(Level.SEVERE, message, throwable);
    }

    protected void convertMB(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, bc.getLength());
    }
}

