/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationInfo {
    private static final Logger logger = LogDomains.getLogger(ApplicationInfo.class, (String)"javax.enterprise.system.core");
    private final ModuleInfo[] modules;
    private final String name;
    private final ReadableArchive source;

    public ApplicationInfo(ReadableArchive source, String name, ModuleInfo ... modules) {
        this.name = name;
        this.source = source;
        this.modules = modules;
    }

    public String getName() {
        return this.name;
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public ModuleInfo[] getModuleInfos() {
        return this.modules;
    }

    public Iterable<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (ModuleInfo module : this.modules) {
            sniffers.add(module.getContainerInfo().getSniffer());
        }
        return sniffers;
    }

    public <T extends Container> ModuleInfo getModuleInfo(Class<T> type) {
        for (ModuleInfo info : this.modules) {
            Container container = null;
            try {
                container = (Container)type.cast(info.getContainerInfo().getContainer());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (container == null) continue;
            return info;
        }
        return null;
    }

    public void start(DeploymentContext context, ActionReport report, ProgressTracker tracker) throws Exception {
        for (ModuleInfo module : this.getModuleInfos()) {
            try {
                if (module.start((ApplicationContext)context, tracker)) continue;
                report.failure(logger, "Module not started " + module.getApplicationContainer().toString());
                throw new Exception("Module not started " + module.getApplicationContainer().toString());
            }
            catch (Exception e) {
                report.failure(logger, "Exception while invoking " + module.getApplicationContainer().getClass() + " start method", (Throwable)e);
                throw e;
            }
        }
    }

    private void unload(ModuleInfo[] modules, ApplicationInfo info, DeploymentContext context, ActionReport report) {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        for (ModuleInfo module : modules) {
            if (module.getApplicationContainer() != null && module.getApplicationContainer().getClassLoader() != null) {
                classLoaders.add(module.getApplicationContainer().getClassLoader());
            }
            try {
                module.unload(info, context, report);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to unload from container type : " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        for (ClassLoader cloader : classLoaders) {
            try {
                ((PreDestroy)PreDestroy.class.cast(cloader)).preDestroy();
            }
            catch (Exception e) {}
        }
    }

    public void stop(ApplicationContext context, Logger logger) {
        for (ModuleInfo module : this.getModuleInfos()) {
            try {
                module.stop(context, logger);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot stop module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
    }

    public void unload(DeploymentContext context, ActionReport report) {
        this.stop((ApplicationContext)context, logger);
        this.unload(this.getModuleInfos(), this, context, report);
    }

    public boolean suspend(Logger logger) {
        boolean isSuccess = true;
        for (ModuleInfo module : this.modules) {
            try {
                module.getApplicationContainer().suspend();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error suspending module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public boolean resume(Logger logger) {
        boolean isSuccess = true;
        for (ModuleInfo module : this.modules) {
            try {
                module.getApplicationContainer().resume();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error resuming module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }
}

