/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.grizzly.tcp.Adapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ContainerInfo;
import org.glassfish.internal.data.ProgressTracker;

public class ModuleInfo {
    private final ContainerInfo ctrInfo;
    final RequestDispatcher requestDispatcher;
    private ApplicationContainer appCtr;

    public ModuleInfo(ContainerInfo container, RequestDispatcher requestDispatcher, ApplicationContainer appCtr) {
        this.ctrInfo = container;
        this.requestDispatcher = requestDispatcher;
        this.appCtr = appCtr;
    }

    public ContainerInfo getContainerInfo() {
        return this.ctrInfo;
    }

    public void setApplicationContainer(ApplicationContainer appCtr) {
        this.appCtr = appCtr;
    }

    public ApplicationContainer getApplicationContainer() {
        return this.appCtr;
    }

    public boolean start(ApplicationContext context, ProgressTracker tracker) throws Exception {
        if (!this.appCtr.start(context)) {
            return false;
        }
        tracker.add("started", ModuleInfo.class, this);
        try {
            org.glassfish.api.container.Adapter appAdapter = (org.glassfish.api.container.Adapter)org.glassfish.api.container.Adapter.class.cast(this.appCtr);
            this.requestDispatcher.registerEndpoint(appAdapter.getContextRoot(), (Adapter)appAdapter, this.appCtr);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return true;
    }

    public boolean unload(ApplicationInfo info, DeploymentContext context, ActionReport report) {
        Deployer deployer = this.ctrInfo.getDeployer();
        try {
            deployer.unload(this.appCtr, context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while shutting down application container", (Throwable)e);
            return false;
        }
        if (info != null) {
            this.ctrInfo.remove(info);
        }
        return true;
    }

    public boolean stop(ApplicationContext context, Logger logger) {
        try {
            org.glassfish.api.container.Adapter appAdapter = (org.glassfish.api.container.Adapter)org.glassfish.api.container.Adapter.class.cast(this.appCtr);
            this.requestDispatcher.unregisterEndpoint(appAdapter.getContextRoot(), this.appCtr);
        }
        catch (EndpointRegistrationException e) {
            logger.log(Level.WARNING, "Exception during unloading module '" + this + "'", e);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.appCtr.stop(context);
    }
}

