/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable")
@I18n(value="disable.command")
@Scoped(value=PerLookup.class)
public class DisableCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableCommand.class);
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Deployment deployment;
    @Inject(name="default-instance-name")
    protected Server server;
    @Param(primary=true)
    String component = null;
    @Param(optional=true)
    String target = "server";

    public void execute(AdminCommandContext context) {
        block5: {
            ActionReport report = context.getActionReport();
            Logger logger = context.getLogger();
            ApplicationInfo appInfo = this.deployment.get(this.component);
            if (appInfo == null) {
                report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.component}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!Boolean.valueOf(ConfigBeansUtilities.getEnabled((String)this.target, (String)this.component)).booleanValue()) {
                logger.fine("The application is already disabled");
                return;
            }
            try {
                DeploymentContextImpl deploymentContext = new DeploymentContextImpl(logger, null, context.getCommandParameters(), (ServerEnvironment)this.env);
                appInfo.unload((ExtendedDeploymentContext)deploymentContext, report);
                if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) break block5;
                for (ApplicationRef ref : this.server.getApplicationRef()) {
                    if (!ref.getRef().equals(this.component)) continue;
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ApplicationRef>(){

                        public Object run(ApplicationRef param) throws PropertyVetoException, TransactionFailure {
                            param.setEnabled(String.valueOf(false));
                            return null;
                        }
                    }, (ConfigBeanProxy)ref);
                    break;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error during disabling: ", e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(e.getMessage());
            }
        }
    }
}

