/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="undeploy")
@I18n(value="undeploy.command")
@Scoped(value=PerLookup.class)
public class UndeployCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UndeployCommand.class);
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;
    @Param(primary=true, name="name")
    String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false")
    Boolean keepreposdir;
    @Param(optional=true)
    Properties properties = null;

    public void execute(AdminCommandContext context) {
        Properties parameters = context.getCommandParameters();
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        this.name = new File(this.name).getName();
        parameters.setProperty("name", this.name);
        ApplicationInfo info = this.deployment.get(this.name);
        Named module = ConfigBeansUtilities.getModule((String)this.name);
        Application application = null;
        if (module instanceof Application) {
            application = (Application)module;
        }
        if (module == null) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ReadableArchive source = null;
        if (info == null) {
            if (application != null) {
                File location = new File(application.getLocation());
                if (location.exists()) {
                    try {
                        source = this.archiveFactory.openArchive(location);
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, e.getMessage(), e);
                    }
                } else {
                    logger.warning("Originally deployed application at " + location + " not found");
                }
            }
        } else {
            source = info.getSource();
        }
        DeploymentContextImpl deploymentContext = new DeploymentContextImpl(logger, source, parameters, (ServerEnvironment)this.env);
        if (this.properties != null) {
            deploymentContext.setProps(this.properties);
        }
        if (info != null) {
            this.deployment.undeploy(this.name, (ExtendedDeploymentContext)deploymentContext, report);
        }
        boolean isDirectoryDeployed = false;
        if (application != null) {
            isDirectoryDeployed = Boolean.valueOf(application.getDirectoryDeployed());
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            try {
                this.deployment.unregisterAppFromDomainXML(this.name);
            }
            catch (TransactionFailure e) {
                logger.warning("Module " + this.name + " not found in configuration");
            }
            deploymentContext.clean();
            if (source != null && !this.keepreposdir.booleanValue() && !isDirectoryDeployed && source.exists()) {
                FileUtils.whack((File)new File(info.getSource().getURI()));
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }
}

