/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.arp;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.TaskEvent;
import com.sun.grizzly.http.TaskListener;
import com.sun.grizzly.http.algorithms.NoParsingAlgorithm;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.SelectionKeyAttachment;
import com.sun.grizzly.util.StreamAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncProtocolFilter
implements ProtocolFilter,
TaskListener {
    private Class algorithmClass;
    private int port;
    private static final Logger logger = SelectorThread.logger();
    private ConcurrentLinkedQueue<InputReader> byteBufferStreams = new ConcurrentLinkedQueue();
    protected int bbSize = 4096;

    public AsyncProtocolFilter(Class algorithmClass, int port) {
        this.algorithmClass = algorithmClass;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        HttpWorkerThread workerThread = (HttpWorkerThread)((Object)Thread.currentThread());
        this.setSelectionKeyTimeout(ctx.getSelectionKey(), Long.MAX_VALUE);
        StreamAlgorithm streamAlgorithm = workerThread.getStreamAlgorithm();
        if (streamAlgorithm == null) {
            try {
                streamAlgorithm = (StreamAlgorithm)this.algorithmClass.newInstance();
            }
            catch (InstantiationException ex) {
                logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClass.getName());
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClass.getName());
            }
            finally {
                if (streamAlgorithm == null) {
                    streamAlgorithm = new NoParsingAlgorithm();
                }
            }
            streamAlgorithm.setPort(this.port);
            workerThread.setStreamAlgorithm(streamAlgorithm);
        }
        SelectorThread selectorThread = SelectorThread.getSelector(this.port);
        this.bbSize = SelectorThread.getSelector(this.port).getMaxHttpHeaderSize();
        InputReader inputStream = this.byteBufferStreams.poll();
        if (inputStream == null) {
            inputStream = this.createByteBufferInputStream();
        }
        this.configureByteBufferInputStream(inputStream, ctx, workerThread);
        SelectionKey key = ctx.getSelectionKey();
        SocketChannel socketChannel = (SocketChannel)key.channel();
        streamAlgorithm.setChannel((Object)socketChannel);
        ByteBuffer nextBuffer = inputStream.getByteBuffer();
        nextBuffer.clear();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        workerThread.setByteBuffer(nextBuffer);
        inputStream.setByteBuffer(byteBuffer);
        byteBuffer = streamAlgorithm.preParse(byteBuffer);
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
        if (streamAlgorithm.parse(byteBuffer)) {
            ProcessorTask processor = selectorThread.getProcessorTask();
            this.configureProcessorTask(processor, ctx, workerThread, streamAlgorithm.getHandler(), (InputStream)inputStream);
            try {
                selectorThread.getAsyncHandler().handle(processor);
            }
            catch (Throwable ex) {
                logger.log(Level.INFO, "Processor exception", ex);
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                return false;
            }
        }
        return true;
    }

    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2 || event.getStatus() == 1) {
            ProcessorTask processor = (ProcessorTask)event.attachement();
            if (processor.getSelectionKey() == null) {
                logger.log(Level.WARNING, "AsyncProtocolFilter invalid state.");
                return;
            }
            InputReader is = (InputReader)processor.getInputStream();
            is.getByteBuffer().clear();
            this.byteBufferStreams.offer(is);
            SelectorThread selectorThread = processor.getSelectorThread();
            if (processor.isKeepAlive() && !processor.isError()) {
                this.setSelectionKeyTimeout(processor.getSelectionKey(), null);
                selectorThread.registerKey(processor.getSelectionKey());
            } else {
                selectorThread.cancelKey(processor.getSelectionKey());
            }
            processor.recycle();
            selectorThread.returnTask(processor);
        }
    }

    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }

    protected void configureProcessorTask(ProcessorTask processorTask, Context context, HttpWorkerThread workerThread, Interceptor handler, InputStream inputStream) {
        SelectionKey key = context.getSelectionKey();
        processorTask.setSelectionKey(key);
        processorTask.setSocket(((SocketChannel)key.channel()).socket());
        processorTask.addTaskListener(this);
        processorTask.setInputStream(inputStream);
        processorTask.setHandler(handler);
    }

    protected void configureByteBufferInputStream(InputReader inputStream, Context context, HttpWorkerThread workerThread) {
        inputStream.setSelectionKey(context.getSelectionKey());
        inputStream.setSecure(false);
    }

    protected boolean isSecure() {
        return false;
    }

    protected InputReader createByteBufferInputStream() {
        return new InputReader(ByteBufferFactory.allocateView((int)this.bbSize, (boolean)false));
    }

    private void setSelectionKeyTimeout(SelectionKey selectionKey, Long timeout) {
        Object attachment = selectionKey.attachment();
        if (attachment == null) {
            selectionKey.attach(timeout);
        } else if (attachment instanceof SelectionKeyAttachment) {
            ((SelectionKeyAttachment)attachment).setTimeout(timeout);
        }
    }
}

