/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentContextImpl
implements ExtendedDeploymentContext {
    final ReadableArchive source;
    final Properties parameters;
    final Logger logger;
    final ServerEnvironment env;
    ClassLoader cloader;
    Properties props;
    Map<String, Object> modulesMetaData = new HashMap<String, Object>();
    List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    ExtendedDeploymentContext.Phase phase = ExtendedDeploymentContext.Phase.UNKNOWN;
    boolean finalClassLoaderAccessedDuringPrepare = false;
    boolean tempClassLoaderInvalidated = false;
    ClassLoader sharableTemp = null;

    public DeploymentContextImpl(Logger logger, ReadableArchive source, Properties params, ServerEnvironment env) {
        this.source = source;
        this.logger = logger;
        this.parameters = params;
        this.env = env;
    }

    public void setPhase(ExtendedDeploymentContext.Phase newPhase) {
        this.phase = newPhase;
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public Properties getCommandParameters() {
        return this.parameters;
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ClassLoader getFinalClassLoader() {
        this.tempClassLoaderInvalidated = true;
        if (this.phase == ExtendedDeploymentContext.Phase.PREPARE) {
            if (this.finalClassLoaderAccessedDuringPrepare) {
                Boolean force = Boolean.parseBoolean(this.getCommandParameters().getProperty("force"));
                if (!force.booleanValue()) {
                    throw new RuntimeException("More than one deployer is trying to access the final class loader during prepare phase, use --force=true to force deployment");
                }
            } else {
                this.finalClassLoaderAccessedDuringPrepare = true;
            }
        }
        return this.cloader;
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader(true);
    }

    public void createClassLoaders(ClassLoaderHierarchy clh, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
        if (this.cloader != null && this.sharableTemp != null) {
            return;
        }
        String appName = this.getCommandParameters().getProperty("name");
        ClassLoader applibCL = clh.getAppLibClassLoader(appName, this.getAppLibs());
        ClassLoader parentCL = clh.createApplicationParentCL(applibCL, (DeploymentContext)this);
        this.sharableTemp = handler.getClassLoader(parentCL, (DeploymentContext)this);
        this.cloader = handler.getClassLoader(parentCL, (DeploymentContext)this);
    }

    public void invalidateTempClassLoader() {
        this.tempClassLoaderInvalidated = true;
    }

    public synchronized ClassLoader getClassLoader(boolean sharable) {
        if (this.phase == ExtendedDeploymentContext.Phase.PREPARE) {
            if (sharable) {
                return this.sharableTemp;
            }
            InstrumentableClassLoader cl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(this.sharableTemp);
            return cl.copy();
        }
        if (this.tempClassLoaderInvalidated) {
            if (this.sharableTemp != null) {
                try {
                    ((PreDestroy)PreDestroy.class.cast(this.sharableTemp)).preDestroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sharableTemp = null;
            }
            return this.cloader;
        }
        return this.sharableTemp;
    }

    public File getScratchDir(String subDirName) {
        String appName = this.parameters.getProperty("name");
        File rootScratchDir = this.env.getApplicationStubPath();
        if (subDirName != null) {
            rootScratchDir = new File(rootScratchDir, subDirName);
        }
        return new File(rootScratchDir, appName);
    }

    public File getSourceDir() {
        return new File(this.getSource().getURI());
    }

    public void addModuleMetaData(Object metaData) {
        if (metaData != null) {
            this.modulesMetaData.put(metaData.getClass().getName(), metaData);
        }
    }

    public <T> T getModuleMetaData(Class<T> metadataType) {
        Object moduleMetaData = this.modulesMetaData.get(metadataType.getName());
        if (moduleMetaData != null) {
            return metadataType.cast(moduleMetaData);
        }
        for (Object metadata : this.modulesMetaData.values()) {
            try {
                return metadataType.cast(metadata);
            }
            catch (ClassCastException e) {
            }
        }
        return null;
    }

    public Collection<Object> getModuleMetadata() {
        ArrayList<Object> copy = new ArrayList<Object>();
        copy.addAll(this.modulesMetaData.values());
        return copy;
    }

    public Properties getProps() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    public List<ClassFileTransformer> getTransformers() {
        return this.transformers;
    }

    private List<URI> getAppLibs() throws URISyntaxException {
        ArrayList<URI> libURIs = new ArrayList<URI>();
        String libraries = this.getCommandParameters().getProperty("libraries");
        if (libraries != null) {
            URL[] urls;
            for (URL url : urls = this.convertToURL(libraries)) {
                libURIs.add(url.toURI());
            }
        }
        return libURIs;
    }

    private URL[] convertToURL(String librariesStr) {
        if (librariesStr == null) {
            return null;
        }
        String[] librariesStrArray = librariesStr.split(",");
        if (librariesStrArray == null) {
            return null;
        }
        URL[] urls = new URL[librariesStrArray.length];
        String appLibsDir = this.env.getLibPath() + File.separator + "applibs";
        int i = 0;
        for (String libraryStr : librariesStrArray) {
            try {
                File f = new File(libraryStr);
                if (!f.isAbsolute()) {
                    f = new File(appLibsDir, libraryStr);
                }
                URL url = f.toURI().toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException malEx) {
                this.logger.log(Level.WARNING, "Cannot convert classpath to URL", libraryStr);
                this.logger.log(Level.WARNING, malEx.getMessage(), malEx);
            }
        }
        return urls;
    }

    public void clean() {
        File generatedXmlRoot = this.getScratchDir("xml");
        FileUtils.whack((File)generatedXmlRoot);
        File generatedEjbRoot = this.getScratchDir("ejb");
        FileUtils.whack((File)generatedEjbRoot);
        File generatedJspRoot = this.getScratchDir("jsp");
        FileUtils.whack((File)generatedJspRoot);
    }
}

