/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.deployment.archive.ReadableArchive;

public class DeploymentUtils {
    private static final String WEB_XML = "WEB-INF/web.xml";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String RA_XML = "META-INF/ra.xml";
    private static final String APPLICATION_XML = "META-INF/application.xml";

    public static boolean isWebArchive(ReadableArchive archive) {
        try {
            if (archive.exists(WEB_XML) || archive.exists(WEB_INF_CLASSES) || archive.exists(WEB_INF_LIB)) {
                return true;
            }
            Enumeration entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(JSP_SUFFIX)) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isRAR(ReadableArchive archive) {
        boolean isRar = false;
        try {
            isRar = archive.exists(RA_XML);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isRar;
    }

    public static boolean isEAR(ReadableArchive archive) {
        boolean isEar = false;
        try {
            isEar = archive.exists(APPLICATION_XML);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isEar;
    }

    public static String getRelativeEmbeddedModulePath(String appRootPath, String moduleUri) {
        if (FileUtils.safeIsDirectory((File)new File(appRootPath, moduleUri = FileUtils.makeLegalNoBlankFileName((String)moduleUri)))) {
            return moduleUri;
        }
        return FileUtils.makeFriendlyFilename((String)moduleUri);
    }

    public static String getEmbeddedModulePath(String appRootPath, String moduleUri) {
        return appRootPath + File.separator + DeploymentUtils.getRelativeEmbeddedModulePath(appRootPath, moduleUri);
    }
}

