/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.universal.BASE64Decoder;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.admin.CommandRunner;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.enterprise.v3.admin.listener.GenericJavaConfigListener;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.hk2.component.ConstructorWomb;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.internal.api.AdminAuthenticator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AdminAdapter
extends GrizzlyAdapter
implements Adapter,
PostConstruct,
EventListener {
    public static final String VS_NAME = "__asadmin";
    public static final String PREFIX_URI = "/__asadmin";
    public static final Logger logger = LogDomains.getLogger(ServerEnvironmentImpl.class, (String)"javax.enterprise.system.tools.admin");
    public static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(AdminAdapter.class);
    public static final String GFV3 = "gfv3";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final BASE64Decoder decoder = new BASE64Decoder();
    private static final String BASIC = "Basic ";
    private static final String UPLOAD_DIR_PREFIX = "upl-";
    private static final String QUERY_STRING_SEPARATOR = "&";
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    CommandRunner commandRunner;
    @Inject
    ServerEnvironmentImpl env;
    @Inject(optional=true)
    AdminAuthenticator authenticator = null;
    @Inject
    Events events;
    @Inject(name="server-config")
    Config config;
    private AdminEndpointDecider epd = null;
    @Inject
    ServerContext sc;
    @Inject
    Habitat habitat;
    private boolean isRegistered = false;
    CountDownLatch latch = new CountDownLatch(1);

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.epd = new AdminEndpointDecider(this.config, logger);
        this.registerJavaConfigListener();
        this.setHandleStaticResources(true);
        this.setRootFolder((String)this.env.getProps().get("com.sun.aas.instanceRoot") + "/asadmindocroot/");
    }

    @Override
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        LogHelper.getDefaultLogger().finer("Admin adapter !");
        LogHelper.getDefaultLogger().finer("Received something on " + req.getRequestURI());
        LogHelper.getDefaultLogger().finer("QueryString = " + req.getQueryString());
        String requestURI = req.getRequestURI();
        ActionReport report = this.getClientActionReport(requestURI, req);
        if (requestURI.indexOf(46) != -1) {
            requestURI = requestURI.substring(0, requestURI.indexOf(46));
        }
        try {
            if (!this.latch.await(20L, TimeUnit.SECONDS)) {
                report = this.getClientActionReport(req.getRequestURI(), req);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("V3 cannot process this command at this time, please wait");
            } else {
                if (!this.authenticate(req, report, res)) {
                    return;
                }
                report = this.doCommand(requestURI, req, report);
            }
        }
        catch (InterruptedException e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("V3 cannot process this command at this time, please wait");
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Error authenticating");
        }
        try {
            res.setStatus(200);
            res.setContentType(report.getContentType());
            report.writeReport((OutputStream)res.getOutputStream());
            res.getOutputStream().flush();
            res.finishResponse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean authenticate(Request req, ServerEnvironmentImpl serverEnviron) throws Exception {
        File realmFile = new File((String)serverEnviron.getProps().get("com.sun.aas.instanceRoot") + "/config/admin-keyfile");
        if (this.authenticator != null && realmFile.exists()) {
            return this.authenticator.authenticate(req, realmFile);
        }
        return true;
    }

    private boolean authenticate(GrizzlyRequest req, ActionReport report, GrizzlyResponse res) throws Exception {
        boolean authenticated = this.authenticate(req.getRequest(), this.env);
        if (!authenticated) {
            String msg = adminStrings.getLocalString("adapter.auth.userpassword", "Invalid user name or password");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            report.setActionDescription("Authentication error");
            res.setStatus(401);
            res.setHeader("WWW-Authenticate", "BASIC");
            res.setContentType(report.getContentType());
            report.writeReport((OutputStream)res.getOutputStream());
            res.getOutputStream().flush();
            res.finishResponse();
        }
        return authenticated;
    }

    private ActionReport getClientActionReport(String requestURI, GrizzlyRequest req) {
        ActionReport report;
        if (requestURI.indexOf(46) != -1) {
            String qualifier = requestURI.substring(requestURI.indexOf(46) + 1);
            report = (ActionReport)this.habitat.getComponent(ActionReport.class, qualifier);
        } else {
            String userAgent = req.getHeader("User-Agent");
            report = (ActionReport)this.habitat.getComponent(ActionReport.class, userAgent.substring(userAgent.indexOf(47) + 1));
            if (report == null) {
                String accept = req.getHeader("Accept");
                StringTokenizer st = new StringTokenizer(accept, ",");
                while (report == null && st.hasMoreElements()) {
                    String scheme = st.nextToken();
                    report = (ActionReport)this.habitat.getComponent(ActionReport.class, scheme.substring(scheme.indexOf(47) + 1));
                }
            }
        }
        if (report == null) {
            report = (ActionReport)this.habitat.getComponent(ActionReport.class);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionReport doCommand(String requestURI, GrizzlyRequest req, ActionReport report) {
        if (!requestURI.startsWith(PREFIX_URI)) {
            String msg = adminStrings.getLocalString("adapter.panic", "Wrong request landed in AdminAdapter {0}", new Object[]{requestURI});
            report.setMessage(msg);
            LogHelper.getDefaultLogger().info(msg);
            return report;
        }
        String command = "";
        if (requestURI.length() > PREFIX_URI.length() + 1) {
            command = requestURI.substring(PREFIX_URI.length() + 1);
        }
        Properties parameters = this.extractParameters(req.getQueryString());
        UploadedFilesInfo uploadedFilesInfo = null;
        try {
            if (req.getMethod().equalsIgnoreCase(GET)) {
                logger.fine("***** AdminAdapter GET  *****");
                report = this.commandRunner.doCommand(command, parameters, report);
            } else if (req.getMethod().equalsIgnoreCase(POST)) {
                logger.fine("***** AdminAdapter POST *****");
                uploadedFilesInfo = new UploadedFilesInfo(req.getInputStream(), report);
                report = this.commandRunner.doCommand(command, parameters, report, uploadedFilesInfo.getFiles());
            }
        }
        catch (Throwable t) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(t);
            report.setMessage(t.getLocalizedMessage());
            report.setActionDescription("Last-chance AdminAdapter exception handler");
        }
        finally {
            if (uploadedFilesInfo != null) {
                uploadedFilesInfo.cleanup();
            }
        }
        return report;
    }

    @Override
    public void afterService(GrizzlyRequest req, GrizzlyResponse res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    public String getContextRoot() {
        return this.epd.getAsadminContextRoot();
    }

    Properties extractParameters(String requestString) {
        Properties parameters = new Properties();
        StringTokenizer stoken = new StringTokenizer(requestString == null ? "" : requestString, QUERY_STRING_SEPARATOR);
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            if (token.indexOf("=") == -1) continue;
            String paramName = null;
            String value = null;
            paramName = token.substring(0, token.indexOf("="));
            value = token.substring(token.indexOf("=") + 1);
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.WARNING, adminStrings.getLocalString("adapter.param.decode", "Cannot decode parameter {0} = {1}"));
            }
            parameters.setProperty(paramName, value);
        }
        if (logger.isLoggable(Level.FINER)) {
            for (Object key : parameters.keySet()) {
                logger.finer("Key " + key + " = " + parameters.getProperty((String)key));
            }
        }
        return parameters;
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.latch.countDown();
            logger.fine("Ready to receive administrative commands");
        }
    }

    public int getListenPort() {
        return this.epd.getListenPort();
    }

    public List<String> getVirtualServers() {
        return this.epd.getAsadminHosts();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    private void registerJavaConfigListener() {
        Habitat habitat = this.sc.getDefaultHabitat();
        ConstructorWomb womb = new ConstructorWomb(GenericJavaConfigListener.class, habitat, null);
        ConfigListener jcl = (ConfigListener)womb.get(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UploadedFilesInfo {
        private File tempFolder = null;
        private ArrayList<File> uploadedFiles;

        UploadedFilesInfo(InputStream is, ActionReport report) throws IOException {
            this.uploadedFiles = this.extractUploadedFiles(is, report);
        }

        private ArrayList<File> getFiles() {
            return this.uploadedFiles;
        }

        private void cleanup() {
            if (this.tempFolder != null) {
                FileUtils.whack((File)this.tempFolder);
                this.tempFolder = null;
            }
        }

        private ArrayList<File> extractUploadedFiles(InputStream is, ActionReport report) throws IOException {
            String localTmpDir = System.getProperty("java.io.tmpdir");
            File gfv3Folder = new File(localTmpDir, AdminAdapter.GFV3);
            if (!gfv3Folder.exists()) {
                gfv3Folder.mkdirs();
            }
            ArrayList<File> uploadedFiles = new ArrayList<File>();
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
            ZipEntry entry = null;
            OutputStream os = null;
            try {
                this.tempFolder = this.createTempFolder(gfv3Folder);
                StringBuilder uploadedEntryNames = new StringBuilder();
                while ((entry = zis.getNextEntry()) != null) {
                    int bytesRead;
                    String entryName = entry.getName();
                    File uploadFile = new File(this.tempFolder, entryName);
                    if (uploadFile.exists() && !uploadFile.delete()) {
                        logger.warning(adminStrings.getLocalString("adapter.command.overwrite", "Overwriting previously-uploaded file because the attempt to delete it failed: {0}", new Object[]{uploadFile.getAbsolutePath()}));
                    }
                    os = new BufferedOutputStream(new FileOutputStream(uploadFile));
                    byte[] buffer = new byte[65536];
                    while ((bytesRead = zis.read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                    os.close();
                    uploadedFiles.add(uploadFile);
                    uploadedEntryNames.append(entryName).append(" ");
                    logger.fine("Extracted uploaded entry " + entryName + " to " + uploadFile.getAbsolutePath());
                }
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
            catch (Exception e) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Error extracting uploaded file " + (entry == null ? "" : entry.getName()));
                report.setFailureCause((Throwable)e);
                throw new IOException(report.getMessage());
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
            return uploadedFiles;
        }

        private File createTempFolder(File parent) throws IOException {
            File result = File.createTempFile(AdminAdapter.UPLOAD_DIR_PREFIX, "", parent);
            try {
                if (!result.delete()) {
                    throw new IOException(adminStrings.getLocalString("adapter.command.errorDeletingTempFile", "Error deleting temporary file {0}", new Object[]{result.getAbsolutePath()}));
                }
                if (!result.mkdir()) {
                    throw new IOException(adminStrings.getLocalString("adapter.command.errorCreatingDir", "Error creating directory {0}", new Object[]{result.getAbsolutePath()}));
                }
                logger.fine("Created temporary upload folder " + result.getAbsolutePath());
                return result;
            }
            catch (Exception e) {
                IOException ioe = new IOException(adminStrings.getLocalString("adapter.command.errorCreatingUploadFolder", "Error creating temporary upload folder"));
                ioe.initCause(e);
                throw ioe;
            }
        }
    }
}

