/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import com.sun.hk2.component.LazyInhabitant;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.Womb;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.ConfiguredWomb;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.DomProxyWomb;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.LocationImpl;
import org.jvnet.hk2.config.ObservableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dom
extends LazyInhabitant
implements InvocationHandler,
ObservableBean {
    public final ConfigModel model;
    private final Dom parent;
    private Map<String, String> attributes = new HashMap<String, String>();
    private volatile List<Child> children = Collections.emptyList();
    private final Location location;
    public final DomDocument document;
    private static final Pattern TOKENIZER;
    private static final String[] PROPERTY_PREFIX;
    Set<ConfigListener> listeners = new HashSet<ConfigListener>();

    public void initializationCompleted() {
    }

    public Dom(Habitat habitat, DomDocument document, Dom parent, ConfigModel model, XMLStreamReader in) {
        super(habitat, model.classLoaderHolder, model.targetTypeName, MultiMap.emptyMap());
        this.location = in != null ? new LocationImpl(in.getLocation()) : null;
        this.model = model;
        this.document = document;
        this.parent = parent;
        assert (parent == null || parent.document == document);
    }

    public Dom(Habitat habitat, DomDocument document, Dom parent, ConfigModel model) {
        this(habitat, document, parent, model, null);
    }

    public static Dom unwrap(ConfigBeanProxy proxy) {
        InvocationHandler ih = Proxy.getInvocationHandler(proxy);
        if (ih instanceof Dom) {
            return (Dom)ih;
        }
        if (ih instanceof ConfigView) {
            return (Dom)((Object)((ConfigView)ih).getMasterView());
        }
        return null;
    }

    public String getKey() {
        String k = this.model.key;
        if (k == null) {
            return null;
        }
        switch (k.charAt(0)) {
            case '@': {
                return this.attribute(k.substring(1));
            }
            case '<': {
                return this.leafElement(k.substring(1, k.length() - 1));
            }
        }
        throw new IllegalStateException("Invalid key value:" + k);
    }

    public Dom parent() {
        return this.parent;
    }

    void fillAttributes(XMLStreamReader in) {
        for (int i = in.getAttributeCount() - 1; i >= 0; --i) {
            String n = in.getAttributeLocalName(i);
            if (!this.model.attributes.containsKey(n)) continue;
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(n, in.getAttributeValue(i));
        }
        if (this.attributes == null) {
            this.attributes = Collections.emptyMap();
        }
    }

    public Location getLocation() {
        return this.location;
    }

    private String t(String s) {
        if (s == null) {
            return null;
        }
        return this.document.getTranslator().translate(s);
    }

    public String attribute(String name) {
        return this.t(this.rawAttribute(name));
    }

    public String rawAttribute(String name) {
        String value = this.attributes.get(name);
        if (value == null && this.model.attributes.containsKey(name)) {
            value = this.model.attributes.get(name).getDefaultValue();
        }
        return value;
    }

    public Set<String> getAttributeNames() {
        return this.model.getAttributeNames();
    }

    public Set<String> getLeafElementNames() {
        List<Child> children = this.children;
        HashSet<String> names = new HashSet<String>();
        for (Child child : children) {
            names.add(child.name);
        }
        return names;
    }

    public List<String> attributes(String name) {
        String v = this.attribute(name);
        if (v == null) {
            return null;
        }
        ArrayList<String> r = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(v, ",");
        while (tokens.hasMoreTokens()) {
            r.add(tokens.nextToken().trim());
        }
        return r;
    }

    public void attribute(String name, String value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
            this.getInjector().injectAttribute(this, name, this.get());
        }
    }

    public String leafElement(String name) {
        return this.t(this.rawLeafElement(name));
    }

    public synchronized void insertAfter(Dom reference, String name, Dom newNode) {
        if (name.equals("*")) {
            name = newNode.model.tagName;
        }
        NodeChild newChild = new NodeChild(name, newNode);
        if (this.children.size() == 0) {
            this.children = new ArrayList<Child>();
        }
        if (reference == null) {
            this.children.add(0, newChild);
            return;
        }
        ListIterator<Child> itr = this.children.listIterator();
        while (itr.hasNext()) {
            Child child = itr.next();
            if (!(child instanceof NodeChild)) continue;
            NodeChild nc = (NodeChild)child;
            if (nc.dom != reference) continue;
            itr.add(newChild);
            this.habitat.addIndex((Inhabitant)newNode, newNode.getProxyType().getName(), newNode.getKey());
            return;
        }
        throw new IllegalArgumentException(reference + " is not a valid child of " + this + ". Children=" + this.children);
    }

    public synchronized void replaceChild(Dom reference, String name, Dom newNode) {
        ListIterator<Child> itr = this.children.listIterator();
        while (itr.hasNext()) {
            Child child = itr.next();
            if (!(child instanceof NodeChild)) continue;
            NodeChild nc = (NodeChild)child;
            if (nc.dom != reference) continue;
            itr.set(new NodeChild(name, newNode));
            return;
        }
        throw new IllegalArgumentException(reference + " is not a valid child of " + this + ". Children=" + this.children);
    }

    public synchronized void removeChild(Dom reference) {
        ListIterator<Child> itr = this.children.listIterator();
        while (itr.hasNext()) {
            Child child = itr.next();
            if (!(child instanceof NodeChild)) continue;
            NodeChild nc = (NodeChild)child;
            if (nc.dom != reference) continue;
            itr.remove();
            this.habitat.removeIndex(reference.getProxyType().getName(), reference.getKey());
            reference.release();
            return;
        }
        throw new IllegalArgumentException(reference + " is not a valid child of " + this + ". Children=" + this.children);
    }

    public synchronized boolean addLeafElement(String xmlName, String value) {
        if (this.children.size() == 0) {
            this.children = new ArrayList<Child>();
        }
        return this.children.add(new LeafChild(xmlName, value));
    }

    public synchronized boolean removeLeafElement(String xmlName, String element) {
        List<Child> children = this.children;
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Child child = children.get(i);
            if (!child.name.equals(xmlName) || !((LeafChild)child).value.equals(element)) continue;
            return children.remove(child);
        }
        return false;
    }

    public synchronized boolean changeLeafElement(String xmlName, String oldValue, String newValue) {
        List<Child> children = this.children;
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Child child = children.get(i);
            if (!child.name.equals(xmlName) || !((LeafChild)child).value.equals(oldValue)) continue;
            return children.set(i, new LeafChild(xmlName, newValue)) != null;
        }
        return false;
    }

    public String rawLeafElement(String name) {
        List<Child> children = this.children;
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Child child = children.get(i);
            if (!child.name.equals(name)) continue;
            return ((LeafChild)child).value;
        }
        return null;
    }

    private static void stitchList(List<Child> list, String name, List<? extends Child> newSubList) {
        int last = list.size();
        ListIterator<Child> itr = list.listIterator();
        ListIterator<? extends Child> jtr = newSubList.listIterator();
        while (itr.hasNext()) {
            Child child = itr.next();
            if (!child.name.equals(name)) continue;
            if (jtr.hasNext()) {
                itr.set(jtr.next());
                last = itr.nextIndex();
                continue;
            }
            itr.remove();
        }
        if (jtr.hasNext()) {
            list.addAll(last, newSubList.subList(jtr.nextIndex(), newSubList.size()));
        }
    }

    public synchronized void setLeafElements(String name, String ... values) {
        ArrayList<Child> newChildren = new ArrayList<Child>(this.children);
        LeafChild[] leaves = new LeafChild[values.length];
        for (int i = 0; i < values.length; ++i) {
            leaves[i] = new LeafChild(name, values[i]);
        }
        Dom.stitchList(newChildren, name, Arrays.asList(leaves));
        this.children = newChildren;
        this.getInjector().injectElement(this, name, this.get());
    }

    public List<String> leafElements(String name) {
        List<Child> children = this.children;
        ArrayList<String> r = new ArrayList<String>();
        for (Child child : children) {
            if (!child.name.equals(name)) continue;
            r.add(this.t(((LeafChild)child).value));
        }
        return r;
    }

    public List<String> rawLeafElements(String name) {
        List<Child> children = this.children;
        ArrayList<String> r = new ArrayList<String>();
        for (Child child : children) {
            if (!child.name.equals(name)) continue;
            r.add(((LeafChild)child).value);
        }
        return r;
    }

    public Dom nodeElement(String name) {
        List<Child> children = this.children;
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Child child = children.get(i);
            if (!child.name.equals(name)) continue;
            return ((NodeChild)child).dom;
        }
        return null;
    }

    public synchronized void setNodeElements(String name, Dom ... values) {
        ArrayList<Child> newChildren = new ArrayList<Child>(this.children);
        NodeChild[] leaves = new NodeChild[values.length];
        for (int i = 0; i < values.length; ++i) {
            leaves[i] = new NodeChild(name, values[i]);
        }
        Dom.stitchList(newChildren, name, Arrays.asList(leaves));
        this.children = newChildren;
        this.getInjector().injectElement(this, name, this.get());
    }

    public List<Dom> nodeElements(String elementName) {
        List<Child> children = this.children;
        ArrayList<Dom> r = new ArrayList<Dom>();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Child child = children.get(i);
            if (!child.name.equals(elementName)) continue;
            r.add(((NodeChild)child).dom);
        }
        return r;
    }

    public List<Dom> domNodeByTypeElements(Class baseType) {
        ArrayList<Dom> r = new ArrayList<Dom>();
        int len = this.children.size();
        for (int i = 0; i < len; ++i) {
            Child child = this.children.get(i);
            if (!(child instanceof NodeChild)) continue;
            NodeChild nc = (NodeChild)child;
            if (this.model.elements.containsKey(nc.name) || !baseType.isAssignableFrom(nc.dom.type())) continue;
            r.add(nc.dom);
        }
        return r;
    }

    public <T> List<T> nodeByTypeElements(final Class<T> baseType) {
        final List<Dom> elements = this.domNodeByTypeElements(baseType);
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return baseType.cast(((Dom)elements.get(index)).get());
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    public <T> T nodeByTypeElement(Class<T> baseType) {
        int len = this.children.size();
        for (int i = 0; i < len; ++i) {
            Child child = this.children.get(i);
            if (!(child instanceof NodeChild)) continue;
            NodeChild nc = (NodeChild)child;
            if (this.model.elements.containsKey(nc.name) || !baseType.isAssignableFrom(nc.dom.type())) continue;
            return baseType.cast(nc.dom.get());
        }
        return null;
    }

    public void inject(Object target) {
        this.model.inject(this, target);
    }

    public ConfigInjector getInjector() {
        return (ConfigInjector)this.model.injector.get();
    }

    public Dom getSymbolSpaceRoot(String typeName) {
        Dom dom = this;
        while (!dom.model.symbolSpaces.contains(typeName)) {
            Dom p = dom.parent();
            if (p == null) {
                return dom;
            }
            dom = p;
        }
        return dom;
    }

    public Dom resolveReference(String key, String typeName) {
        String keyedAs = this.model.keyedAs;
        if (keyedAs != null && keyedAs.equals(typeName) && this.getKey().equals(key)) {
            return this;
        }
        for (Child child : this.children) {
            if (!(child instanceof NodeChild)) continue;
            NodeChild n = (NodeChild)child;
            Dom found = n.dom.resolveReference(key, typeName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public <T extends ConfigBeanProxy> T createProxy(Class<T> proxyType) {
        return (T)((ConfigBeanProxy)proxyType.cast(Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, (InvocationHandler)this)));
    }

    public <T extends ConfigBeanProxy> T createProxy() {
        return this.createProxy(this.getProxyType());
    }

    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        try {
            return ((ClassLoader)this.model.classLoaderHolder.get()).loadClass(this.model.targetTypeName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Object.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        if (clazz == Injectable.class) {
            this.injectInto(this, args[0]);
            return null;
        }
        if (method.getAnnotation(DuckTyped.class) != null) {
            return this.invokeDuckMethod(method, proxy, args);
        }
        ConfigModel.Property p = this.toProperty(method);
        if (p == null) {
            throw new IllegalArgumentException("No corresponding property found for method: " + method);
        }
        if (args == null || args.length == 0) {
            return this.getter(p, method.getGenericReturnType());
        }
        this.setter(p, args[0]);
        return null;
    }

    public Object invoke(Object proxy, String methodName, Class[] argTypes, Object[] args) throws Throwable {
        return this.invoke(proxy, this.getProxyType().getMethod(methodName, argTypes), args);
    }

    Object invokeDuckMethod(Method method, Object proxy, Object[] args) throws Exception {
        Object[] duckArgs;
        Method duckMethod = this.model.getDuckMethod(method);
        if (args == null) {
            duckArgs = new Object[]{proxy};
        } else {
            duckArgs = new Object[args.length + 1];
            duckArgs[0] = proxy;
            System.arraycopy(args, 0, duckArgs, 1, args.length);
        }
        try {
            return duckMethod.invoke(null, duckArgs);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw e;
        }
    }

    protected Object getter(ConfigModel.Property target, Type t) {
        return target.get(this, t);
    }

    protected void setter(ConfigModel.Property target, Object value) throws Exception {
        target.set(this, value);
    }

    protected ConfigModel.Property toProperty(Method method) {
        String an;
        String en;
        String name = method.getName();
        Element e = method.getAnnotation(Element.class);
        if (e != null && (en = e.value()).length() > 0) {
            return this.model.elements.get(en);
        }
        Attribute a = method.getAnnotation(Attribute.class);
        if (a != null && (an = a.value()).length() > 0) {
            return this.model.attributes.get(an);
        }
        for (String p : PROPERTY_PREFIX) {
            if (!name.startsWith(p)) continue;
            name = name.substring(p.length());
            break;
        }
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (String t : TOKENIZER.split(name)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        name = buf.toString();
        return this.model.findIgnoreCase(name);
    }

    protected ConfigModel.Property getConfigModel_Property(String xmlName) {
        ConfigModel.Property cmp = this.model.findIgnoreCase(xmlName);
        if (cmp == null) {
            throw new IllegalArgumentException("Illegal name: " + xmlName);
        }
        return cmp;
    }

    public boolean isLeaf(String xmlName) {
        return this.getConfigModel_Property(xmlName).isLeaf();
    }

    public boolean isCollection(String xmlName) {
        return this.getConfigModel_Property(xmlName).isCollection();
    }

    public static String convertName(String name) {
        for (String p : PROPERTY_PREFIX) {
            if (!name.startsWith(p)) continue;
            name = name.substring(p.length());
            break;
        }
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (String t : TOKENIZER.split(name)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        return buf.toString();
    }

    private static String split(String lookback, String lookahead) {
        return "((?<=" + lookback + ")(?=" + lookahead + "))";
    }

    private static String or(String ... tokens) {
        StringBuilder buf = new StringBuilder();
        for (String t : tokens) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    protected Womb createWomb(Class c) {
        return ConfigBeanProxy.class.isAssignableFrom(c) ? new DomProxyWomb(c, (MultiMap<String, String>)this.metadata(), this) : new ConfiguredWomb(super.createWomb(c), this);
    }

    public static <T extends Annotation> T digAnnotation(Class<?> target, Class<T> annotationType) {
        return Dom.digAnnotation(target, annotationType, new ArrayList<Class<? extends Annotation>>());
    }

    public static <T extends Annotation> T digAnnotation(Class<?> target, Class<T> annotationType, List<Class<? extends Annotation>> visited) {
        T result = target.getAnnotation(annotationType);
        if (result == null) {
            for (Annotation a : target.getAnnotations()) {
                if (visited.contains(a.annotationType())) continue;
                visited.add(a.annotationType());
                result = Dom.digAnnotation(a.annotationType(), annotationType, visited);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    void setChildren(List<Child> children) {
        this.children = children;
    }

    public void writeTo(String tagName, XMLStreamWriter w) throws XMLStreamException {
        if (tagName == null) {
            tagName = this.model.tagName;
        }
        if (tagName == null) {
            throw new IllegalArgumentException("Trying t write a local element " + this + " w/o a tag name");
        }
        w.writeStartElement(tagName);
        HashMap<String, String> localAttr = new HashMap<String, String>(this.attributes);
        for (Map.Entry a : localAttr.entrySet()) {
            ConfigModel.AttributeLeaf am = this.model.attributes.get(a.getKey());
            String dv = am.getDefaultValue();
            if (dv != null && dv.equals(a.getValue())) continue;
            w.writeAttribute((String)a.getKey(), (String)a.getValue());
        }
        ArrayList<Child> localChildren = new ArrayList<Child>(this.children);
        for (Child c : localChildren) {
            c.writeTo(w);
        }
        w.writeEndElement();
    }

    protected void injectInto(Dom injectable, Object target) {
        for (Class<?> intf : target.getClass().getInterfaces()) {
            if (!ConfigListener.class.isAssignableFrom(intf)) continue;
            ConfigListener listener = (ConfigListener)target;
            this.addListener(listener);
            return;
        }
    }

    public void release() {
        this.listeners.clear();
        super.release();
    }

    @Override
    public void addListener(ConfigListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ConfigListener listener) {
        return this.listeners.remove(listener);
    }

    Collection<ConfigListener> getListeners() {
        return this.listeners;
    }

    static {
        String pattern = Dom.or(Dom.split("x", "X"), Dom.split("X", "Xx"), Dom.split("\\d", "\\D"));
        pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
        TOKENIZER = Pattern.compile(pattern);
        PROPERTY_PREFIX = new String[]{"get", "set", "is", "has"};
    }

    static final class LeafChild
    extends Child {
        final String value;

        LeafChild(String name, String value) {
            super(name);
            this.value = value;
        }

        protected void writeTo(XMLStreamWriter w) throws XMLStreamException {
            w.writeStartElement(this.name);
            w.writeCharacters(this.value);
            w.writeEndElement();
        }
    }

    static final class NodeChild
    extends Child {
        final Dom dom;

        NodeChild(String name, Dom dom) {
            super(name);
            this.dom = dom;
        }

        protected void writeTo(XMLStreamWriter w) throws XMLStreamException {
            this.dom.writeTo(this.name, w);
        }
    }

    static abstract class Child {
        final String name;

        Child(String name) {
            this.name = name;
        }

        protected abstract void writeTo(XMLStreamWriter var1) throws XMLStreamException;
    }
}

