/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class UpgradeService
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Domain domain;

    public void postConstruct() {
        for (Application app : this.domain.getApplications().getModules(Application.class)) {
            if (app.getEngine() == null || app.getEngine().size() <= 0) continue;
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Application>(){

                    public Object run(Application application) throws PropertyVetoException, TransactionFailure {
                        Module module = (Module)ConfigSupport.createChildOf((Object)application, Module.class);
                        module.setName(application.getName());
                        for (Engine engine : application.getEngine()) {
                            module.getEngines().add(engine);
                        }
                        application.getModule().add(module);
                        application.getEngine().clear();
                        return null;
                    }
                }, (ConfigBeanProxy)app);
            }
            catch (TransactionFailure tf) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading application " + app.getName() + " please redeploy", tf);
                throw new RuntimeException(tf);
            }
        }
    }
}

