/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommandParser;
import com.sun.enterprise.admin.cli.remote.CommandInvoker;
import com.sun.enterprise.admin.cli.remote.ExceptionAnalyzer;
import com.sun.enterprise.admin.cli.remote.Log;
import com.sun.enterprise.admin.cli.remote.RemoteException;
import com.sun.enterprise.admin.cli.remote.RemoteResponseManager;
import com.sun.enterprise.admin.cli.remote.RemoteSuccessException;
import com.sun.enterprise.admin.cli.util.AuthenticationInfo;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.admin.cli.util.HttpConnectorAddress;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.universal.BASE64Encoder;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.FileUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIRemoteCommand {
    private boolean verbose = false;
    private boolean terse = false;
    private boolean echo = false;
    private Map<String, String> mainAtts;
    private LoginInfoStore store;
    private Map<String, String> params;
    private List<String> operands;
    private String commandName;
    private String responseFormatType = "hk2-agent";
    private OutputStream userOut;
    private boolean doUpload = false;
    private File fileParameter;
    private File deploymentPlanParameter;
    private Map<String, String> encodedPasswords;
    private String hostName;
    private int hostPort;
    private boolean secure;
    private String user;
    private String password;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CLIRemoteCommand.class);
    private static final CLILogger logger = CLILogger.getInstance();
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILURE = "FAILURE";
    private static final String MAGIC = "PlainTextActionReporter";
    private static final String[] LOCAL_PARAMS = new String[]{"host", "port", "upload", "user", "passwordfile", "secure", "terse", "echo", "interactive"};
    private static final String QUERY_STRING_INTRODUCER = "?";
    private static final String QUERY_STRING_SEPARATOR = "&";
    private static final String ADMIN_URI_PATH = "/__asadmin/";
    public static final String RELIABLE_COMMAND = "version";

    public CLIRemoteCommand(String ... args) throws CommandException {
        this.initialize(args);
    }

    public CLIRemoteCommand(String[] args, String responseFormatType, OutputStream userOut) throws CommandException {
        this.initialize(args);
        this.responseFormatType = responseFormatType;
        this.userOut = userOut;
    }

    public void runCommand() throws CommandException {
        try {
            String msg;
            StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH + this.commandName);
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                String paramName = param.getKey();
                if (this.isLocalParam(paramName)) continue;
                try {
                    String paramValue = param.getValue();
                    this.addOption(uriString, paramName + "=" + URLEncoder.encode(paramValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    logger.printError("Error encoding " + paramName + ", parameter value will be ignored");
                }
            }
            this.addFileOption(uriString, "path", this.doUpload, this.fileParameter);
            this.addFileOption(uriString, "deploymentplan", this.doUpload, this.deploymentPlanParameter);
            if (this.encodedPasswords != null) {
                for (Map.Entry<String, String> entry : this.encodedPasswords.entrySet()) {
                    this.addOption(uriString, entry.getKey() + "=" + entry.getValue());
                }
            }
            if (this.commandName.equalsIgnoreCase("change-admin-password")) {
                this.addOption(uriString, "username=" + this.user);
            }
            for (String operand : this.operands) {
                this.addOption(uriString, "DEFAULT=" + URLEncoder.encode(operand, "UTF-8"));
            }
            HttpURLConnection urlConnection = null;
            try {
                HttpConnectorAddress url = new HttpConnectorAddress(this.hostName, this.hostPort, this.secure);
                logger.printDebugMessage("URI: " + uriString.toString());
                logger.printDebugMessage("URL: " + url.toString());
                logger.printDebugMessage("URL: " + url.toURL(uriString.toString()).toString());
                url.setAuthenticationInfo(new AuthenticationInfo(this.user, this.password));
                urlConnection = (HttpURLConnection)url.openConnection(uriString.toString());
                urlConnection.setRequestProperty("User-Agent", this.responseFormatType);
                urlConnection.setRequestProperty("Authorization", url.getBasicAuthString());
                urlConnection.setRequestMethod(this.chooseRequestMethod());
                if (this.doUpload) {
                    urlConnection.setChunkedStreamingMode(0);
                }
                urlConnection.connect();
                if (this.doUpload) {
                    this.upload(urlConnection);
                }
                InputStream in = urlConnection.getInputStream();
                this.handleResponse(this.params, in, urlConnection.getResponseCode(), this.userOut);
            }
            catch (ConnectException ce) {
                msg = strings.get("ConnectException", new Object[]{this.hostName, this.hostPort + ""});
                throw new CommandException(msg, ce);
            }
            catch (IOException e) {
                int rc;
                msg = null;
                msg = urlConnection != null ? (401 == (rc = urlConnection.getResponseCode()) ? strings.get("InvalidCredentials", new Object[]{this.user}) : "Status: " + rc) : "Unknown Error";
                throw new CommandException(msg, e);
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (SocketException se) {
            try {
                boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.hostName, (int)this.hostPort);
                if (serverAppearsSecure != this.secure) {
                    String msg = strings.get("ServerMaybeSecure", new Object[]{this.hostName, this.hostPort + ""});
                    logger.printError(msg);
                    throw new CommandException(se);
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                throw new CommandException(io);
            }
        }
        catch (Exception e) {
            logger.printExceptionStackTrace(e);
            throw new CommandException(e);
        }
    }

    private StringBuilder addOption(StringBuilder uriString, String option) {
        String nextChar = uriString.indexOf(QUERY_STRING_INTRODUCER) == -1 ? QUERY_STRING_INTRODUCER : QUERY_STRING_SEPARATOR;
        uriString.append(nextChar).append(option);
        return uriString;
    }

    private StringBuilder addFileOption(StringBuilder uriString, String optionName, boolean isUpload, File parameter) throws UnsupportedEncodingException {
        if (parameter != null) {
            String pathToPass = isUpload ? parameter.getName() : parameter.getPath();
            this.addOption(uriString, optionName + "=" + URLEncoder.encode(pathToPass, "UTF-8"));
        }
        return uriString;
    }

    private String chooseRequestMethod() {
        if (this.doUpload) {
            return "POST";
        }
        return "GET";
    }

    private void upload(HttpURLConnection conn) throws CommandException, IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(conn.getOutputStream()));
        if (this.fileParameter != null) {
            this.upload(zos, this.fileParameter);
        }
        if (this.deploymentPlanParameter != null) {
            this.upload(zos, this.deploymentPlanParameter);
        }
        zos.flush();
    }

    private void upload(ZipOutputStream out, File uploadFile) throws CommandException {
        ZipEntry entry = new ZipEntry(uploadFile.getName());
        entry.setTime(uploadFile.lastModified());
        try {
            out.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(uploadFile));
            byte[] buffer = new byte[65536];
            int i = bis.read(buffer);
            while (i > 0) {
                out.write(buffer, 0, i);
                i = bis.read(buffer);
            }
            out.closeEntry();
            bis.close();
        }
        catch (IOException ex) {
            throw new CommandException(ex.getMessage());
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code, OutputStream userOut) throws IOException, CommandException {
        if (userOut == null) {
            this.handleResponse(params, in, code);
        } else {
            FileUtils.copyStream((InputStream)in, (OutputStream)userOut);
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code) throws IOException, CommandException {
        RemoteResponseManager rrm = null;
        try {
            rrm = new RemoteResponseManager(in, code);
            rrm.process();
        }
        catch (RemoteSuccessException rse) {
            if (rrm != null) {
                this.mainAtts = rrm.getMainAtts();
            }
            Log.info(rse.getMessage(), new Object[0]);
            return;
        }
        catch (RemoteException rfe) {
            if (rfe.getRemoteCause().indexOf("CommandNotFoundException") > 0) {
                throw new CommandException(rfe.getMessage(), new InvalidCommandException());
            }
            throw new CommandException("remote failure: " + rfe.getMessage(), rfe);
        }
    }

    private void setBooleans() {
        String value;
        if (this.params.containsKey("verbose")) {
            value = this.params.get("verbose");
            this.verbose = this.ok(value) ? Boolean.parseBoolean(this.params.get("verbose")) : true;
        }
        if (this.params.containsKey("echo")) {
            value = this.params.get("echo");
            this.echo = this.ok(value) ? Boolean.parseBoolean(this.params.get("echo")) : true;
        }
        if (this.params.containsKey("terse")) {
            value = this.params.get("terse");
            this.terse = this.ok(value) ? Boolean.parseBoolean(this.params.get("terse")) : true;
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.commandName).append(' ');
        sb.append("--echo=").append(Boolean.toString(this.echo)).append(' ');
        sb.append("--terse=").append(Boolean.toString(this.terse)).append(' ');
        Set<String> paramKeys = this.params.keySet();
        for (String key : paramKeys) {
            if (key.equals("terse") || key.equals("echo")) continue;
            String value = this.params.get(key);
            sb.append("--").append(key);
            if (this.ok(value)) {
                sb.append('=').append(value);
            }
            sb.append(' ');
        }
        for (String o : this.operands) {
            sb.append((Object)o).append(' ');
        }
        return sb.toString();
    }

    public Map<String, String> getMainAtts() {
        return this.mainAtts;
    }

    public static boolean pingDAS(CommandInvoker invoker) {
        try {
            invoker.invoke();
            return true;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Got java.net.ConnectException");
                return false;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                CLILogger.getInstance().printDebugMessage("It appears that server has started, but for some reason the exception is thrown: " + ex.getMessage());
                return true;
            }
            return false;
        }
    }

    public static boolean pingDASWithAuth(CommandInvoker invoker) {
        try {
            invoker.invoke();
            return true;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Got java.net.ConnectException");
                return false;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Auth info is incorrect" + ex.getMessage());
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingDASQuietly(CommandInvoker invoker) {
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            boolean bl = CLIRemoteCommand.pingDAS(invoker);
            return bl;
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    private void initialize(String[] args) throws CommandException {
        try {
            CLIRemoteCommandParser rcp = new CLIRemoteCommandParser(args);
            this.commandName = rcp.getCommandName();
            this.params = rcp.getOptions();
            this.operands = rcp.getOperands();
            this.initializeStandardParams();
            this.initializeDeploy();
            this.initializeLogger();
            logger.printDebugMessage("CLIRemoteCommandParser: " + rcp);
            this.initializeAuth();
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    private void initializeStandardParams() throws CommandException {
        this.setBooleans();
        this.hostName = this.params.get("host");
        if (this.hostName == null || this.hostName.length() == 0) {
            this.hostName = "localhost";
        }
        logger.printDebugMessage("host = " + this.hostName);
        this.initializePort();
        String s = this.params.get("secure");
        this.secure = this.ok(s) ? Boolean.parseBoolean(s) : false;
    }

    private void initializePort() throws CommandException {
        String port = this.params.get("port");
        if (this.ok(port)) {
            try {
                this.hostPort = Integer.parseInt(port);
                if (this.hostPort < 1 || this.hostPort > 65535) {
                    throw new CommandException(strings.get("badport", new Object[]{this.hostPort}));
                }
            }
            catch (NumberFormatException e) {
                port = null;
            }
        }
        if (!this.ok(port)) {
            this.hostPort = 4848;
        }
    }

    private void initializeLogger() {
        if (this.terse) {
            logger.setOutputLevel(Level.INFO);
        } else {
            logger.setOutputLevel(Level.FINE);
        }
        if (this.echo) {
            logger.printMessage(this.toString());
        } else if (logger.isDebug()) {
            logger.printDebugMessage(this.toString());
        }
    }

    private void initializeDeploy() throws CommandException {
        String filename;
        if (!this.isDeployment()) {
            return;
        }
        if (this.params.get("help") != null) {
            return;
        }
        if (this.operands.size() > 0) {
            filename = this.operands.get(0);
            this.operands.clear();
        } else {
            filename = this.params.get("path");
            this.params.remove("path");
        }
        if (this.commandName.equals("redeploy") && filename == null) {
            return;
        }
        if (!this.ok(filename)) {
            throw new CommandException(strings.get("noDeployFile", new Object[]{this.commandName}));
        }
        this.fileParameter = SmartFile.sanitize((File)new File(filename));
        if (!this.fileParameter.exists()) {
            throw new CommandException(strings.get("badDeployFile", new Object[]{this.commandName, this.fileParameter}));
        }
        String deploymentPlan = this.params.get("deploymentplan");
        if (deploymentPlan != null) {
            this.deploymentPlanParameter = SmartFile.sanitize((File)new File(deploymentPlan));
            if (!this.deploymentPlanParameter.exists()) {
                throw new CommandException(strings.get("badDeploymentPlan", new Object[]{this.commandName, this.deploymentPlanParameter}));
            }
        }
        if (!this.isDirDeployment()) {
            String upString = this.params.get("upload");
            this.doUpload = !this.ok(upString) ? true : Boolean.parseBoolean(upString);
        }
    }

    private void initializeAuth() throws CommandException {
        LoginInfo li = null;
        try {
            this.store = LoginInfoStoreFactory.getDefaultStore();
            li = this.store.read(this.hostName, this.hostPort);
        }
        catch (StoreException se) {
            logger.printDebugMessage("Login info could not be read from ~/.asadminpass file");
        }
        this.initializeUser(li);
        this.initializePassword(li);
    }

    private void initializeUser(LoginInfo li) {
        this.user = this.params.get("user");
        if (this.user == null && li != null) {
            this.user = li.getUser();
        }
    }

    private void initializePassword(LoginInfo li) throws CommandException {
        String pwfile;
        this.encodedPasswords = new HashMap<String, String>();
        if (this.commandName.equalsIgnoreCase("change-admin-password") && this.params.get("help") == null) {
            try {
                this.password = this.getInteractiveOptionWithConfirmation(this.encodedPasswords);
                CLIRemoteCommand.base64encode(this.encodedPasswords);
                return;
            }
            catch (CommandValidationException cve) {
                throw new CommandException(cve);
            }
        }
        if ((this.commandName.equalsIgnoreCase("create-password-alias") || this.commandName.equalsIgnoreCase("update-password-alias")) && this.params.get("help") == null) {
            try {
                this.password = this.confirmInteractivelyAliasPassword(this.encodedPasswords);
                CLIRemoteCommand.base64encode(this.encodedPasswords);
            }
            catch (CommandValidationException cve) {
                throw new CommandException(cve);
            }
        }
        if (this.params.get("password") != null) {
            this.password = this.params.get("password");
            this.params.remove("password");
            this.encodedPasswords.put("AS_ADMIN_PASSWORD", this.password);
            CLIRemoteCommand.base64encode(this.encodedPasswords);
        }
        if (this.ok(pwfile = this.params.get("passwordfile"))) {
            this.encodedPasswords = CLIUtil.readPasswordFileOptions(pwfile, true);
            this.password = this.encodedPasswords.get("AS_ADMIN_PASSWORD");
            CLIRemoteCommand.base64encode(this.encodedPasswords);
        }
        if (!this.ok(this.password) && li != null) {
            this.password = li.getPassword();
        }
    }

    private String confirmInteractivelyAliasPassword(Map<String, String> encodedPasswords) throws CommandValidationException {
        String prompt = this.getLocalizedString("AliasPasswordPrompt");
        String confirmationPrompt = this.getLocalizedString("AliasPasswordConfirmationPrompt");
        String aliasPassword = this.getInteractiveOption(prompt);
        encodedPasswords.put("AS_ADMIN_ALIASPASSWORD", aliasPassword);
        String aliasPasswordAgain = this.getInteractiveOption(confirmationPrompt);
        if (!aliasPassword.equals(aliasPasswordAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{"Admin Password"}));
        }
        return aliasPassword;
    }

    private String getInteractiveOptionWithConfirmation(Map<String, String> encodedPasswords) throws CommandValidationException {
        String prompt = this.getLocalizedString("AdminPasswordPrompt");
        String newprompt = this.getLocalizedString("AdminNewPasswordPrompt");
        String confirmationPrompt = this.getLocalizedString("AdminNewPasswordConfirmationPrompt");
        String oldpassword = this.getInteractiveOption(prompt);
        if (!this.isPasswordValid(oldpassword)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"Admin"}));
        }
        encodedPasswords.put("AS_ADMIN_PASSWORD", oldpassword);
        String newpassword = this.getInteractiveOption(newprompt);
        if (!this.isPasswordValid(newpassword)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"Admin"}));
        }
        encodedPasswords.put("AS_ADMIN_NEWPASSWORD", newpassword);
        String newpasswordAgain = this.getInteractiveOption(confirmationPrompt);
        if (!newpassword.equals(newpasswordAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{"Admin Password"}));
        }
        return oldpassword;
    }

    protected String getInteractiveOption(String prompt) throws CommandValidationException {
        String optionValue;
        try {
            InputsAndOutputs.getInstance().getUserOutput().print(prompt);
            InputsAndOutputs.getInstance().getUserOutput().flush();
            optionValue = new CliUtil().getPassword();
        }
        catch (NoClassDefFoundError e) {
            optionValue = this.readInput();
        }
        catch (UnsatisfiedLinkError e) {
            optionValue = this.readInput();
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
        return optionValue;
    }

    private String readInput() {
        try {
            return InputsAndOutputs.getInstance().getUserInput().getLine();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    protected boolean isPasswordValid(String passwd) {
        return passwd.length() >= 8;
    }

    private String getLocalizedString(String key) {
        LocalStringsManager lsm = null;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
        }
        catch (CommandValidationException cve) {
            return "Key not found";
        }
        return lsm.getString(key);
    }

    private String getLocalizedString(String key, Object[] toInsert) {
        LocalStringsManager lsm = null;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
            return lsm.getString(key, toInsert);
        }
        catch (CommandValidationException cve) {
            return "Key not found";
        }
    }

    private static void base64encode(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        BASE64Encoder encoder = new BASE64Encoder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String val = entry.getValue();
            if (val == null) continue;
            entry.setValue(encoder.encode(val.getBytes()));
        }
    }

    private boolean isDeployment() {
        return this.commandName.equals("deploy") || this.commandName.equals("redeploy") || this.commandName.equals("deploydir");
    }

    private boolean isDirDeployment() {
        return this.isDeployment() && this.fileParameter != null && this.fileParameter.isDirectory();
    }

    private boolean isLocalParam(String param) {
        return Arrays.asList(LOCAL_PARAMS).contains(param);
    }
}

