/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.admin.CommandRunner;
import com.sun.enterprise.v3.server.SnifferManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
public class DeployCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    private static final String INSTANCE_ROOT_URI_PROPERTY_NAME = "com.sun.aas.instanceRootURI";
    @Inject
    Applications apps;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Param(name="name", optional=true)
    String name = null;
    @Param(name="contextroot", optional=true)
    String contextRoot = null;
    @Param(name="virtualservers", optional=true)
    @I18n(value="virtualservers")
    String virtualservers = null;
    @Param(name="libraries", optional=true)
    String libraries = null;
    @Param(optional=true, defaultValue="false")
    Boolean force;
    @Param(name="precompilejsp", optional=true, defaultValue="false")
    Boolean precompilejsp;
    @Param(optional=true, defaultValue="false")
    Boolean verify;
    @Param(optional=true)
    String retrieve = null;
    @Param(optional=true)
    String dbvendorname = null;
    @Param(optional=true)
    Boolean createtables;
    @Param(optional=true)
    Boolean dropandcreatetables;
    @Param(optional=true)
    Boolean uniquetablenames;
    @Param(name="deploymentplan", optional=true)
    File deploymentplan = null;
    @Param(name="enabled", optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true, defaultValue="false")
    Boolean generatermistubs;
    @Param(optional=true, defaultValue="false")
    Boolean availabilityenabled;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false")
    Boolean keepreposdir;
    @Param(optional=true, defaultValue="true")
    Boolean logReportedErrors;
    @Inject
    Domain domain;
    @Param(primary=true)
    File path;
    @Param(optional=true)
    String description;
    @Param(optional=true, name="property")
    Properties properties;
    private List<ApplicationConfig> appConfigList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(AdminCommandContext context) {
        block55: {
            operationStartTime = Calendar.getInstance().getTimeInMillis();
            parameters = context.getCommandParameters();
            report = context.getActionReport();
            logger = context.getLogger();
            file = this.choosePathFile(context);
            if (!file.exists()) {
                report.setMessage(DeployCommand.localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            this.deploymentplan = this.chooseDeploymentPlanFile(context);
            if (this.snifferManager.hasNoSniffers()) {
                msg = DeployCommand.localStrings.getLocalString("nocontainer", "No container services registered, done...");
                report.failure(logger, msg);
                return;
            }
            try {
                archive = this.archiveFactory.openArchive(file);
            }
            catch (IOException e) {
                if (this.logReportedErrors.booleanValue()) {
                    report.failure(logger, "Error opening deployable artifact : " + file.getAbsolutePath(), (Throwable)e);
                } else {
                    report.setMessage("Error opening deployable artifact : " + file.getAbsolutePath() + e.toString());
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                }
                return;
            }
            expansionDir = null;
            try {
                archiveHandler = this.deployment.getArchiveHandler(archive);
                if (archiveHandler == null) {
                    report.failure(logger, DeployCommand.localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{file.getName()}));
                    return;
                }
                if (this.name == null) {
                    this.name = archiveHandler.getDefaultApplicationName(archive);
                    parameters.put("name", this.name);
                }
                if (parameters.containsKey("deploymentplan")) {
                    parameters.put("deploymentplan", this.deploymentplan.getAbsolutePath());
                }
                undeployProps = this.handleRedeploy(this.name, report, parameters);
                if (!this.keepreposdir.booleanValue()) {
                    FileUtils.whack((File)new File(this.env.getApplicationRepositoryPath(), this.name));
                }
                parameters.put("enabled", this.enabled.toString());
                source = new File(archive.getURI().getSchemeSpecificPart());
                isDirectoryDeployed = true;
                if (!source.isDirectory()) {
                    isDirectoryDeployed = false;
                    expansionDir = new File(this.domain.getApplicationRoot(), this.name);
                    if (!expansionDir.mkdirs()) {
                        logger.fine(DeployCommand.localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
                    }
                    try {
                        start = System.currentTimeMillis();
                        archiveHandler.expand(archive, this.archiveFactory.createArchive(expansionDir));
                        System.out.println("Deployment expansion took " + (System.currentTimeMillis() - start));
                        try {
                            archive.close();
                        }
                        catch (IOException e) {
                            report.failure(logger, DeployCommand.localStrings.getLocalString("deploy.errorclosingarchive", "Error while closing deployable artifact {0}", new Object[]{file.getAbsolutePath()}), (Throwable)e);
                            try {
                                archive.close();
                            }
                            catch (IOException e) {
                                logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                            }
                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                            } else if (expansionDir != null) {
                                FileUtils.whack((File)expansionDir);
                            }
                            return;
                        }
                    }
                    catch (IOException e) {
                        report.failure(logger, DeployCommand.localStrings.getLocalString("deploy.errorexpandingjar", "Error while expanding archive file"), (Throwable)e);
                        try {
                            archive.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                        }
                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                        } else if (expansionDir != null) {
                            FileUtils.whack((File)expansionDir);
                        }
                        return;
                    }
                    file = expansionDir;
                    archive = this.archiveFactory.openArchive(expansionDir);
                }
                sourceArchive = archive;
                deploymentContext = new DeploymentContextImpl(logger, sourceArchive, parameters, (ServerEnvironment)this.env);
                deploymentContext.setProps(undeployProps);
                if (this.properties != null) {
                    deploymentContext.getProps().putAll((Map<?, ?>)this.properties);
                }
                deploymentContext.clean();
                moduleProps = deploymentContext.getProps();
                moduleProps.setProperty("name", this.name);
                instanceRootURI = new URI(System.getProperty("com.sun.aas.instanceRootURI"));
                appURI = instanceRootURI.relativize(deploymentContext.getSource().getURI());
                appLocation = appURI.isAbsolute() != false ? appURI.toString() : "${com.sun.aas.instanceRootURI}/" + appURI.toString();
                moduleProps.setProperty("location", appLocation);
                moduleProps.setProperty("object-type", "user");
                if (this.contextRoot != null) {
                    moduleProps.setProperty("context-root", this.contextRoot);
                }
                if (this.libraries != null) {
                    moduleProps.setProperty("libraries", this.libraries);
                }
                moduleProps.setProperty("enabled", this.enabled.toString());
                moduleProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                if (this.virtualservers != null) {
                    moduleProps.setProperty("virtual-servers", this.virtualservers);
                }
                if (this.description != null) {
                    moduleProps.setProperty("description", this.description);
                }
                appInfo = this.deployment.deploy((ExtendedDeploymentContext)deploymentContext, report);
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext);
                }
                ** try [egrp 11[TRYBLOCK] [7 : 1293->1303)] { 
            }
            catch (Exception e) {
                report.failure(logger, "Error during deployment : " + e.getMessage(), (Throwable)e);
                break block55;
            }
            finally {
                try {
                    archive.close();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                } else if (expansionDir != null) {
                    FileUtils.whack(expansionDir);
                }
            }
lbl-1000:
            // 1 sources

            {
                archive.close();
            }
lbl128:
            // 1 sources

            catch (IOException e) {
                logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
            } else if (expansionDir != null) {
                FileUtils.whack((File)expansionDir);
            }
        }
    }

    private File choosePathFile(AdminCommandContext context) {
        if (context.getUploadedFiles().size() >= 1) {
            return (File)context.getUploadedFiles().get(0);
        }
        return this.path;
    }

    private File chooseDeploymentPlanFile(AdminCommandContext context) {
        if (context.getUploadedFiles().size() >= 2) {
            return (File)context.getUploadedFiles().get(1);
        }
        return this.deploymentplan;
    }

    private Properties handleRedeploy(String name, ActionReport report, Properties parameters) throws Exception {
        boolean isRegistered = this.deployment.isRegistered(name);
        if (isRegistered && !this.force.booleanValue()) {
            String msg = localStrings.getLocalString("application.alreadyreg.redeploy", "Application {0} already registered, please use deploy --force=true to redeploy", new Object[]{name});
            throw new Exception(msg);
        }
        if (isRegistered && this.force.booleanValue()) {
            this.settingsFromDomainXML(parameters);
            Properties undeployParam = new Properties();
            undeployParam.put("name", name);
            undeployParam.put("keepreposdir", this.keepreposdir.toString());
            ActionReport subReport = report.addSubActionsReport();
            if (this.properties != null && this.properties.containsKey("keepSessions")) {
                undeployParam.setProperty("properties", "keepSessions=" + this.properties.getProperty("keepSessions"));
                subReport.setExtraProperties(new Properties());
            }
            this.commandRunner.doCommand("undeploy", undeployParam, subReport);
            return subReport.getExtraProperties();
        }
        return null;
    }

    private void settingsFromDomainXML(Properties parameters) {
        if (this.name != null) {
            Application app;
            if (this.contextRoot == null) {
                this.contextRoot = ConfigBeansUtilities.getContextRoot((String)this.name);
                if (this.contextRoot != null) {
                    parameters.put("previous_contextroot", this.contextRoot);
                }
            }
            if (this.libraries == null) {
                this.libraries = ConfigBeansUtilities.getLibraries((String)this.name);
                if (this.libraries != null) {
                    parameters.put("libraries", this.libraries);
                }
            }
            if (this.virtualservers == null) {
                this.virtualservers = ConfigBeansUtilities.getVirtualServers((String)this.target, (String)this.name);
                if (this.virtualservers != null) {
                    parameters.put("virtualservers", this.virtualservers);
                }
            }
            if ((app = (Application)this.apps.getModule(Application.class, this.name)) != null) {
                parameters.put("APPLICATION_CONFIG", app);
            }
        }
    }
}

