/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.event;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventTypes<T> {
    private static final Map<String, EventTypes> EVENTS = new HashMap<String, EventTypes>();
    public static final String SERVER_READY_NAME = "server_ready";
    public static final String PREPARE_SHUTDOWN_NAME = "prepare_shutdown";
    public static final String SERVER_SHUTDOWN_NAME = "server_shutdown";
    public static final EventTypes SERVER_READY = EventTypes.create("server_ready");
    public static final EventTypes SERVER_SHUTDOWN = EventTypes.create("server_shutdown");
    public static final EventTypes PREPARE_SHUTDOWN = EventTypes.create("prepare_shutdown");
    private final String name;
    private final Class<T> hookType;

    public static EventTypes create(String name) {
        return EventTypes.create(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventTypes create(String name, Class hookType) {
        Map<String, EventTypes> map = EVENTS;
        synchronized (map) {
            if (!EVENTS.containsKey(name)) {
                EVENTS.put(name, new EventTypes(name, hookType));
            }
        }
        return EVENTS.get(name);
    }

    private EventTypes(String name, Class<T> hookType) {
        this.name = name;
        this.hookType = hookType;
    }

    public String type() {
        return this.name;
    }

    public Class<T> getHookType() {
        return this.hookType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.name.equals(((EventTypes)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

