/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.embed;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.http.Management;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.embed.Statistics;
import com.sun.grizzly.ssl.SSLSelectorThread;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapterChain;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.jsse.JSSEImplementation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class GrizzlyWebServer {
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_WEB_RESOURCES_PATH = ".";
    private SelectorThread st;
    private ObjectInstance stMBean;
    private GrizzlyAdapterChain adapterChains = new GrizzlyAdapterChain();
    private HashMap<GrizzlyAdapter, String[]> adapters = new HashMap();
    private boolean isStarted = false;
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private String webResourcesPath = ".";
    private String mBeanName = "com.sun.grizzly:type=GrizzlyWebServer,name=GrizzlyHttpEngine-8080";
    private Statistics statistics;
    private SSLConfig sslConfig;

    public GrizzlyWebServer() {
        this(8080);
    }

    public GrizzlyWebServer(int port) {
        this(port, DEFAULT_WEB_RESOURCES_PATH);
    }

    public GrizzlyWebServer(String webResourcesPath) {
        this(8080, webResourcesPath);
    }

    public GrizzlyWebServer(int port, int maxThreads) {
        this(port, maxThreads, DEFAULT_WEB_RESOURCES_PATH);
    }

    public GrizzlyWebServer(int port, String webResourcesPath) {
        this(port, 5, webResourcesPath);
    }

    public GrizzlyWebServer(int port, int maxThreads, String webResourcesPath) {
        this(port, maxThreads, webResourcesPath, false);
    }

    public GrizzlyWebServer(int port, int maxThreads, String webResourcesPath, boolean secure) {
        this.createSelectorThread(port, maxThreads, secure);
        this.webResourcesPath = webResourcesPath;
    }

    private void createSelectorThread(int port, int maxThreads, boolean secure) {
        if (secure) {
            SSLSelectorThread sslSelectorThread = new SSLSelectorThread();
            try {
                sslSelectorThread.setSSLImplementation((SSLImplementation)new JSSEImplementation());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            this.st = sslSelectorThread;
        } else {
            this.st = new SelectorThread();
        }
        this.st.setPort(port);
        this.st.setMaxThreads(maxThreads);
    }

    public SelectorThread getSelectorThread() {
        return this.st;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public void addGrizzlyAdapter(GrizzlyAdapter grizzlyAdapter) {
        this.adapters.put(grizzlyAdapter, new String[0]);
    }

    public void addGrizzlyAdapter(GrizzlyAdapter grizzlyAdapter, String[] mapping) {
        this.adapters.put(grizzlyAdapter, mapping);
    }

    public void setSSLConfig(SSLConfig sslConfig) {
        if (!(this.st instanceof SSLSelectorThread)) {
            throw new IllegalStateException("This instance isn't supporting SSL/HTTPS");
        }
        ((SSLSelectorThread)this.st).setSSLConfig(sslConfig);
    }

    public void useAsynchronousWrite(boolean asyncWrite) {
        this.st.setAsyncHttpWriteEnabled(asyncWrite);
    }

    public void start() throws IOException {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        if (this.adapters.size() == 0) {
            this.st.setAdapter((Adapter)new StaticResourcesAdapter(this.webResourcesPath));
        }
        if (this.adapters.size() == 1) {
            this.st.setAdapter((Adapter)this.adapters.keySet().iterator().next());
        } else {
            for (Map.Entry<GrizzlyAdapter, String[]> entry : this.adapters.entrySet()) {
                if (entry.getValue().length == 0) {
                    this.adapterChains.addGrizzlyAdapter(entry.getKey());
                    continue;
                }
                this.adapterChains.addGrizzlyAdapter(entry.getKey(), entry.getValue());
            }
            this.st.setAdapter((Adapter)this.adapterChains);
            this.adapterChains.setHandleStaticResources(true);
            this.adapterChains.setRootFolder(this.webResourcesPath);
        }
        if (this.asyncFilters.size() > 0) {
            this.st.setEnableAsyncExecution(true);
            DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
            for (AsyncFilter asyncFilter : this.asyncFilters) {
                asyncHandler.addAsyncFilter(asyncFilter);
            }
            this.st.setAsyncHandler(asyncHandler);
        }
        try {
            this.st.listen();
        }
        catch (InstantiationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void enableJMX(Management jmxManagement) {
        if (jmxManagement == null) {
            return;
        }
        this.st.setManagement(jmxManagement);
        try {
            ObjectName sname = new ObjectName(this.mBeanName);
            jmxManagement.registerComponent(this.st, sname, null);
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "Enabling JMX failed", ex);
        }
    }

    public Statistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = new Statistics(this.st);
        }
        return this.statistics;
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        this.st.stopEndpoint();
    }

    public static final GrizzlyWebServer newConfiguredInstance(String path) {
        GrizzlyWebServer ws = new GrizzlyWebServer(8080);
        ws.addGrizzlyAdapter(new GrizzlyAdapter(path){
            {
                this.setHandleStaticResources(true);
            }

            public void service(GrizzlyRequest request, GrizzlyResponse response) {
                try {
                    response.setStatus(404);
                    response.flushBuffer();
                }
                catch (IOException ex) {
                    Logger.getLogger(GrizzlyWebServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        return ws;
    }
}

