/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.universal.BASE64Decoder;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CommandNotFoundException;
import com.sun.enterprise.v3.admin.ParamTokenizer;
import com.sun.enterprise.v3.admin.UnacceptableValueException;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.UnsatisfiedDepedencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CommandRunner {
    public static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CommandRunner.class);
    public static final Logger logger = LogDomains.getLogger(ServerEnvironmentImpl.class, (String)"javax.enterprise.system.tools.admin");
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";
    @Inject
    Habitat habitat;
    @Inject
    ClassLoaderHierarchy clh;

    public ActionReport doCommand(String commandName, Properties parameters, ActionReport report) {
        return this.doCommand(commandName, parameters, report, null);
    }

    public ActionReport doCommand(String commandName, Properties parameters, ActionReport report, List<File> uploadedFiles) {
        AdminCommand handler = this.getCommand(commandName, report, logger);
        if (handler == null) {
            return report;
        }
        return this.doCommand(commandName, handler, parameters, report, uploadedFiles);
    }

    public ActionReport doCommand(String commandName, AdminCommand command, Properties parameters, ActionReport report) {
        return this.doCommand(commandName, command, parameters, report, null);
    }

    public ActionReport doCommand(String commandName, final Object parameters, ActionReport report, List<File> uploadedFiles) {
        AdminCommand command = this.getCommand(commandName, report, logger);
        if (command == null) {
            return report;
        }
        InjectionManager<Param> injectionMgr = new InjectionManager<Param>(){

            protected boolean isOptional(Param annotation) {
                return annotation.optional();
            }

            protected Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
                Param param = target.getAnnotation(Param.class);
                String acceptable = param.acceptableValues();
                String paramName = CommandRunner.this.getParamName(param, target);
                if (target instanceof Field) {
                    Field targetField = (Field)target;
                    try {
                        Field sourceField = parameters.getClass().getField(targetField.getName());
                        targetField.setAccessible(true);
                        Object paramValue = sourceField.get(parameters);
                        if (paramValue != null) {
                            CommandRunner.this.checkAgainstAcceptableValues(target, paramValue.toString());
                        }
                        return paramValue;
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
        return this.doCommand(commandName, command, injectionMgr, report, uploadedFiles);
    }

    public ActionReport doCommand(String commandName, final AdminCommand command, InjectionManager<Param> injector, ActionReport report, List<File> uploadedFiles) {
        report.setActionDescription(commandName + " AdminCommand");
        final AdminCommandContext context = new AdminCommandContext(LogDomains.getLogger(ServerEnvironmentImpl.class, (String)"javax.enterprise.system.tools.admin"), report, uploadedFiles);
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = command.getClass().getAnnotation(I18n.class);
        String i18n_key = "";
        if (i18n != null) {
            i18n_key = i18n.value();
        }
        try {
            injector.inject((Object)command, Param.class);
        }
        catch (UnsatisfiedDepedencyException e) {
            Param param = e.getUnsatisfiedElement().getAnnotation(Param.class);
            String paramName = this.getParamName(param, e.getUnsatisfiedElement());
            String paramDesc = this.getParamDescription(localStrings, i18n_key, paramName, e.getUnsatisfiedElement());
            String usage = this.getUsageText(command);
            String errorMsg = param.primary() ? adminStrings.getLocalString("commandrunner.operand.required", "Operand required.") : (param.password() ? adminStrings.getLocalString("adapter.param.missing.passwordfile", "{0} command requires the passwordfile parameter containing {1} entry.", new Object[]{commandName, paramName}) : (paramDesc != null ? adminStrings.getLocalString("admin.param.missing", "{0} command requires the {1} parameter : {2}", new Object[]{commandName, paramName, paramDesc}) : adminStrings.getLocalString("admin.param.missing.nodesc", "{0} command requires the {1} parameter", new Object[]{commandName, paramName})));
            logger.severe(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(usage);
            return report;
        }
        catch (ComponentException e) {
            Throwable exception = e;
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof UnacceptableValueException) {
                exception = (Exception)cause;
            }
            logger.severe(exception.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(this.getUsageText(command));
            return report;
        }
        final AdminCommand wrappedComamnd = new AdminCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(AdminCommandContext context) {
                ClassLoader ccl;
                Thread thread = Thread.currentThread();
                ClassLoader origCL = thread.getContextClassLoader();
                if (origCL != (ccl = CommandRunner.this.clh.getCommonClassLoader())) {
                    try {
                        thread.setContextClassLoader(ccl);
                        command.execute(context);
                    }
                    finally {
                        thread.setContextClassLoader(origCL);
                    }
                } else {
                    command.execute(context);
                }
            }
        };
        Async async = command.getClass().getAnnotation(Async.class);
        if (async == null) {
            try {
                wrappedComamnd.execute(context);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, adminStrings.getLocalString("adapter.exception", "Exception in command execution : ", new Object[]{e}), e);
                report.setMessage(e.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
            }
        } else {
            Thread t = new Thread(){

                public void run() {
                    try {
                        wrappedComamnd.execute(context);
                    }
                    catch (RuntimeException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            t.setPriority(async.priority());
            t.start();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(adminStrings.getLocalString("adapter.command.launch", "Command {0} was successfully initiated asynchronously.", new Object[]{commandName}));
        }
        return context.getActionReport();
    }

    public ActionReport doCommand(String commandName, AdminCommand command, final Properties parameters, ActionReport report, List<File> uploadedFiles) {
        if (parameters.get("help") != null) {
            InputStream in = this.getManPage(commandName, command);
            String manPage = this.encodeManPage(in);
            if (manPage != null) {
                report.getTopMessagePart().addProperty("MANPAGE", manPage);
            } else {
                report.getTopMessagePart().addProperty("GeneratedHelp", "true");
                this.getHelp(commandName, command, report);
            }
            return report;
        }
        try {
            if (!this.skipValidation(command)) {
                this.validateParameters(command, parameters);
            }
        }
        catch (ComponentException e) {
            Throwable exception = e;
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof UnacceptableValueException) {
                exception = (Exception)cause;
            }
            logger.severe(exception.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(this.getUsageText(command));
            return report;
        }
        InjectionManager<Param> injectionMgr = new InjectionManager<Param>(){

            protected boolean isOptional(Param annotation) {
                return annotation.optional();
            }

            protected Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
                String value;
                Param param = target.getAnnotation(Param.class);
                String acceptable = param.acceptableValues();
                String paramName = CommandRunner.this.getParamName(param, target);
                if (param.primary() && (value = parameters.getProperty("DEFAULT")) != null) {
                    parameters.setProperty(paramName, value);
                    return CommandRunner.this.convertStringToObject(paramName, type, value);
                }
                String paramValueStr = CommandRunner.this.getParamValueString(parameters, param, target);
                if (CommandRunner.this.ok(acceptable) && CommandRunner.this.ok(paramValueStr)) {
                    String[] ss = acceptable.split(",");
                    boolean ok = false;
                    for (String s : ss) {
                        if (!paramValueStr.equals(s.trim())) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.unacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", new Object[]{paramName, paramValueStr, acceptable}));
                    }
                }
                if (paramValueStr != null) {
                    return CommandRunner.this.convertStringToObject(paramName, type, paramValueStr);
                }
                return CommandRunner.this.getParamField(component, target);
            }
        };
        return this.doCommand(commandName, command, injectionMgr, report, uploadedFiles);
    }

    private void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
        Param param = target.getAnnotation(Param.class);
        String acceptable = param.acceptableValues();
        String paramName = this.getParamName(param, target);
        if (this.ok(acceptable) && this.ok(paramValueStr)) {
            String[] ss = acceptable.split(",");
            boolean ok = false;
            for (String s : ss) {
                if (!paramValueStr.equals(s.trim())) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.unacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", new Object[]{paramName, paramValueStr, acceptable}));
            }
        }
    }

    protected String getParamDescription(LocalStringManagerImpl localStrings, String i18nKey, String paramName, AnnotatedElement annotated) {
        I18n i18n = annotated.getAnnotation(I18n.class);
        String paramDesc = i18n == null ? localStrings.getLocalString(i18nKey + "." + paramName, "") : localStrings.getLocalString(i18n.value(), "");
        if (paramDesc == null) {
            paramDesc = "";
        }
        return paramDesc;
    }

    String getParamName(Param param, AnnotatedElement annotated) {
        if (param.name().equals("")) {
            if (annotated instanceof Field) {
                return ((Field)annotated).getName();
            }
            if (annotated instanceof Method) {
                return ((Method)annotated).getName().substring(3).toLowerCase();
            }
        } else {
            if (param.password()) {
                return ASADMIN_CMD_PREFIX + param.name().toUpperCase();
            }
            return param.name();
        }
        return "";
    }

    String getParamValueString(Properties parameters, Param param, AnnotatedElement target) {
        String paramValueStr = this.getPropertiesValue(parameters, this.getParamName(param, target), true);
        if (paramValueStr == null) {
            paramValueStr = parameters.getProperty(param.shortName());
        }
        if (paramValueStr == null) {
            String defaultValue = param.defaultValue();
            paramValueStr = defaultValue.equals("") ? null : defaultValue;
        }
        return paramValueStr;
    }

    Object getParamField(Object component, AnnotatedElement annotated) {
        try {
            if (annotated instanceof Field) {
                Field field = (Field)annotated;
                field.setAccessible(true);
                return ((Field)annotated).get(component);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    Object convertStringToObject(String paramName, Class type, String paramValStr) {
        String[] paramValue = paramValStr;
        if (type.isAssignableFrom(String.class)) {
            paramValue = paramValStr;
        } else if (type.isAssignableFrom(Properties.class)) {
            paramValue = this.convertStringToProperties(paramValStr);
        } else if (type.isAssignableFrom(List.class)) {
            paramValue = this.convertStringToList(paramValStr);
        } else if (type.isAssignableFrom(Boolean.class)) {
            paramValue = this.convertStringToBoolean(paramName, paramValStr);
        } else if (type.isAssignableFrom(String[].class)) {
            paramValue = this.convertStringToStringArray(paramValStr);
        } else if (type.isAssignableFrom(File.class)) {
            return new File(paramValStr);
        }
        return paramValue;
    }

    String getPropertiesValue(Properties props, String key, boolean ignoreCase) {
        BASE64Decoder base64Decoder = new BASE64Decoder();
        if (ignoreCase) {
            for (Object propObj : props.keySet()) {
                String propName = (String)propObj;
                if (!propName.equalsIgnoreCase(key)) continue;
                try {
                    if (propName.startsWith(ASADMIN_CMD_PREFIX)) {
                        return new String(base64Decoder.decodeBuffer(props.getProperty(propName)));
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                return props.getProperty(propName);
            }
        }
        return props.getProperty(key);
    }

    private AdminCommand getCommand(String commandName, ActionReport report, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
        if (command == null) {
            String msg;
            if (!this.ok(commandName)) {
                msg = adminStrings.getLocalString("adapter.command.nocommand", "No command was specified.");
            } else {
                msg = adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{commandName});
                report.setFailureCause((Throwable)new CommandNotFoundException(msg));
            }
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            LogHelper.getDefaultLogger().info(msg);
        }
        return command;
    }

    String getUsageText(AdminCommand command) {
        StringBuffer usageText = new StringBuffer();
        I18n i18n = command.getClass().getAnnotation(I18n.class);
        String i18nKey = null;
        LocalStringManagerImpl lsm = new LocalStringManagerImpl(command.getClass());
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        if (i18nKey == null) {
            return this.generateUsageText(command);
        }
        usageText.append(lsm.getLocalString(i18nKey + ".usagetext", this.generateUsageText(command)));
        return usageText.toString();
    }

    private String generateUsageText(AdminCommand command) {
        StringBuffer usageText = new StringBuffer();
        usageText.append("Usage: ");
        usageText.append(command.getClass().getAnnotation(Service.class).name());
        usageText.append(" ");
        StringBuffer operand = new StringBuffer();
        for (Field f : command.getClass().getDeclaredFields()) {
            String paramName;
            Param param = f.getAnnotation(Param.class);
            if (param == null || (paramName = this.getParamName(param, f)).startsWith(ASADMIN_CMD_PREFIX)) continue;
            boolean optional = param.optional();
            Class<Object> ftype = f.getType();
            Object fvalue = null;
            String fvalueString = null;
            try {
                f.setAccessible(true);
                fvalue = f.get(command);
                if (fvalue != null) {
                    fvalueString = fvalue.toString();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (param.primary()) {
                if (optional) {
                    operand.append("[").append(paramName).append("] ");
                    continue;
                }
                operand.append(paramName).append(" ");
                continue;
            }
            if (optional) {
                usageText.append("[");
            }
            usageText.append("--").append(paramName);
            if (this.ok(param.defaultValue())) {
                usageText.append("=").append(param.defaultValue());
                if (optional) {
                    usageText.append("] ");
                    continue;
                }
                usageText.append(" ");
                continue;
            }
            if (ftype.isAssignableFrom(String.class)) {
                if (this.ok(fvalueString)) {
                    usageText.append("=").append(fvalueString);
                    if (optional) {
                        usageText.append("] ");
                        continue;
                    }
                    usageText.append(" ");
                    continue;
                }
                usageText.append("=").append(paramName);
                if (optional) {
                    usageText.append("] ");
                    continue;
                }
                usageText.append(" ");
                continue;
            }
            if (ftype.isAssignableFrom(Boolean.class)) {
                usageText.append("=").append("true|false");
                if (optional) {
                    usageText.append("] ");
                    continue;
                }
                usageText.append(" ");
                continue;
            }
            usageText.append("=").append(paramName);
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
        usageText.append(operand);
        return usageText.toString();
    }

    public void getHelp(String commandName, AdminCommand command, ActionReport report) {
        report.setActionDescription(commandName + " help");
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = command.getClass().getAnnotation(I18n.class);
        String i18nKey = "";
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        report.setMessage(commandName + " - " + localStrings.getLocalString(i18nKey, ""));
        report.getTopMessagePart().addProperty("SYNOPSIS", this.getUsageText(command));
        for (Field field : command.getClass().getDeclaredFields()) {
            this.addParamUsage(report, localStrings, i18nKey, field);
        }
        for (AccessibleObject accessibleObject : command.getClass().getDeclaredMethods()) {
            this.addParamUsage(report, localStrings, i18nKey, accessibleObject);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public InputStream getManPage(String commandName, AdminCommand command) {
        Class<?> clazz = command.getClass();
        Package pkg = clazz.getPackage();
        String manPage = pkg.getName().replace('.', '/');
        manPage = manPage + "/" + commandName + ".1";
        ClassLoader loader = clazz.getClassLoader();
        InputStream in = loader.getResourceAsStream(manPage);
        return in;
    }

    private void addParamUsage(ActionReport report, LocalStringManagerImpl localStrings, String i18nKey, AnnotatedElement annotated) {
        Param param = annotated.getAnnotation(Param.class);
        if (param != null) {
            String paramName = this.getParamName(param, annotated);
            if (paramName.startsWith(ASADMIN_CMD_PREFIX)) {
                return;
            }
            if (param.primary()) {
                report.getTopMessagePart().addProperty(paramName + "_operand", this.getParamDescription(localStrings, i18nKey, paramName, annotated));
            } else {
                report.getTopMessagePart().addProperty(paramName, this.getParamDescription(localStrings, i18nKey, paramName, annotated));
            }
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    void validateParameters(AdminCommand command, Properties parameters) throws ComponentException {
        Enumeration<?> e = parameters.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key == null || "DEFAULT".equals(key) || key.startsWith(ASADMIN_CMD_PREFIX)) continue;
            boolean validOption = false;
            Class<?> commandClass = command.getClass();
            while (!validOption && commandClass != null) {
                for (Field field : commandClass.getDeclaredFields()) {
                    Param param = field.getAnnotation(Param.class);
                    if (param == null) continue;
                    if (key.startsWith(ASADMIN_CMD_PREFIX)) {
                        validOption = true;
                        continue;
                    }
                    if (!field.getName().equals(key) && !param.name().equals(key) && !param.shortName().equals(key)) continue;
                    validOption = true;
                    break;
                }
                if (validOption) continue;
                commandClass = commandClass.getSuperclass();
            }
            if (validOption) continue;
            throw new ComponentException(" Invalid option: " + key);
        }
    }

    Boolean convertStringToBoolean(String paramName, String s) {
        if (!this.ok(s)) {
            return true;
        }
        if (s.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        if (s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        String msg = adminStrings.getLocalString("adapter.command.unacceptableBooleanValue", "Invalid parameter: {0}.  This boolean option must be set (case insensitive) to true or false.  Its value was set to {1}", new Object[]{paramName, s});
        throw new UnacceptableValueException(msg);
    }

    Properties convertStringToProperties(String propsString) {
        Properties properties = new Properties();
        if (propsString != null) {
            ParamTokenizer stoken = new ParamTokenizer(propsString, ":");
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextToken();
                if (token.indexOf("=") == -1) continue;
                ParamTokenizer nameTok = new ParamTokenizer(token, "=");
                if (nameTok.countTokens() == 2) {
                    properties.setProperty(nameTok.nextTokenWithoutEscapeAndQuoteChars(), nameTok.nextTokenWithoutEscapeAndQuoteChars());
                    continue;
                }
                throw new IllegalArgumentException(adminStrings.getLocalString("InvalidPropertySyntax", "Invalid property syntax."));
            }
        }
        return properties;
    }

    List<String> convertStringToList(String listString) {
        ArrayList<String> list = new ArrayList<String>();
        if (listString != null) {
            ParamTokenizer ptoken = new ParamTokenizer(listString, ":");
            while (ptoken.hasMoreTokens()) {
                String token = ptoken.nextTokenWithoutEscapeAndQuoteChars();
                list.add(token);
            }
        }
        return list;
    }

    String[] convertStringToStringArray(String arrayString) {
        ParamTokenizer paramTok = new ParamTokenizer(arrayString, ",");
        String[] strArray = new String[paramTok.countTokens()];
        int ii = 0;
        while (paramTok.hasMoreTokens()) {
            strArray[ii++] = paramTok.nextTokenWithoutEscapeAndQuoteChars();
        }
        return strArray;
    }

    boolean skipValidation(AdminCommand command) {
        try {
            Field f = command.getClass().getDeclaredField("skipParamValidation");
            f.setAccessible(true);
            if (f.getType().isAssignableFrom(Boolean.TYPE)) {
                return f.getBoolean(command);
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return false;
    }

    private String encodeManPage(InputStream in) {
        String eolToken = "%%%EOL%%%";
        try {
            String line;
            if (in == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("%%%EOL%%%");
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

