/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncQueueFuture<E>
implements Future<E> {
    private CountDownLatch latch = new CountDownLatch(1);
    private E result;
    private boolean isCancelled;
    private Throwable exception;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.isCancelled = true;
        this.notifyResult();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() < 1L;
    }

    @Override
    public E get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public E get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.latch.await(timeout, unit);
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    public E getResult() {
        return this.result;
    }

    public void setResult(E result) {
        this.result = result;
        this.notifyResult();
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
        this.notifyResult();
    }

    protected void notifyResult() {
        this.latch.countDown();
    }
}

