/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.ContentClassLoader;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.ISearchPolicy;
import org.apache.felix.moduleloader.IURLPolicy;

public class ContentLoaderImpl
implements IContentLoader {
    private final Logger m_logger;
    private final IContent m_content;
    private IContent[] m_contentPath;
    private IContent[] m_fragmentContents = null;
    private ISearchPolicy m_searchPolicy = null;
    private IURLPolicy m_urlPolicy = null;
    private ContentClassLoader m_classLoader;
    private ProtectionDomain m_protectionDomain = null;
    private static SecureAction m_secureAction = new SecureAction();

    public ContentLoaderImpl(Logger logger, IContent content) {
        this.m_logger = logger;
        this.m_content = content;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public synchronized void close() {
        int i;
        this.m_content.close();
        for (i = 0; this.m_contentPath != null && i < this.m_contentPath.length; ++i) {
            this.m_contentPath[i].close();
        }
        for (i = 0; this.m_fragmentContents != null && i < this.m_fragmentContents.length; ++i) {
            this.m_fragmentContents[i].close();
        }
    }

    public IContent getContent() {
        return this.m_content;
    }

    public synchronized IContent[] getClassPath() {
        if (this.m_contentPath == null) {
            try {
                this.m_contentPath = this.initializeContentPath();
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Unable to get module class path.", ex);
            }
        }
        return this.m_contentPath;
    }

    public synchronized void attachFragmentContents(IContent[] fragmentContents) throws Exception {
        int i;
        if (this.m_fragmentContents != null) {
            for (i = 0; i < this.m_fragmentContents.length; ++i) {
                this.m_fragmentContents[i].close();
            }
        }
        this.m_fragmentContents = fragmentContents;
        if (this.m_contentPath != null) {
            for (i = 0; i < this.m_contentPath.length; ++i) {
                this.m_contentPath[i].close();
            }
        }
        this.m_contentPath = this.initializeContentPath();
    }

    public synchronized void setSearchPolicy(ISearchPolicy searchPolicy) {
        this.m_searchPolicy = searchPolicy;
    }

    public synchronized ISearchPolicy getSearchPolicy() {
        return this.m_searchPolicy;
    }

    public synchronized void setURLPolicy(IURLPolicy urlPolicy) {
        this.m_urlPolicy = urlPolicy;
    }

    public synchronized IURLPolicy getURLPolicy() {
        return this.m_urlPolicy;
    }

    public synchronized void setSecurityContext(Object securityContext) {
        this.m_protectionDomain = (ProtectionDomain)securityContext;
    }

    public synchronized Object getSecurityContext() {
        return this.m_protectionDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getClass(String name) {
        ContentLoaderImpl contentLoaderImpl = this;
        synchronized (contentLoaderImpl) {
            if (this.m_classLoader == null) {
                this.m_classLoader = m_secureAction.createContentClassLoader(this, this.m_protectionDomain);
            }
        }
        try {
            return this.m_classLoader.loadClassFromModule(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public URL getResource(String name) {
        URL url = null;
        if (name.equals("/")) {
            url = this.getURLPolicy().createURL(1, name);
        } else if (name.startsWith("/")) {
            name = name.substring(1);
        }
        IContent[] contentPath = this.getClassPath();
        for (int i = 0; url == null && i < contentPath.length; ++i) {
            if (!contentPath[i].hasEntry(name)) continue;
            url = this.getURLPolicy().createURL(i + 1, name);
        }
        return url;
    }

    public Enumeration getResources(String name) {
        Vector<URL> v = new Vector<URL>();
        if (name.equals("/")) {
            for (int i = 0; i < this.getClassPath().length; ++i) {
                v.addElement(this.getURLPolicy().createURL(i + 1, name));
            }
        } else {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            IContent[] contentPath = this.getClassPath();
            for (int i = 0; i < contentPath.length; ++i) {
                if (!contentPath[i].hasEntry(name)) continue;
                v.addElement(this.getURLPolicy().createURL(i + 1, name));
            }
        }
        return v.elements();
    }

    public URL getResourceFromContent(String name) {
        URL url = null;
        if (name.equals("/")) {
            url = this.getURLPolicy().createURL(0, "/");
        }
        if (url == null) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (this.getContent().hasEntry(name)) {
                url = this.getURLPolicy().createURL(0, name);
            }
        }
        return url;
    }

    public boolean hasInputStream(int index, String urlPath) {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (index == 0) {
            return this.m_content.hasEntry(urlPath);
        }
        return this.getClassPath()[index - 1].hasEntry(urlPath);
    }

    public InputStream getInputStream(int index, String urlPath) throws IOException {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (index == 0) {
            return this.m_content.getEntryAsStream(urlPath);
        }
        return this.getClassPath()[index - 1].getEntryAsStream(urlPath);
    }

    public synchronized String toString() {
        return this.m_searchPolicy.toString();
    }

    private IContent[] initializeContentPath() throws Exception {
        ArrayList contentList = new ArrayList();
        this.calculateContentPath(this.m_content, contentList, true);
        for (int i = 0; this.m_fragmentContents != null && i < this.m_fragmentContents.length; ++i) {
            this.calculateContentPath(this.m_fragmentContents[i], contentList, false);
        }
        return contentList.toArray(new IContent[contentList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List calculateContentPath(IContent content, List contentList, boolean searchFragments) throws Exception {
        ArrayList<IContent> localContentList = new ArrayList<IContent>();
        InputStream is = null;
        StringMap headers = null;
        try {
            is = content.getEntryAsStream("META-INF/MANIFEST.MF");
            headers = new StringMap(new Manifest(is).getMainAttributes(), false);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String classPath = headers == null ? null : (String)headers.get("Bundle-ClassPath");
        String[] classPathStrings = ManifestParser.parseDelimitedString(classPath, ",");
        if (classPathStrings == null) {
            classPathStrings = new String[]{};
        }
        for (int i = 0; i < classPathStrings.length; ++i) {
            String string = classPathStrings[i] = classPathStrings[i].startsWith("/") ? classPathStrings[i].substring(1) : classPathStrings[i];
            if (classPathStrings[i].equals(".")) {
                localContentList.add(content);
                continue;
            }
            IContent embeddedContent = content.getEntryAsContent(classPathStrings[i]);
            for (int fragIdx = 0; searchFragments && embeddedContent == null && this.m_fragmentContents != null && fragIdx < this.m_fragmentContents.length; ++fragIdx) {
                embeddedContent = this.m_fragmentContents[fragIdx].getEntryAsContent(classPathStrings[i]);
            }
            if (embeddedContent != null) {
                localContentList.add(embeddedContent);
                continue;
            }
            this.m_logger.log(3, "Class path entry not found: " + classPathStrings[i]);
        }
        if (localContentList.size() == 0) {
            localContentList.add(content);
        }
        contentList.addAll(localContentList);
        return contentList;
    }
}

